/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop.config;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.authorization.hadoop.config.RangerLegacyConfigBuilder;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerPluginConfig
extends RangerConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(RangerPluginConfig.class);
    private static final char RANGER_TRUSTED_PROXY_IPADDRESSES_SEPARATOR_CHAR = ',';
    private final String serviceType;
    private final String serviceName;
    private final String appId;
    private final String clusterName;
    private final String clusterType;
    private final RangerPolicyEngineOptions policyEngineOptions;
    private final boolean useForwardedIPAddress;
    private final String[] trustedProxyAddresses;
    private final String propertyPrefix;
    private boolean isFallbackSupported;
    private Set<String> auditExcludedUsers = Collections.emptySet();
    private Set<String> auditExcludedGroups = Collections.emptySet();
    private Set<String> auditExcludedRoles = Collections.emptySet();
    private Set<String> superUsers = Collections.emptySet();
    private Set<String> superGroups = Collections.emptySet();
    private Set<String> serviceAdmins = Collections.emptySet();

    public RangerPluginConfig(String serviceType, String serviceName, String appId, String clusterName, String clusterType, RangerPolicyEngineOptions policyEngineOptions) {
        this.addResourcesForServiceType(serviceType);
        this.serviceType = serviceType;
        this.appId = StringUtils.isEmpty((String)appId) ? serviceType : appId;
        this.propertyPrefix = "ranger.plugin." + serviceType;
        this.serviceName = StringUtils.isEmpty((String)serviceName) ? this.get(this.propertyPrefix + ".service.name") : serviceName;
        this.addResourcesForServiceName(this.serviceType, this.serviceName);
        String trustedProxyAddressString = this.get(this.propertyPrefix + ".trusted.proxy.ipaddresses");
        if (StringUtil.isEmpty(clusterName) && StringUtil.isEmpty(clusterName = this.get(this.propertyPrefix + ".access.cluster.name", ""))) {
            clusterName = this.get(this.propertyPrefix + ".ambari.cluster.name", "");
        }
        if (StringUtil.isEmpty(clusterType) && StringUtil.isEmpty(clusterType = this.get(this.propertyPrefix + ".access.cluster.type", ""))) {
            clusterType = this.get(this.propertyPrefix + ".ambari.cluster.type", "");
        }
        this.clusterName = clusterName;
        this.clusterType = clusterType;
        this.useForwardedIPAddress = this.getBoolean(this.propertyPrefix + ".use.x-forwarded-for.ipaddress", false);
        this.trustedProxyAddresses = StringUtils.split((String)trustedProxyAddressString, (char)',');
        if (this.trustedProxyAddresses != null) {
            for (int i = 0; i < this.trustedProxyAddresses.length; ++i) {
                this.trustedProxyAddresses[i] = this.trustedProxyAddresses[i].trim();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.propertyPrefix + ".use.x-forwarded-for.ipaddress:" + this.useForwardedIPAddress);
            LOG.debug(this.propertyPrefix + ".trusted.proxy.ipaddresses:[" + StringUtils.join((Object[])this.trustedProxyAddresses, (String)", ") + "]");
        }
        if (this.useForwardedIPAddress && StringUtils.isBlank((String)trustedProxyAddressString)) {
            LOG.warn("Property " + this.propertyPrefix + ".use.x-forwarded-for.ipaddress is set to true, and Property " + this.propertyPrefix + ".trusted.proxy.ipaddresses is not set");
            LOG.warn("Ranger plugin will trust RemoteIPAddress and treat first X-Forwarded-Address in the access-request as the clientIPAddress");
        }
        if (policyEngineOptions == null) {
            policyEngineOptions = new RangerPolicyEngineOptions();
            policyEngineOptions.configureForPlugin(this, this.propertyPrefix);
        }
        this.policyEngineOptions = policyEngineOptions;
        LOG.info("", (Object)policyEngineOptions);
    }

    protected RangerPluginConfig(String serviceType, String serviceName, String appId, RangerPluginConfig sourcePluginConfig) {
        this.serviceType = serviceType;
        this.appId = StringUtils.isEmpty((String)appId) ? serviceType : appId;
        this.propertyPrefix = "ranger.plugin." + serviceType;
        this.serviceName = serviceName;
        this.clusterName = sourcePluginConfig.getClusterName();
        this.clusterType = sourcePluginConfig.getClusterType();
        this.useForwardedIPAddress = sourcePluginConfig.isUseForwardedIPAddress();
        this.trustedProxyAddresses = sourcePluginConfig.getTrustedProxyAddresses();
        this.isFallbackSupported = sourcePluginConfig.getIsFallbackSupported();
        this.policyEngineOptions = sourcePluginConfig.getPolicyEngineOptions();
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getClusterType() {
        return this.clusterType;
    }

    public boolean isUseForwardedIPAddress() {
        return this.useForwardedIPAddress;
    }

    public String[] getTrustedProxyAddresses() {
        return this.trustedProxyAddresses;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public boolean getIsFallbackSupported() {
        return this.isFallbackSupported;
    }

    public void setIsFallbackSupported(boolean isFallbackSupported) {
        this.isFallbackSupported = isFallbackSupported;
    }

    public RangerPolicyEngineOptions getPolicyEngineOptions() {
        return this.policyEngineOptions;
    }

    public void setAuditExcludedUsersGroupsRoles(Set<String> users, Set<String> groups, Set<String> roles) {
        this.auditExcludedUsers = CollectionUtils.isEmpty(users) ? Collections.emptySet() : new HashSet<String>(users);
        this.auditExcludedGroups = CollectionUtils.isEmpty(groups) ? Collections.emptySet() : new HashSet<String>(groups);
        HashSet<String> hashSet = this.auditExcludedRoles = CollectionUtils.isEmpty(roles) ? Collections.emptySet() : new HashSet<String>(roles);
        if (LOG.isDebugEnabled()) {
            LOG.debug("auditExcludedUsers=" + this.auditExcludedUsers + ", auditExcludedGroups=" + this.auditExcludedGroups + ", auditExcludedRoles=" + this.auditExcludedRoles);
        }
    }

    public void setSuperUsersGroups(Set<String> users, Set<String> groups) {
        this.superUsers = CollectionUtils.isEmpty(users) ? Collections.emptySet() : new HashSet<String>(users);
        HashSet<String> hashSet = this.superGroups = CollectionUtils.isEmpty(groups) ? Collections.emptySet() : new HashSet<String>(groups);
        if (LOG.isDebugEnabled()) {
            LOG.debug("superUsers=" + this.superUsers + ", superGroups=" + this.superGroups);
        }
    }

    public void setServiceAdmins(Set<String> users) {
        this.serviceAdmins = CollectionUtils.isEmpty(users) ? Collections.emptySet() : new HashSet<String>(users);
    }

    public boolean isAuditExcludedUser(String userName) {
        return this.auditExcludedUsers.contains(userName);
    }

    public boolean hasAuditExcludedGroup(Set<String> userGroups) {
        return userGroups != null && userGroups.size() > 0 && this.auditExcludedGroups.size() > 0 && CollectionUtils.containsAny(userGroups, this.auditExcludedGroups);
    }

    public boolean hasAuditExcludedRole(Set<String> userRoles) {
        return userRoles != null && userRoles.size() > 0 && this.auditExcludedRoles.size() > 0 && CollectionUtils.containsAny(userRoles, this.auditExcludedRoles);
    }

    public boolean isSuperUser(String userName) {
        return this.superUsers.contains(userName);
    }

    public boolean hasSuperGroup(Set<String> userGroups) {
        return userGroups != null && userGroups.size() > 0 && this.superGroups.size() > 0 && CollectionUtils.containsAny(userGroups, this.superGroups);
    }

    public boolean isServiceAdmin(String userName) {
        return this.serviceAdmins.contains(userName);
    }

    private void addResourcesForServiceType(String serviceType) {
        String auditCfg = "ranger-" + serviceType + "-audit.xml";
        String securityCfg = "ranger-" + serviceType + "-security.xml";
        String sslCfg = "ranger-" + serviceType + "-policymgr-ssl.xml";
        if (!this.addResourceIfReadable(auditCfg)) {
            this.addAuditResource(serviceType);
        }
        if (!this.addResourceIfReadable(securityCfg)) {
            this.addSecurityResource(serviceType);
        }
        if (!this.addResourceIfReadable(sslCfg)) {
            this.addSslConfigResource(serviceType);
        }
    }

    private void addResourcesForServiceName(String serviceType, String serviceName) {
        if (StringUtils.isNotBlank((String)serviceType) && StringUtils.isNotBlank((String)serviceName)) {
            String serviceAuditCfg = "ranger-" + serviceType + "-" + serviceName + "-audit.xml";
            String serviceSecurityCfg = "ranger-" + serviceType + "-" + serviceName + "-security.xml";
            String serviceSslCfg = "ranger-" + serviceType + "-" + serviceName + "-policymgr-ssl.xml";
            this.addResourceIfReadable(serviceAuditCfg);
            this.addResourceIfReadable(serviceSecurityCfg);
            this.addResourceIfReadable(serviceSslCfg);
        }
    }

    private void addSecurityResource(String serviceType) {
        Configuration rangerConf;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> addSecurityResource(Service Type: " + serviceType);
        }
        if ((rangerConf = RangerLegacyConfigBuilder.getSecurityConfig(serviceType)) != null) {
            this.addResource(rangerConf);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Unable to add the Security Config for " + serviceType + ". Plugin won't be enabled!");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<= addSecurityResource(Service Type: " + serviceType);
        }
    }

    private void addAuditResource(String serviceType) {
        block6: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> addAuditResource(Service Type: " + serviceType);
            }
            try {
                URL url = RangerLegacyConfigBuilder.getAuditConfig(serviceType);
                if (url != null) {
                    this.addResource(url);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("==> addAuditResource() URL" + url.getPath());
                    }
                }
            }
            catch (Throwable t) {
                LOG.warn("Unable to find Audit Config for " + serviceType + " Auditing not enabled !");
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug("Unable to find Audit Config for " + serviceType + " Auditing not enabled !" + t);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== addAuditResource(Service Type: " + serviceType + ")");
        }
    }

    private void addSslConfigResource(String serviceType) {
        block6: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> addSslConfigResource(Service Type: " + serviceType);
            }
            try {
                String sslConfigFile = this.get(RangerLegacyConfigBuilder.getPropertyName("ranger.plugin.<ServiceType>.policy.rest.ssl.config.file", serviceType));
                URL url = this.getSSLConfigResource(sslConfigFile);
                if (url != null) {
                    this.addResource(url);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("SSL config file URL:" + url.getPath());
                    }
                }
            }
            catch (Throwable t) {
                LOG.warn(" Unable to find SSL Configs");
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug(" Unable to find SSL Configs");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== addSslConfigResource(Service Type: " + serviceType + ")");
        }
    }

    private URL getSSLConfigResource(String fileName) throws Throwable {
        URL ret = null;
        try {
            File f;
            if (fileName != null && (f = new File(fileName)).exists() && f.canRead()) {
                ret = f.toURI().toURL();
            }
        }
        catch (Throwable t) {
            LOG.error("Unable to read SSL configuration file:" + fileName);
            throw t;
        }
        return ret;
    }
}

