/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.rocksdb.util;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksDB;
import org.rocksdb.LiveFileMetaData;
import org.rocksdb.RocksDB;

public final class RdbUtil {
    private RdbUtil() {
    }

    public static List<LiveFileMetaData> getLiveSSTFilesForCFs(ManagedRocksDB rocksDB, List<String> cfs) {
        HashSet cfSet = Sets.newHashSet(cfs);
        return ((RocksDB)rocksDB.get()).getLiveFilesMetaData().stream().filter(lfm -> cfSet.contains(StringUtils.bytes2String((byte[])lfm.columnFamilyName()))).collect(Collectors.toList());
    }

    public static Set<String> getSSTFilesForComparison(ManagedRocksDB rocksDB, List<String> cfs) {
        return RdbUtil.getLiveSSTFilesForCFs(rocksDB, cfs).stream().map(lfm -> new File(lfm.path(), lfm.fileName()).getPath()).collect(Collectors.toCollection(HashSet::new));
    }
}

