/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.token;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import picocli.CommandLine;

public class TokenOption {
    @CommandLine.Option(names={"--token", "-t"}, required=true, description={"file containing encoded token"})
    private File tokenFile;

    public boolean exists() {
        boolean exists;
        boolean bl = exists = this.tokenFile != null && this.tokenFile.exists();
        if (!exists) {
            System.err.println("Error: token operation failed as token file: " + this.tokenFile + " containing encoded token doesn't exist.");
        }
        return exists;
    }

    public Token<OzoneTokenIdentifier> decode() throws IOException {
        Credentials creds = new Credentials();
        try (FileInputStream fis = new FileInputStream(this.tokenFile);
             DataInputStream dis = new DataInputStream(fis);){
            creds.readTokenStorageStream(dis);
        }
        for (Token token : creds.getAllTokens()) {
            if (!token.getKind().equals((Object)OzoneTokenIdentifier.KIND_NAME)) continue;
            return token;
        }
        return null;
    }

    public void persistToken(Token<OzoneTokenIdentifier> token) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(this.tokenFile);
             DataOutputStream dos = new DataOutputStream(fos);){
            Credentials ts = new Credentials();
            ts.addToken(token.getService(), token);
            ts.writeTokenStorageToStream(dos);
            System.out.println("Token persisted to " + this.tokenFile.toString() + " successfully!");
        }
    }

    public String getTokenFilePath() {
        return this.tokenFile.getAbsolutePath();
    }
}

