/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.tenant;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.om.helpers.TenantUserList;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.s3.S3Handler;
import picocli.CommandLine;

@CommandLine.Command(name="list", aliases={"ls"}, description={"List users in a tenant"})
public class TenantListUsersHandler
extends S3Handler {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Parameters(description={"Tenant name"}, arity="1..1")
    private String tenantId;
    @CommandLine.Option(names={"--prefix", "-p"}, description={"Filter users with this prefix."})
    private String prefix;
    @CommandLine.Option(names={"--json", "-j"}, description={"Print detailed result in JSON"})
    private boolean printJson;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        TenantUserList usersInTenant = client.getObjectStore().listUsersInTenant(this.tenantId, this.prefix);
        if (!this.printJson) {
            usersInTenant.getUserAccessIds().forEach(accessIdInfo -> this.out().println("- User '" + accessIdInfo.getUserPrincipal() + "' with accessId '" + accessIdInfo.getAccessId() + "'"));
        } else {
            JsonArray resArray = new JsonArray();
            usersInTenant.getUserAccessIds().forEach(accessIdInfo -> {
                JsonObject obj = new JsonObject();
                obj.addProperty("user", accessIdInfo.getUserPrincipal());
                obj.addProperty("accessId", accessIdInfo.getAccessId());
                resArray.add((JsonElement)obj);
            });
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            this.out().println(gson.toJson((JsonElement)resArray));
        }
    }
}

