/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.tenant;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.om.helpers.TenantStateList;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.tenant.TenantHandler;
import picocli.CommandLine;

@CommandLine.Command(name="list", aliases={"ls"}, description={"List tenants"})
public class TenantListHandler
extends TenantHandler {
    @CommandLine.Option(names={"--json", "-j"}, description={"Print detailed result in JSON"})
    private boolean printJson;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        TenantStateList tenantStateList = client.getObjectStore().listTenant();
        if (!this.printJson) {
            tenantStateList.getTenantStateList().forEach(tenantState -> this.out().println(tenantState.getTenantId()));
        } else {
            JsonArray resArray = new JsonArray();
            tenantStateList.getTenantStateList().forEach(tenantState -> {
                JsonObject obj = new JsonObject();
                obj.addProperty("tenantId", tenantState.getTenantId());
                obj.addProperty("bucketNamespaceName", tenantState.getBucketNamespaceName());
                obj.addProperty("userRoleName", tenantState.getUserRoleName());
                obj.addProperty("adminRoleName", tenantState.getAdminRoleName());
                obj.addProperty("bucketNamespacePolicyName", tenantState.getBucketNamespacePolicyName());
                obj.addProperty("bucketPolicyName", tenantState.getBucketPolicyName());
                resArray.add((JsonElement)obj);
            });
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            this.out().println(gson.toJson((JsonElement)resArray));
        }
    }
}

