/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.codahale.metrics.Timer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.ozone.freon.S3EntityGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="s3kg", aliases={"s3-key-generator"}, description={"Create random keys via the s3 interface.Command requires AWS authentication environment variables set, AWS_ACCESS_KEY_ID and AWS_SECRET_ACCESS_KEY"}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class S3KeyGenerator
extends S3EntityGenerator
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(S3KeyGenerator.class);
    @CommandLine.Option(names={"-b", "--bucket"}, description={"Name of the (S3!) bucket which contains the test data."}, defaultValue="bucket1")
    private String bucketName;
    @CommandLine.Option(names={"-s", "--size"}, description={"Size of the generated key (in bytes) or size of one multipart upload part (in case of multipart upload)"}, defaultValue="10240")
    private int fileSize;
    @CommandLine.Option(names={"--multi-part-upload"}, description={"User multi part upload"}, defaultValue="false")
    private boolean multiPart;
    @CommandLine.Option(names={"--parts"}, description={"Number of parts for multipart upload (final size = --size * --parts)"}, defaultValue="10")
    private int numberOfParts;
    private Timer timer;
    private String content;

    @Override
    public Void call() throws Exception {
        if (this.multiPart && this.fileSize < 0x500000) {
            throw new IllegalArgumentException("Size of multipart upload parts should be at least 5MB (5242880)");
        }
        this.s3ClientInit();
        this.content = RandomStringUtils.randomAscii((int)this.fileSize);
        this.timer = this.getMetrics().timer("key-create");
        System.setProperty("com.amazonaws.services.s3.disablePutObjectMD5Validation", "true");
        this.runTests(this::createKey);
        return null;
    }

    private void createKey(long counter) throws Exception {
        this.timer.time(() -> {
            if (this.multiPart) {
                String keyName = this.generateObjectName(counter);
                InitiateMultipartUploadRequest initiateRequest = new InitiateMultipartUploadRequest(this.bucketName, keyName);
                InitiateMultipartUploadResult initiateMultipartUploadResult = this.getS3().initiateMultipartUpload(initiateRequest);
                String uploadId = initiateMultipartUploadResult.getUploadId();
                ArrayList<PartETag> parts = new ArrayList<PartETag>();
                for (int i = 1; i <= this.numberOfParts; ++i) {
                    UploadPartRequest uploadPartRequest = new UploadPartRequest().withBucketName(this.bucketName).withKey(keyName).withPartNumber(i).withLastPart(i == this.numberOfParts).withUploadId(uploadId).withPartSize((long)this.fileSize).withInputStream((InputStream)new ByteArrayInputStream(this.content.getBytes(StandardCharsets.UTF_8)));
                    UploadPartResult uploadPartResult = this.getS3().uploadPart(uploadPartRequest);
                    parts.add(uploadPartResult.getPartETag());
                }
                this.getS3().completeMultipartUpload(new CompleteMultipartUploadRequest(this.bucketName, keyName, uploadId, parts));
            } else {
                this.getS3().putObject(this.bucketName, this.generateObjectName(counter), this.content);
            }
            return null;
        });
    }
}

