/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.StorageSize;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.apache.hadoop.ozone.freon.ContentGenerator;
import org.apache.hadoop.ozone.freon.StorageSizeConverter;
import picocli.CommandLine;

@CommandLine.Command(name="dfsg", aliases={"dfs-file-generator"}, description={"Create random files to the any dfs compatible file system."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class HadoopFsGenerator
extends BaseFreonGenerator
implements Callable<Void> {
    @CommandLine.Option(names={"--path"}, description={"Hadoop FS file system path. Use full path."}, defaultValue="o3fs://bucket1.vol1")
    private String rootPath;
    @CommandLine.Option(names={"-s", "--size"}, description={"Size of the generated files. You can specify the size using data units like 'GB', 'MB', 'KB', etc. Size is in base 2 binary."}, defaultValue="10KB", converter={StorageSizeConverter.class})
    private StorageSize fileSize;
    @CommandLine.Option(names={"--buffer"}, description={"Size of buffer used store the generated key content"}, defaultValue="10240")
    private int bufferSize;
    @CommandLine.Option(names={"--copy-buffer"}, description={"Size of bytes written to the output in one operation"}, defaultValue="4096")
    private int copyBufferSize;
    @CommandLine.Option(names={"--sync"}, description={"Type of operation to execute after a write. Supported options include NONE (default), HFLUSH and HSYNC"}, defaultValue="NONE")
    private static ContentGenerator.SyncOptions flushOrSync;
    private ContentGenerator contentGenerator;
    private Timer timer;
    private OzoneConfiguration configuration;
    private URI uri;
    private final ThreadLocal<FileSystem> threadLocalFileSystem = ThreadLocal.withInitial(this::createFS);

    @Override
    public Void call() throws Exception {
        this.init();
        this.configuration = this.createOzoneConfiguration();
        this.uri = URI.create(this.rootPath);
        String scheme = Optional.ofNullable(this.uri.getScheme()).orElseGet(() -> FileSystem.getDefaultUri((Configuration)this.configuration).getScheme());
        String disableCacheName = String.format("fs.%s.impl.disable.cache", scheme);
        this.print("Disabling FS cache: " + disableCacheName);
        this.configuration.setBoolean(disableCacheName, true);
        Path file = new Path(this.rootPath + "/" + this.generateObjectName(0L));
        try (FileSystem fileSystem = this.threadLocalFileSystem.get();){
            fileSystem.mkdirs(file.getParent());
        }
        this.contentGenerator = new ContentGenerator(this.fileSize.toBytes(), this.bufferSize, this.copyBufferSize, flushOrSync);
        this.timer = this.getMetrics().timer("file-create");
        this.runTests(this::createFile);
        return null;
    }

    private void createFile(long counter) throws Exception {
        Path file = new Path(this.rootPath + "/" + this.generateObjectName(counter));
        FileSystem fileSystem = this.threadLocalFileSystem.get();
        this.timer.time(() -> {
            try (FSDataOutputStream output = fileSystem.create(file);){
                this.contentGenerator.write((OutputStream)output);
            }
            return null;
        });
    }

    private FileSystem createFS() {
        try {
            return FileSystem.get((URI)this.uri, (Configuration)this.configuration);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected void taskLoopCompleted() {
        FileSystem fileSystem = this.threadLocalFileSystem.get();
        try {
            fileSystem.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

