/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.StorageSize;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.apache.hadoop.ozone.freon.ContentGenerator;
import org.apache.hadoop.ozone.freon.StorageSizeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public abstract class AbstractOmBucketReadWriteOps
extends BaseFreonGenerator
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractOmBucketReadWriteOps.class);
    @CommandLine.Option(names={"-g", "--size"}, description={"Generated data size of each key/file to be written. You can specify the size using data units like 'GB', 'MB', 'KB', etc. Size is in base 2 binary."}, defaultValue="256B", converter={StorageSizeConverter.class})
    private StorageSize size;
    @CommandLine.Option(names={"--buffer"}, description={"Size of buffer used for generating the key/file content."}, defaultValue="64")
    private int bufferSize;
    @CommandLine.Option(names={"-l", "--name-len"}, description={"Length of the random name of path you want to create."}, defaultValue="10")
    private int length;
    @CommandLine.Option(names={"-c", "--total-thread-count"}, description={"Total number of threads to be executed."}, defaultValue="100")
    private int totalThreadCount;
    @CommandLine.Option(names={"-T", "--read-thread-percentage"}, description={"Percentage of the total number of threads to be allocated for read operations. The remaining percentage of threads will be allocated for write operations."}, defaultValue="90")
    private int readThreadPercentage;
    @CommandLine.Option(names={"-R", "--num-of-read-operations"}, description={"Number of read operations to be performed by each thread."}, defaultValue="50")
    private int numOfReadOperations;
    @CommandLine.Option(names={"-W", "--num-of-write-operations"}, description={"Number of write operations to be performed by each thread."}, defaultValue="10")
    private int numOfWriteOperations;
    private OzoneConfiguration ozoneConfiguration;
    private Timer timer;
    private ContentGenerator contentGenerator;
    private int readThreadCount;
    private int writeThreadCount;

    protected abstract void display();

    protected abstract void initialize(OzoneConfiguration var1) throws Exception;

    @Override
    public Void call() throws Exception {
        this.init();
        this.readThreadCount = this.readThreadPercentage * this.totalThreadCount / 100;
        this.writeThreadCount = this.totalThreadCount - this.readThreadCount;
        this.display();
        this.print("SizeInBytes: " + this.size.toBytes());
        this.print("bufferSize: " + this.bufferSize);
        this.print("totalThreadCount: " + this.totalThreadCount);
        this.print("readThreadPercentage: " + this.readThreadPercentage);
        this.print("writeThreadPercentage: " + (100 - this.readThreadPercentage));
        this.print("readThreadCount: " + this.readThreadCount);
        this.print("writeThreadCount: " + this.writeThreadCount);
        this.print("numOfReadOperations: " + this.numOfReadOperations);
        this.print("numOfWriteOperations: " + this.numOfWriteOperations);
        this.ozoneConfiguration = this.createOzoneConfiguration();
        this.contentGenerator = new ContentGenerator(this.size.toBytes(), this.bufferSize);
        this.timer = this.getMetrics().timer("om-bucket-read-write-ops");
        this.initialize(this.ozoneConfiguration);
        return null;
    }

    protected abstract String createPath(String var1) throws IOException;

    protected int readOperations(int keyCountForRead) throws Exception {
        String readPath = this.createPath("readPath");
        this.create(readPath, keyCountForRead);
        ExecutorService readService = Executors.newFixedThreadPool(this.readThreadCount);
        ExecutorCompletionService<Integer> readExecutorCompletionService = new ExecutorCompletionService<Integer>(readService);
        ArrayList<Future<Integer>> readFutures = new ArrayList<Future<Integer>>();
        for (int i = 0; i < this.readThreadCount; ++i) {
            readFutures.add(readExecutorCompletionService.submit(() -> {
                int readCount = 0;
                try {
                    for (int j = 0; j < this.numOfReadOperations; ++j) {
                        readCount = this.getReadCount(readCount, "readPath");
                    }
                }
                catch (IOException e) {
                    LOG.warn("Exception while listing keys/files ", (Throwable)e);
                }
                return readCount;
            }));
        }
        int readResult = 0;
        for (int i = 0; i < readFutures.size(); ++i) {
            readResult += ((Integer)readExecutorCompletionService.take().get()).intValue();
        }
        readService.shutdown();
        return readResult;
    }

    protected abstract int getReadCount(int var1, String var2) throws IOException;

    protected int writeOperations(int keyCountForWrite) throws Exception {
        String writePath = this.createPath("writePath");
        ExecutorService writeService = Executors.newFixedThreadPool(this.writeThreadCount);
        ExecutorCompletionService<Integer> writeExecutorCompletionService = new ExecutorCompletionService<Integer>(writeService);
        ArrayList<Future<Integer>> writeFutures = new ArrayList<Future<Integer>>();
        for (int i = 0; i < this.writeThreadCount; ++i) {
            writeFutures.add(writeExecutorCompletionService.submit(() -> {
                int writeCount = 0;
                try {
                    for (int j = 0; j < this.numOfWriteOperations; ++j) {
                        this.create(writePath, keyCountForWrite);
                        ++writeCount;
                    }
                }
                catch (IOException e) {
                    LOG.warn("Exception while creating keys/files ", (Throwable)e);
                }
                return writeCount;
            }));
        }
        int writeResult = 0;
        for (int i = 0; i < writeFutures.size(); ++i) {
            writeResult += ((Integer)writeExecutorCompletionService.take().get()).intValue();
        }
        writeService.shutdown();
        return writeResult;
    }

    protected void create(String path, int keyCount) throws Exception {
        for (int i = 0; i < keyCount; ++i) {
            String keyName = path.concat("/").concat(RandomStringUtils.randomAlphanumeric((int)this.length));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Key/FileName : {}", (Object)keyName);
            }
            this.timer.time(() -> {
                try (OutputStream stream = this.create(keyName);){
                    this.contentGenerator.write(stream);
                    stream.flush();
                }
                return null;
            });
        }
    }

    protected abstract OutputStream create(String var1) throws IOException;

    protected long getSizeInBytes() {
        return this.size.toBytes();
    }
}

