/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.container;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.cli.SubcommandWithParent;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.ozone.common.InconsistentStorageStateException;
import org.apache.hadoop.ozone.container.common.helpers.ContainerMetrics;
import org.apache.hadoop.ozone.container.common.helpers.DatanodeVersionFile;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.interfaces.Handler;
import org.apache.hadoop.ozone.container.common.utils.HddsVolumeUtil;
import org.apache.hadoop.ozone.container.common.utils.StorageVolumeUtil;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.common.volume.StorageVolume;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerReader;
import org.apache.hadoop.ozone.container.upgrade.VersionedDatanodeFeatures;
import org.apache.hadoop.ozone.debug.OzoneDebug;
import org.apache.hadoop.ozone.debug.container.ExportSubcommand;
import org.apache.hadoop.ozone.debug.container.InfoSubcommand;
import org.apache.hadoop.ozone.debug.container.InspectSubcommand;
import org.apache.hadoop.ozone.debug.container.ListSubcommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="container", description={"Container replica specific operations to be executed on datanodes only"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class, subcommands={ListSubcommand.class, InfoSubcommand.class, ExportSubcommand.class, InspectSubcommand.class})
public class ContainerCommands
implements Callable<Void>,
SubcommandWithParent {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerCommands.class);
    @CommandLine.ParentCommand
    private OzoneDebug parent;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    private MutableVolumeSet volumeSet;
    private ContainerController controller;

    @Override
    public Void call() throws Exception {
        GenericCli.missingSubcommand((CommandLine.Model.CommandSpec)this.spec);
        return null;
    }

    public Class<?> getParentType() {
        return OzoneDebug.class;
    }

    OzoneConfiguration getOzoneConf() {
        return this.parent.getOzoneConf();
    }

    public void loadContainersFromVolumes() throws IOException {
        OzoneConfiguration conf = this.parent.getOzoneConf();
        ContainerSet containerSet = new ContainerSet(1000L);
        ContainerMetrics metrics = ContainerMetrics.create((ConfigurationSource)conf);
        String firstStorageDir = this.getFirstStorageDir((ConfigurationSource)conf);
        String datanodeUuid = this.getDatanodeUUID(firstStorageDir, (ConfigurationSource)conf);
        String clusterId = this.getClusterId(firstStorageDir);
        this.volumeSet = new MutableVolumeSet(datanodeUuid, (ConfigurationSource)conf, null, StorageVolume.VolumeType.DATA_VOLUME, null);
        if (VersionedDatanodeFeatures.SchemaV3.isFinalizedAndEnabled((ConfigurationSource)conf)) {
            MutableVolumeSet dbVolumeSet = HddsServerUtil.getDatanodeDbDirs((ConfigurationSource)conf).isEmpty() ? null : new MutableVolumeSet(datanodeUuid, (ConfigurationSource)conf, null, StorageVolume.VolumeType.DB_VOLUME, null);
            HddsVolumeUtil.loadAllHddsVolumeDbStore((MutableVolumeSet)this.volumeSet, (MutableVolumeSet)dbVolumeSet, (boolean)true, (Logger)LOG);
        }
        HashMap<ContainerProtos.ContainerType, Handler> handlers = new HashMap<ContainerProtos.ContainerType, Handler>();
        for (ContainerProtos.ContainerType containerType : ContainerProtos.ContainerType.values()) {
            Handler handler = Handler.getHandlerForContainerType((ContainerProtos.ContainerType)containerType, (ConfigurationSource)conf, (String)datanodeUuid, (ContainerSet)containerSet, (VolumeSet)this.volumeSet, (ContainerMetrics)metrics, containerReplicaProto -> {});
            handler.setClusterID(clusterId);
            handlers.put(containerType, handler);
        }
        this.controller = new ContainerController(containerSet, handlers);
        List volumes = StorageVolumeUtil.getHddsVolumesList((List)this.volumeSet.getVolumesList());
        Iterator volumeSetIterator = volumes.iterator();
        LOG.info("Starting the read all the container metadata");
        while (volumeSetIterator.hasNext()) {
            HddsVolume volume = (HddsVolume)volumeSetIterator.next();
            LOG.info("Loading container metadata from volume " + volume.toString());
            ContainerReader reader = new ContainerReader(this.volumeSet, volume, containerSet, (ConfigurationSource)conf, false);
            reader.run();
        }
        LOG.info("All the container metadata is loaded.");
    }

    public MutableVolumeSet getVolumeSet() {
        return this.volumeSet;
    }

    public ContainerController getController() {
        return this.controller;
    }

    private String getClusterId(String storageDir) throws IOException {
        Preconditions.checkNotNull((Object)storageDir);
        try (Stream<Path> stream = Files.list(Paths.get(storageDir, "hdds"));){
            Path firstStorageDirPath = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).findFirst().get().getFileName();
            if (firstStorageDirPath == null) {
                throw new IllegalArgumentException("HDDS storage dir couldn't be identified!");
            }
            String string = firstStorageDirPath.toString();
            return string;
        }
    }

    private String getDatanodeUUID(String storageDir, ConfigurationSource config) throws IOException {
        File versionFile = new File(storageDir, "hdds/VERSION");
        Properties props = DatanodeVersionFile.readFrom((File)versionFile);
        if (props.isEmpty()) {
            throw new InconsistentStorageStateException("Version file " + versionFile + " is missing");
        }
        return StorageVolumeUtil.getProperty((Properties)props, (String)"datanodeUuid", (File)versionFile);
    }

    private String getFirstStorageDir(ConfigurationSource config) throws IOException {
        Collection storageDirs = HddsServerUtil.getDatanodeStorageDirs((ConfigurationSource)config);
        return StorageLocation.parse((String)((String)storageDirs.iterator().next())).getUri().getPath();
    }

    public static void outputContainer(ContainerData data) throws IOException {
        System.out.println(JsonUtils.toJsonStringWithDefaultPrettyPrinter((Object)data));
    }
}

