/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.scm;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.container.common.helpers.DeletedBlocksTransactionInfoWrapper;
import org.apache.hadoop.hdds.server.JsonUtils;
import picocli.CommandLine;

@CommandLine.Command(name="ls", description={"Print the failed DeletedBlocksTransaction(retry count = -1)"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class GetFailedDeletedBlocksTxnSubcommand
extends ScmSubcommand {
    @CommandLine.ArgGroup(multiplicity="1")
    private TransactionsOption group;
    @CommandLine.Option(names={"-s", "--startTxId", "--start-tx-id"}, defaultValue="0", description={"The least transaction ID to start with, default 0. Only work with -c/--count"})
    private long startTxId;
    @CommandLine.Option(names={"-o", "--out"}, description={"Print transactions into file in JSON format."})
    private String fileName;
    private static final int LIST_ALL_FAILED_TRANSACTIONS = -1;

    public void execute(ScmClient client) throws IOException {
        int count = this.group.getAll ? -1 : this.group.count;
        List response = client.getFailedDeletedBlockTxn(count, this.startTxId);
        List txns = response.stream().map(DeletedBlocksTransactionInfoWrapper::fromProtobuf).filter(Objects::nonNull).collect(Collectors.toList());
        String result = JsonUtils.toJsonStringWithDefaultPrettyPrinter(txns);
        if (this.fileName != null) {
            try (FileOutputStream f = new FileOutputStream(this.fileName);){
                f.write(result.getBytes(StandardCharsets.UTF_8));
            }
        } else {
            System.out.println(result);
        }
    }

    static class TransactionsOption {
        @CommandLine.Option(names={"-a", "--all"}, description={"Get all the failed transactions."})
        private boolean getAll;
        @CommandLine.Option(names={"-c", "--count"}, defaultValue="20", description={"Get at most the count number of the failed transactions."})
        private int count;

        TransactionsOption() {
        }
    }
}

