/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.reconfig;

import java.io.IOException;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.ReconfigureProtocol;
import org.apache.hadoop.ozone.admin.reconfig.AbstractReconfigureSubCommand;
import org.apache.hadoop.ozone.admin.reconfig.ReconfigureSubCommandUtil;
import picocli.CommandLine;

@CommandLine.Command(name="start", description={"Start reconfig asynchronously"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class ReconfigureStartSubcommand
extends AbstractReconfigureSubCommand {
    @Override
    protected void executeCommand(String address) {
        try (ReconfigureProtocol reconfigProxy = ReconfigureSubCommandUtil.getSingleNodeReconfigureProxy(address);){
            String serverName = reconfigProxy.getServerName();
            reconfigProxy.startReconfigure();
            System.out.printf("%s: Started reconfiguration task on node [%s].%n", serverName, address);
        }
        catch (IOException e) {
            System.out.println("An error occurred while executing the command for :" + address);
            e.printStackTrace(System.out);
        }
    }
}

