/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.nssummary;

import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import org.apache.hadoop.fs.ozone.OzoneClientUtils;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.cli.OzoneAdmin;
import org.apache.hadoop.hdds.cli.SubcommandWithParent;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.server.http.HttpConfig;
import org.apache.hadoop.ozone.OFSPath;
import org.apache.hadoop.ozone.admin.nssummary.DiskUsageSubCommand;
import org.apache.hadoop.ozone.admin.nssummary.FileSizeDistSubCommand;
import org.apache.hadoop.ozone.admin.nssummary.QuotaUsageSubCommand;
import org.apache.hadoop.ozone.admin.nssummary.SummarySubCommand;
import org.apache.hadoop.ozone.client.ObjectStore;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientFactory;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import picocli.CommandLine;

@CommandLine.Command(name="namespace", description={"Namespace Summary specific admin operations"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class, subcommands={SummarySubCommand.class, DiskUsageSubCommand.class, QuotaUsageSubCommand.class, FileSizeDistSubCommand.class})
public class NSSummaryAdmin
extends GenericCli
implements SubcommandWithParent {
    @CommandLine.ParentCommand
    private OzoneAdmin parent;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    public OzoneAdmin getParent() {
        return this.parent;
    }

    public Void call() throws Exception {
        GenericCli.missingSubcommand((CommandLine.Model.CommandSpec)this.spec);
        return null;
    }

    public Class<?> getParentType() {
        return OzoneAdmin.class;
    }

    public boolean isFileSystemOptimizedBucket(String path) throws IOException {
        OFSPath ofsPath = new OFSPath(path, OzoneConfiguration.of((ConfigurationSource)this.getOzoneConfig()));
        OzoneClient ozoneClient = OzoneClientFactory.getRpcClient((ConfigurationSource)this.getOzoneConfig());
        ObjectStore objectStore = ozoneClient.getObjectStore();
        try {
            OzoneBucket bucket = objectStore.getVolume(ofsPath.getVolumeName()).getBucket(ofsPath.getBucketName());
            BucketLayout resolvedBucketLayout = OzoneClientUtils.resolveLinkBucketLayout((OzoneBucket)bucket, (ObjectStore)objectStore, new HashSet());
            return resolvedBucketLayout.isFileSystemOptimized();
        }
        catch (IOException e) {
            System.out.println("Bucket layout couldn't be verified for path: " + ofsPath + ". Exception: " + e);
            return false;
        }
    }

    public boolean isObjectStoreBucket(String path) throws IOException {
        OFSPath ofsPath = new OFSPath(path, OzoneConfiguration.of((ConfigurationSource)this.getOzoneConfig()));
        boolean enableFileSystemPaths = this.getOzoneConfig().getBoolean("ozone.om.enable.filesystem.paths", false);
        OzoneClient ozoneClient = OzoneClientFactory.getRpcClient((ConfigurationSource)this.getOzoneConfig());
        ObjectStore objectStore = ozoneClient.getObjectStore();
        try {
            OzoneBucket bucket = objectStore.getVolume(ofsPath.getVolumeName()).getBucket(ofsPath.getBucketName());
            BucketLayout resolvedBucketLayout = OzoneClientUtils.resolveLinkBucketLayout((OzoneBucket)bucket, (ObjectStore)objectStore, new HashSet());
            return resolvedBucketLayout.isObjectStore(enableFileSystemPaths);
        }
        catch (IOException e) {
            System.out.println("Bucket layout couldn't be verified for path: " + ofsPath + ". Exception: " + e);
            return false;
        }
    }

    public boolean bucketIsPresentInThePath(String path) throws IOException {
        OFSPath ofsPath = new OFSPath(path, OzoneConfiguration.of((ConfigurationSource)this.getOzoneConfig()));
        OzoneClient ozoneClient = OzoneClientFactory.getRpcClient((ConfigurationSource)this.getOzoneConfig());
        ObjectStore objectStore = ozoneClient.getObjectStore();
        try {
            OzoneBucket bucket = objectStore.getVolume(ofsPath.getVolumeName()).getBucket(ofsPath.getBucketName());
            return Objects.nonNull(bucket);
        }
        catch (IOException e) {
            System.out.println("Bucket layout couldn't be verified for path: " + ofsPath + ". Exception: " + e);
            return false;
        }
    }

    private String getHostOnly(String host) {
        return host.split(":", 2)[0];
    }

    private String getPort(String host) {
        return host.split(":", 2)[1];
    }

    public String getReconWebAddress() {
        boolean isHostDefault;
        String host;
        String protocol;
        OzoneConfiguration conf = this.parent.getOzoneConf();
        HttpConfig.Policy webPolicy = HttpConfig.getHttpPolicy((MutableConfigurationSource)conf);
        if (webPolicy.isHttpsEnabled()) {
            protocol = "https";
            host = conf.get("ozone.recon.https-address", "0.0.0.0:9889");
            isHostDefault = this.getHostOnly(host).equals(this.getHostOnly("0.0.0.0:9889"));
        } else {
            protocol = "http";
            host = conf.get("ozone.recon.http-address", "0.0.0.0:9888");
            isHostDefault = this.getHostOnly(host).equals(this.getHostOnly("0.0.0.0:9888"));
        }
        if (isHostDefault) {
            String rpcHost = conf.get("ozone.recon.address", "0.0.0.0:9891");
            host = this.getHostOnly(rpcHost) + ":" + this.getPort(host);
        }
        return protocol + "://" + host;
    }

    public boolean isHTTPSEnabled() {
        OzoneConfiguration conf = this.parent.getOzoneConf();
        return HttpConfig.getHttpPolicy((MutableConfigurationSource)conf) == HttpConfig.Policy.HTTPS_ONLY;
    }

    public ConfigurationSource getOzoneConfig() {
        return this.parent.getOzoneConf();
    }
}

