/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.nssummary;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.ozone.admin.nssummary.NSSummaryAdmin;
import org.apache.hadoop.ozone.admin.nssummary.NSSummaryCLIUtils;
import picocli.CommandLine;

@CommandLine.Command(name="dist", description={"Get file size distribution for a path request."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class FileSizeDistSubCommand
implements Callable {
    @CommandLine.ParentCommand
    private NSSummaryAdmin parent;
    @CommandLine.Parameters(index="0", arity="0..1", description={"Non-empty path request without any protocol prefix."})
    private String path;
    private static final String ENDPOINT = "/api/v1/namespace/dist";
    private StringBuffer url = new StringBuffer();

    public Void call() throws Exception {
        if (this.path == null || this.path.length() == 0) {
            NSSummaryCLIUtils.printEmptyPathRequest();
            return null;
        }
        this.url.append(this.parent.getReconWebAddress()).append(ENDPOINT);
        NSSummaryCLIUtils.printNewLines(1);
        String response = NSSummaryCLIUtils.makeHttpCall(this.url, this.path, this.parent.isHTTPSEnabled(), this.parent.getOzoneConfig());
        if (response == null) {
            NSSummaryCLIUtils.printNewLines(1);
            return null;
        }
        HashMap<String, Object> distResponse = NSSummaryCLIUtils.getResponseMap(response);
        if (distResponse.get("status").equals("PATH_NOT_FOUND")) {
            NSSummaryCLIUtils.printPathNotFound();
        } else if (distResponse.get("status").equals("TYPE_NOT_APPLICABLE")) {
            NSSummaryCLIUtils.printTypeNA("File Size Distribution");
        } else {
            int i;
            if (this.parent.isObjectStoreBucket(this.path) || !this.parent.bucketIsPresentInThePath(this.path)) {
                NSSummaryCLIUtils.printBucketReminder();
            }
            NSSummaryCLIUtils.printWithUnderline("File Size Distribution", true);
            ArrayList fileSizeDist = (ArrayList)distResponse.get("dist");
            double sum = 0.0;
            for (i = 0; i < fileSizeDist.size(); ++i) {
                sum += ((Double)fileSizeDist.get(i)).doubleValue();
            }
            if (sum == 0.0) {
                NSSummaryCLIUtils.printSpaces(2);
                System.out.println("The object is empty.\nPut more files into it to visualize file size distribution");
                NSSummaryCLIUtils.printNewLines(1);
                return null;
            }
            for (i = 0; i < fileSizeDist.size(); ++i) {
                if ((Double)fileSizeDist.get(i) == 0.0) continue;
                String label = this.convertBinIndexToReadableRange(i);
                this.printDistRow(label, (Double)fileSizeDist.get(i), sum);
            }
        }
        NSSummaryCLIUtils.printNewLines(1);
        return null;
    }

    private void printDistRow(String label, double num, double sum) {
        NSSummaryCLIUtils.printSpaces(2);
        System.out.print(label);
        System.out.print(" - ");
        System.out.printf("%.1f", num / sum * 100.0);
        System.out.print("% ");
        System.out.println("(" + (int)num + ")");
    }

    private String convertBinIndexToReadableRange(int index) {
        long upperBound = (long)Math.pow(2.0, 10 + index);
        long lowerBound = index == 0 ? 0L : upperBound / 2L;
        return FileUtils.byteCountToDisplaySize((long)lowerBound) + " -- " + FileUtils.byteCountToDisplaySize((long)upperBound);
    }
}

