/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.server.http.BaseHttpServer;
import org.apache.hadoop.hdds.server.http.ServletElementsFactory;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3GatewayHttpServer
extends BaseHttpServer {
    private static final Logger LOG = LoggerFactory.getLogger(S3GatewayHttpServer.class);
    public static final int FILTER_PRIORITY_DO_AFTER = 50;

    public S3GatewayHttpServer(MutableConfigurationSource conf, String name) throws IOException {
        super(conf, name);
        this.addServlet("icon", "/favicon.ico", IconServlet.class);
        this.addSecretAuthentication(conf);
    }

    private void addSecretAuthentication(MutableConfigurationSource conf) throws IOException {
        if (conf.getBoolean("ozone.s3g.secret.http.enabled", false)) {
            String authType = conf.get("ozone.s3g.secret.http.auth.type", "kerberos");
            if (UserGroupInformation.isSecurityEnabled() && authType.equals("kerberos")) {
                String httpKeytab;
                ServletHandler handler = this.getWebAppContext().getServletHandler();
                HashMap<String, String> params = new HashMap<String, String>();
                String principalInConf = conf.get("ozone.s3g.http.auth.kerberos.principal");
                if (!Strings.isNullOrEmpty((String)principalInConf)) {
                    params.put("kerberos.principal", SecurityUtil.getServerPrincipal((String)principalInConf, (String)conf.get("ozone.s3g.http-bind-host")));
                }
                if (!Strings.isNullOrEmpty((String)(httpKeytab = conf.get("ozone.s3g.http.auth.kerberos.keytab")))) {
                    params.put("kerberos.keytab", httpKeytab);
                }
                params.put("type", "kerberos");
                FilterHolder holder = ServletElementsFactory.createFilterHolder((String)"secretAuthentication", (String)AuthenticationFilter.class.getName(), params);
                FilterMapping filterMapping = ServletElementsFactory.createFilterMapping((String)"secretAuthentication", (String[])new String[]{"/secret/*"});
                handler.addFilter(holder, filterMapping);
            } else {
                LOG.error("Secret Endpoint should be secured with Kerberos");
                throw new IllegalStateException("Secret Endpoint should be secured with Kerberos");
            }
        }
    }

    protected String getHttpAddressKey() {
        return "ozone.s3g.http-address";
    }

    protected String getHttpBindHostKey() {
        return "ozone.s3g.http-bind-host";
    }

    protected String getHttpsAddressKey() {
        return "ozone.s3g.https-address";
    }

    protected String getHttpsBindHostKey() {
        return "ozone.s3g.https-bind-host";
    }

    protected String getBindHostDefault() {
        return "0.0.0.0";
    }

    protected int getHttpBindPortDefault() {
        return 9878;
    }

    protected int getHttpsBindPortDefault() {
        return 9879;
    }

    protected String getKeytabFile() {
        return "ozone.s3g.http.auth.kerberos.keytab";
    }

    protected String getSpnegoPrincipal() {
        return "ozone.s3g.http.auth.kerberos.principal";
    }

    protected String getEnabledKey() {
        return "ozone.s3g.http.enabled";
    }

    protected String getHttpAuthType() {
        return "ozone.s3g.http.auth.type";
    }

    protected String getHttpAuthConfigPrefix() {
        return "ozone.s3g.http.auth.";
    }

    public static class IconServlet
    extends HttpServlet {
        private static final long serialVersionUID = -1L;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.setContentType("image/png");
            response.sendRedirect("/static/images/ozone.ico");
        }
    }
}

