/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.handlers;

import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.recon.ReconConstants;
import org.apache.hadoop.ozone.recon.api.handlers.BucketHandler;
import org.apache.hadoop.ozone.recon.api.types.DUResponse;
import org.apache.hadoop.ozone.recon.api.types.EntityType;
import org.apache.hadoop.ozone.recon.api.types.FileSizeDistributionResponse;
import org.apache.hadoop.ozone.recon.api.types.NSSummary;
import org.apache.hadoop.ozone.recon.api.types.NamespaceSummaryResponse;
import org.apache.hadoop.ozone.recon.api.types.QuotaUsageResponse;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;

public abstract class EntityHandler {
    private final ReconNamespaceSummaryManager reconNamespaceSummaryManager;
    private final ReconOMMetadataManager omMetadataManager;
    private final BucketHandler bucketHandler;
    private final OzoneStorageContainerManager reconSCM;
    private final String normalizedPath;
    private final String[] names;

    public EntityHandler(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager omMetadataManager, OzoneStorageContainerManager reconSCM, BucketHandler bucketHandler, String path) {
        this.reconNamespaceSummaryManager = reconNamespaceSummaryManager;
        this.omMetadataManager = omMetadataManager;
        this.reconSCM = reconSCM;
        this.bucketHandler = bucketHandler;
        BucketLayout layout = bucketHandler != null ? bucketHandler.getBucketLayout() : BucketLayout.FILE_SYSTEM_OPTIMIZED;
        this.normalizedPath = EntityHandler.normalizePath(path, layout);
        this.names = layout == BucketLayout.OBJECT_STORE ? EntityHandler.parseObjectStorePath(this.normalizedPath) : EntityHandler.parseRequestPath(this.normalizedPath);
    }

    public abstract NamespaceSummaryResponse getSummaryResponse() throws IOException;

    public abstract DUResponse getDuResponse(boolean var1, boolean var2, boolean var3) throws IOException;

    public abstract QuotaUsageResponse getQuotaResponse() throws IOException;

    public abstract FileSizeDistributionResponse getDistResponse() throws IOException;

    public ReconOMMetadataManager getOmMetadataManager() {
        return this.omMetadataManager;
    }

    public OzoneStorageContainerManager getReconSCM() {
        return this.reconSCM;
    }

    public ReconNamespaceSummaryManager getReconNamespaceSummaryManager() {
        return this.reconNamespaceSummaryManager;
    }

    public BucketHandler getBucketHandler() {
        return this.bucketHandler;
    }

    public String getNormalizedPath() {
        return this.normalizedPath;
    }

    public String[] getNames() {
        return (String[])this.names.clone();
    }

    public static EntityHandler getEntityHandler(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager omMetadataManager, OzoneStorageContainerManager reconSCM, String path) throws IOException {
        String normalizedPath = EntityHandler.normalizePath(path, BucketLayout.FILE_SYSTEM_OPTIMIZED);
        String[] names = EntityHandler.parseRequestPath(normalizedPath);
        if (path.equals("/")) {
            return EntityType.ROOT.create(reconNamespaceSummaryManager, omMetadataManager, reconSCM, null, path);
        }
        if (names.length == 0) {
            return EntityType.UNKNOWN.create(reconNamespaceSummaryManager, omMetadataManager, reconSCM, null, path);
        }
        if (names.length == 1) {
            String volName = names[0];
            if (!omMetadataManager.volumeExists(volName)) {
                return EntityType.UNKNOWN.create(reconNamespaceSummaryManager, omMetadataManager, reconSCM, null, path);
            }
            return EntityType.VOLUME.create(reconNamespaceSummaryManager, omMetadataManager, reconSCM, null, path);
        }
        if (names.length == 2) {
            String volName = names[0];
            String bucketName = names[1];
            BucketHandler bucketHandler = BucketHandler.getBucketHandler(reconNamespaceSummaryManager, omMetadataManager, reconSCM, volName, bucketName);
            if (bucketHandler == null || !bucketHandler.bucketExists(volName, bucketName)) {
                return EntityType.UNKNOWN.create(reconNamespaceSummaryManager, omMetadataManager, reconSCM, null, path);
            }
            return EntityType.BUCKET.create(reconNamespaceSummaryManager, omMetadataManager, reconSCM, bucketHandler, path);
        }
        String volName = names[0];
        String bucketName = names[1];
        BucketHandler bucketHandler = BucketHandler.getBucketHandler(reconNamespaceSummaryManager, omMetadataManager, reconSCM, volName, bucketName);
        if (bucketHandler == null) {
            return EntityType.UNKNOWN.create(reconNamespaceSummaryManager, omMetadataManager, reconSCM, null, path);
        }
        if (bucketHandler.getBucketLayout() == BucketLayout.OBJECT_STORE) {
            String[] parsedObjectLayoutPath = EntityHandler.parseObjectStorePath(EntityHandler.normalizePath(path, bucketHandler.getBucketLayout()));
            if (parsedObjectLayoutPath == null) {
                return EntityType.UNKNOWN.create(reconNamespaceSummaryManager, omMetadataManager, reconSCM, null, path);
            }
            return bucketHandler.determineKeyPath(parsedObjectLayoutPath[2]).create(reconNamespaceSummaryManager, omMetadataManager, reconSCM, bucketHandler, path);
        }
        String keyName = BucketHandler.getKeyName(names);
        return bucketHandler.determineKeyPath(keyName).create(reconNamespaceSummaryManager, omMetadataManager, reconSCM, bucketHandler, path);
    }

    protected int[] getTotalFileSizeDist(long objectId) throws IOException {
        NSSummary nsSummary = this.reconNamespaceSummaryManager.getNSSummary(objectId);
        if (nsSummary == null) {
            return new int[ReconConstants.NUM_OF_FILE_SIZE_BINS];
        }
        int[] res = nsSummary.getFileSizeBucket();
        for (long childId : nsSummary.getChildDir()) {
            int[] subDirFileSizeDist = this.getTotalFileSizeDist(childId);
            for (int i = 0; i < ReconConstants.NUM_OF_FILE_SIZE_BINS; ++i) {
                int n = i;
                res[n] = res[n] + subDirFileSizeDist[i];
            }
        }
        return res;
    }

    protected int getTotalDirCount(long objectId) throws IOException {
        NSSummary nsSummary = this.getReconNamespaceSummaryManager().getNSSummary(objectId);
        if (nsSummary == null) {
            return 0;
        }
        Set<Long> subdirs = nsSummary.getChildDir();
        int totalCnt = subdirs.size();
        for (long subdir : subdirs) {
            totalCnt += this.getTotalDirCount(subdir);
        }
        return totalCnt;
    }

    protected long getTotalKeyCount(long objectId) throws IOException {
        NSSummary nsSummary = this.reconNamespaceSummaryManager.getNSSummary(objectId);
        if (nsSummary == null) {
            return 0L;
        }
        long totalCnt = nsSummary.getNumOfFiles();
        for (long childId : nsSummary.getChildDir()) {
            totalCnt += this.getTotalKeyCount(childId);
        }
        return totalCnt;
    }

    protected long getTotalSize(long objectId) throws IOException {
        NSSummary nsSummary = this.reconNamespaceSummaryManager.getNSSummary(objectId);
        if (nsSummary == null) {
            return 0L;
        }
        long totalSize = nsSummary.getSizeOfFiles();
        for (long childId : nsSummary.getChildDir()) {
            totalSize += this.getTotalSize(childId);
        }
        return totalSize;
    }

    public static String[] parseRequestPath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] names = path.split("/");
        return names;
    }

    public static String[] parseObjectStorePath(String path) {
        String[] parts = (path = path.substring(1)).split("/", 3);
        if (parts.length <= 3) {
            return parts;
        }
        return null;
    }

    private static String normalizePath(String path, BucketLayout bucketLayout) {
        if (bucketLayout == BucketLayout.OBJECT_STORE) {
            return "/" + OmUtils.normalizePathUptoBucket((String)path);
        }
        return "/" + OmUtils.normalizeKey((String)path, (boolean)false);
    }
}

