/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.handlers;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.recon.api.handlers.FSOBucketHandler;
import org.apache.hadoop.ozone.recon.api.handlers.LegacyBucketHandler;
import org.apache.hadoop.ozone.recon.api.handlers.OBSBucketHandler;
import org.apache.hadoop.ozone.recon.api.types.DUResponse;
import org.apache.hadoop.ozone.recon.api.types.EntityType;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BucketHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BucketHandler.class);
    private final ReconNamespaceSummaryManager reconNamespaceSummaryManager;
    private final ReconOMMetadataManager omMetadataManager;
    private final ContainerManager containerManager;

    public BucketHandler(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager omMetadataManager, OzoneStorageContainerManager reconSCM) {
        this.reconNamespaceSummaryManager = reconNamespaceSummaryManager;
        this.omMetadataManager = omMetadataManager;
        this.containerManager = reconSCM.getContainerManager();
    }

    public ReconOMMetadataManager getOmMetadataManager() {
        return this.omMetadataManager;
    }

    public ReconNamespaceSummaryManager getReconNamespaceSummaryManager() {
        return this.reconNamespaceSummaryManager;
    }

    public abstract EntityType determineKeyPath(String var1) throws IOException;

    public abstract long calculateDUUnderObject(long var1) throws IOException;

    public abstract long handleDirectKeys(long var1, boolean var3, boolean var4, List<DUResponse.DiskUsage> var5, String var6) throws IOException;

    public abstract long getDirObjectId(String[] var1) throws IOException;

    public abstract long getDirObjectId(String[] var1, int var2) throws IOException;

    public abstract BucketLayout getBucketLayout();

    public abstract OmKeyInfo getKeyInfo(String[] var1) throws IOException;

    public abstract OmDirectoryInfo getDirInfo(String[] var1) throws IOException;

    public static String buildSubpath(String path, String nextLevel) {
        String subpath = path;
        if (!subpath.startsWith("/")) {
            subpath = "/" + subpath;
        }
        subpath = OzoneFSUtils.removeTrailingSlashIfNeeded((String)subpath);
        if (nextLevel != null) {
            subpath = subpath + "/" + nextLevel;
        }
        return subpath;
    }

    public static String getKeyName(String[] names) {
        CharSequence[] keyArr = Arrays.copyOfRange(names, 2, names.length);
        return String.join((CharSequence)"/", keyArr);
    }

    boolean bucketExists(String volName, String bucketName) throws IOException {
        String bucketDBKey = this.omMetadataManager.getBucketKey(volName, bucketName);
        return this.omMetadataManager.getBucketTable().getSkipCache((Object)bucketDBKey) != null;
    }

    public long getVolumeObjectId(String[] names) throws IOException {
        String volumeKey = this.omMetadataManager.getVolumeKey(names[0]);
        OmVolumeArgs volumeInfo = (OmVolumeArgs)this.omMetadataManager.getVolumeTable().getSkipCache((Object)volumeKey);
        return volumeInfo.getObjectID();
    }

    public long getBucketObjectId(String[] names) throws IOException {
        String bucketKey = this.omMetadataManager.getBucketKey(names[0], names[1]);
        OmBucketInfo bucketInfo = (OmBucketInfo)this.omMetadataManager.getBucketTable().getSkipCache((Object)bucketKey);
        return bucketInfo.getObjectID();
    }

    public static BucketHandler getBucketHandler(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager omMetadataManager, OzoneStorageContainerManager reconSCM, OmBucketInfo bucketInfo) throws IOException {
        boolean enableFileSystemPaths = BucketHandler.isEnableFileSystemPaths(omMetadataManager);
        if (Objects.isNull(bucketInfo)) {
            return null;
        }
        if (bucketInfo.getBucketLayout().equals((Object)BucketLayout.FILE_SYSTEM_OPTIMIZED)) {
            return new FSOBucketHandler(reconNamespaceSummaryManager, omMetadataManager, reconSCM, bucketInfo);
        }
        if (bucketInfo.getBucketLayout().equals((Object)BucketLayout.LEGACY)) {
            if (enableFileSystemPaths) {
                return new LegacyBucketHandler(reconNamespaceSummaryManager, omMetadataManager, reconSCM, bucketInfo);
            }
            return new OBSBucketHandler(reconNamespaceSummaryManager, omMetadataManager, reconSCM, bucketInfo);
        }
        if (bucketInfo.getBucketLayout().equals((Object)BucketLayout.OBJECT_STORE)) {
            return new OBSBucketHandler(reconNamespaceSummaryManager, omMetadataManager, reconSCM, bucketInfo);
        }
        LOG.error("Unsupported bucket layout: " + bucketInfo.getBucketLayout());
        return null;
    }

    private static boolean isEnableFileSystemPaths(ReconOMMetadataManager omMetadataManager) {
        OzoneConfiguration configuration = omMetadataManager.getOzoneConfiguration();
        if (configuration == null) {
            configuration = new OzoneConfiguration();
        }
        return configuration.getBoolean("ozone.om.enable.filesystem.paths", false);
    }

    public static BucketHandler getBucketHandler(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager omMetadataManager, OzoneStorageContainerManager reconSCM, String volumeName, String bucketName) throws IOException {
        String bucketKey = omMetadataManager.getBucketKey(volumeName, bucketName);
        Table bucketTable = omMetadataManager.getBucketTable();
        OmBucketInfo bucketInfo = null;
        if (null != bucketTable) {
            bucketInfo = (OmBucketInfo)bucketTable.getSkipCache((Object)bucketKey);
        }
        return BucketHandler.getBucketHandler(reconNamespaceSummaryManager, omMetadataManager, reconSCM, bucketInfo);
    }
}

