/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.erasurecode.rawcoder.util;

import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.ozone.erasurecode.CodecRegistry;
import org.apache.ozone.erasurecode.rawcoder.RawErasureCoderFactory;
import org.apache.ozone.erasurecode.rawcoder.RawErasureDecoder;
import org.apache.ozone.erasurecode.rawcoder.RawErasureEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class CodecUtil {
    public static final Logger LOG = LoggerFactory.getLogger(CodecUtil.class);

    private CodecUtil() {
    }

    private static RawErasureCoderFactory createRawCoderFactory(String coderName, String codecName) {
        RawErasureCoderFactory fact = CodecRegistry.getInstance().getCoderByName(codecName, coderName);
        return fact;
    }

    public static RawErasureEncoder createRawEncoderWithFallback(ECReplicationConfig ecReplicationConfig) {
        String[] rawCoderNames;
        String codecName = ecReplicationConfig.getCodec().name().toLowerCase();
        for (String rawCoderName : rawCoderNames = CodecRegistry.getInstance().getCoderNames(codecName)) {
            try {
                if (rawCoderName == null) continue;
                RawErasureCoderFactory fact = CodecUtil.createRawCoderFactory(rawCoderName, codecName);
                return fact.createEncoder(ecReplicationConfig);
            }
            catch (Exception | LinkageError e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Failed to create raw erasure encoder " + rawCoderName + ", fallback to next codec if possible", e);
            }
        }
        throw new IllegalArgumentException("Fail to create raw erasure encoder with given codec: " + codecName);
    }

    public static RawErasureDecoder createRawDecoderWithFallback(ECReplicationConfig ecReplicationConfig) {
        String[] coders;
        String codecName = ecReplicationConfig.getCodec().name().toLowerCase();
        for (String rawCoderName : coders = CodecRegistry.getInstance().getCoderNames(codecName)) {
            try {
                if (rawCoderName == null) continue;
                RawErasureCoderFactory fact = CodecUtil.createRawCoderFactory(rawCoderName, codecName);
                return fact.createDecoder(ecReplicationConfig);
            }
            catch (Exception | LinkageError e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Failed to create raw erasure decoder " + rawCoderName + ", fallback to next codec if possible", e);
            }
        }
        throw new IllegalArgumentException("Fail to create raw erasure decoder with given codec: " + codecName);
    }
}

