/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.update.server;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hdds.protocol.scm.proto.SCMUpdateServiceProtos;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.update.server.SCMUpdateClientInfo;
import org.apache.hadoop.hdds.scm.update.server.SCMUpdateHandler;
import org.apache.ratis.thirdparty.io.grpc.Status;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMUpdateClientManager {
    private static final Logger LOG = LoggerFactory.getLogger(SCMUpdateClientManager.class);
    private Map<UUID, SCMUpdateClientInfo> clients = new ConcurrentHashMap<UUID, SCMUpdateClientInfo>();
    private Map<SCMUpdateServiceProtos.Type, SCMUpdateHandler> handlers = new ConcurrentHashMap<SCMUpdateServiceProtos.Type, SCMUpdateHandler>();

    public void registerHandler(SCMUpdateHandler handler) {
        this.handlers.put(handler.getType(), handler);
    }

    public void unRegisterHandler(SCMUpdateServiceProtos.Type type) {
        this.handlers.remove(type);
    }

    public UUID addClient() throws SCMException {
        UUID clientId = UUID.randomUUID();
        int retryCount = 5;
        while (this.clients.containsKey(clientId)) {
            if (retryCount > 0) {
                clientId = UUID.randomUUID();
                --retryCount;
                continue;
            }
            throw new SCMException("Failed to add CRL client with random clientId collision", SCMException.ResultCodes.FAILED_TO_ADD_CRL_CLIENT);
        }
        SCMUpdateClientInfo clientInfo = new SCMUpdateClientInfo(clientId);
        this.clients.put(clientId, clientInfo);
        return clientId;
    }

    public void handleClientUpdate(SCMUpdateServiceProtos.UpdateRequest request, StreamObserver<SCMUpdateServiceProtos.UpdateResponse> responseObserver) {
        SCMUpdateClientInfo clientInfo;
        UUID clientId = SCMUpdateClientInfo.fromClientIdProto((SCMUpdateServiceProtos.ClientId)request.getClientId());
        if (!this.clients.containsKey(clientId)) {
            responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("Client must subscribe before it can send/receive updates").asException());
        }
        if ((clientInfo = this.clients.get(clientId)).getResponseObserver() == null) {
            clientInfo.setResponseObserver(responseObserver);
        }
        if (this.handlers.containsKey(request.getUpdateType())) {
            this.handlers.get(request.getUpdateType()).handleClientRequest(request, clientInfo);
        } else {
            responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("Unknown client update type.").asException());
        }
    }

    public boolean removeClient(UUID clientId) {
        if (this.clients.containsKey(clientId)) {
            SCMUpdateClientInfo clientInfo = this.clients.remove(clientId);
            this.handlers.values().forEach(handler -> handler.onRemoveClient(clientInfo));
            LOG.info("Client {} removed.", (Object)clientId);
            return true;
        }
        return false;
    }

    public boolean removeClient(StreamObserver<SCMUpdateServiceProtos.UpdateResponse> responseObserver) {
        UUID clientId = null;
        for (SCMUpdateClientInfo client : this.clients.values()) {
            if (client.getResponseObserver() != responseObserver) continue;
            clientId = client.getClientId();
            break;
        }
        if (clientId != null) {
            LOG.debug("Remove client {} by responseObserver", clientId);
            this.removeClient(clientId);
            return true;
        }
        LOG.debug("Remove client {} by responseObserver not found!");
        return false;
    }

    public void onUpdate(SCMUpdateServiceProtos.Type type) {
        if (this.handlers.containsKey(type)) {
            this.handlers.get(type).onUpdate();
        } else {
            LOG.warn("Unknown update type to broadcast!");
        }
    }
}

