/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.protobuf.BlockingService;
import com.google.protobuf.ProtocolMessageEnum;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.ReconfigurationHandler;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.ReconfigureProtocol;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.ReconfigureProtocolProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerLocationProtocolProtos;
import org.apache.hadoop.hdds.protocolPB.ReconfigureProtocolPB;
import org.apache.hadoop.hdds.protocolPB.ReconfigureProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.apache.hadoop.hdds.scm.DatanodeAdminError;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.ScmUtils;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ReplicationManagerReport;
import org.apache.hadoop.hdds.scm.container.balancer.ContainerBalancer;
import org.apache.hadoop.hdds.scm.container.balancer.ContainerBalancerConfiguration;
import org.apache.hadoop.hdds.scm.container.balancer.IllegalContainerBalancerStateException;
import org.apache.hadoop.hdds.scm.container.balancer.InvalidContainerBalancerConfigurationException;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.container.common.helpers.DeletedBlocksTransactionInfoWrapper;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.ha.HASecurityUtils;
import org.apache.hadoop.hdds.scm.ha.SCMHAUtils;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServer;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServerImpl;
import org.apache.hadoop.hdds.scm.node.DatanodeUsageInfo;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolPB;
import org.apache.hadoop.hdds.scm.server.SCMPolicyProvider;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.ProtocolMessageMetrics;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditEventStatus;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.AuditLoggerType;
import org.apache.hadoop.ozone.audit.AuditMessage;
import org.apache.hadoop.ozone.audit.Auditor;
import org.apache.hadoop.ozone.audit.SCMAction;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.Token;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMClientProtocolServer
implements StorageContainerLocationProtocol,
Auditor {
    private static final Logger LOG = LoggerFactory.getLogger(SCMClientProtocolServer.class);
    private static final AuditLogger AUDIT = new AuditLogger(AuditLoggerType.SCMLOGGER);
    private final RPC.Server clientRpcServer;
    private final InetSocketAddress clientRpcAddress;
    private final StorageContainerManager scm;
    private final OzoneConfiguration config;
    private final ProtocolMessageMetrics<ProtocolMessageEnum> protocolMetrics;

    public SCMClientProtocolServer(OzoneConfiguration conf, StorageContainerManager scm, ReconfigurationHandler reconfigurationHandler) throws IOException {
        this.scm = scm;
        this.config = conf;
        int handlerCount = conf.getInt("ozone.scm.handler.count.key", 100);
        RPC.setProtocolEngine((Configuration)conf, StorageContainerLocationProtocolPB.class, ProtobufRpcEngine.class);
        this.protocolMetrics = ProtocolMessageMetrics.create((String)"ScmContainerLocationProtocol", (String)"SCM ContainerLocation protocol metrics", (Object[])StorageContainerLocationProtocolProtos.Type.values());
        BlockingService storageProtoPbService = StorageContainerLocationProtocolProtos.StorageContainerLocationProtocolService.newReflectiveBlockingService((StorageContainerLocationProtocolProtos.StorageContainerLocationProtocolService.BlockingInterface)new StorageContainerLocationProtocolServerSideTranslatorPB(this, scm, this.protocolMetrics));
        InetSocketAddress scmAddress = scm.getScmNodeDetails().getClientProtocolServerAddress();
        this.clientRpcServer = StorageContainerManager.startRpcServer(conf, scmAddress, StorageContainerLocationProtocolPB.class, storageProtoPbService, handlerCount);
        ReconfigureProtocolServerSideTranslatorPB reconfigureServerProtocol = new ReconfigureProtocolServerSideTranslatorPB((ReconfigureProtocol)reconfigurationHandler);
        BlockingService reconfigureService = ReconfigureProtocolProtos.ReconfigureProtocolService.newReflectiveBlockingService((ReconfigureProtocolProtos.ReconfigureProtocolService.BlockingInterface)reconfigureServerProtocol);
        HddsServerUtil.addPBProtocol((Configuration)conf, ReconfigureProtocolPB.class, (BlockingService)reconfigureService, (RPC.Server)this.clientRpcServer);
        this.clientRpcAddress = ServerUtils.updateRPCListenAddress((OzoneConfiguration)conf, (String)scm.getScmNodeDetails().getClientProtocolServerAddressKey(), (InetSocketAddress)scmAddress, (RPC.Server)this.clientRpcServer);
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.clientRpcServer.refreshServiceAcl((Configuration)conf, (PolicyProvider)SCMPolicyProvider.getInstance());
        }
        HddsServerUtil.addSuppressedLoggingExceptions((RPC.Server)this.clientRpcServer);
    }

    public RPC.Server getClientRpcServer() {
        return this.clientRpcServer;
    }

    public InetSocketAddress getClientRpcAddress() {
        return this.clientRpcAddress;
    }

    public void start() {
        this.protocolMetrics.register();
        LOG.info(StorageContainerManager.buildRpcServerStartMessage("RPC server for Client ", this.getClientRpcAddress()));
        this.getClientRpcServer().start();
    }

    public void stop() {
        this.protocolMetrics.unregister();
        try {
            LOG.info("Stopping the RPC server for Client Protocol");
            this.getClientRpcServer().stop();
        }
        catch (Exception ex) {
            LOG.error("Client Protocol RPC stop failed.", (Throwable)ex);
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.scm.getScmNodeManager()});
    }

    public void join() throws InterruptedException {
        LOG.trace("Join RPC server for Client Protocol");
        this.getClientRpcServer().join();
    }

    public ContainerWithPipeline allocateContainer(HddsProtos.ReplicationType replicationType, HddsProtos.ReplicationFactor factor, String owner) throws IOException {
        if (this.scm.getScmContext().isInSafeMode()) {
            throw new SCMException("SafeModePrecheck failed for allocateContainer", SCMException.ResultCodes.SAFE_MODE_EXCEPTION);
        }
        this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
        ContainerInfo container = this.scm.getContainerManager().allocateContainer(ReplicationConfig.fromProtoTypeAndFactor((HddsProtos.ReplicationType)replicationType, (HddsProtos.ReplicationFactor)factor), owner);
        Pipeline pipeline = this.scm.getPipelineManager().getPipeline(container.getPipelineID());
        return new ContainerWithPipeline(container, pipeline);
    }

    public ContainerInfo getContainer(long containerID) throws IOException {
        boolean auditSuccess = true;
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("containerID", String.valueOf(containerID));
        this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), true);
        try {
            ContainerInfo containerInfo = this.scm.getContainerManager().getContainer(ContainerID.valueOf((long)containerID));
            return containerInfo;
        }
        catch (IOException ex) {
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.GET_CONTAINER, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_CONTAINER, auditMap));
            }
        }
    }

    private ContainerWithPipeline getContainerWithPipelineCommon(long containerID) throws IOException {
        Pipeline pipeline;
        ContainerID cid = ContainerID.valueOf((long)containerID);
        ContainerInfo container = this.scm.getContainerManager().getContainer(cid);
        if (this.scm.getScmContext().isInSafeMode() && container.isOpen() && !this.hasRequiredReplicas(container)) {
            throw new SCMException("Open container " + containerID + " doesn't have enough replicas to service this operation in Safe mode.", SCMException.ResultCodes.SAFE_MODE_EXCEPTION);
        }
        try {
            pipeline = container.isOpen() ? this.scm.getPipelineManager().getPipeline(container.getPipelineID()) : null;
        }
        catch (PipelineNotFoundException ex) {
            pipeline = null;
        }
        if (pipeline == null) {
            pipeline = this.scm.getPipelineManager().createPipelineForRead(container.getReplicationConfig(), this.scm.getContainerManager().getContainerReplicas(cid));
        }
        return new ContainerWithPipeline(container, pipeline);
    }

    public ContainerWithPipeline getContainerWithPipeline(long containerID) throws IOException {
        try {
            ContainerWithPipeline cp = this.getContainerWithPipelineCommon(containerID);
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_CONTAINER_WITH_PIPELINE, Collections.singletonMap("containerID", ContainerID.valueOf((long)containerID).toString())));
            return cp;
        }
        catch (IOException ex) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.GET_CONTAINER_WITH_PIPELINE, Collections.singletonMap("containerID", ContainerID.valueOf((long)containerID).toString()), ex));
            throw ex;
        }
    }

    public List<HddsProtos.SCMContainerReplicaProto> getContainerReplicas(long containerId, int clientVersion) throws IOException {
        ArrayList<HddsProtos.SCMContainerReplicaProto> results = new ArrayList<HddsProtos.SCMContainerReplicaProto>();
        Set<ContainerReplica> replicas = this.getScm().getContainerManager().getContainerReplicas(ContainerID.valueOf((long)containerId));
        for (ContainerReplica r : replicas) {
            results.add(HddsProtos.SCMContainerReplicaProto.newBuilder().setContainerID(containerId).setState(r.getState().toString()).setDatanodeDetails(r.getDatanodeDetails().toProto(clientVersion)).setBytesUsed(r.getBytesUsed()).setPlaceOfBirth(r.getOriginDatanodeId().toString()).setKeyCount(r.getKeyCount()).setSequenceID(r.getSequenceId().longValue()).setReplicaIndex((long)r.getReplicaIndex()).build());
        }
        return results;
    }

    public List<ContainerWithPipeline> getContainerWithPipelineBatch(Iterable<? extends Long> containerIDs) throws IOException {
        ArrayList<ContainerWithPipeline> cpList = new ArrayList<ContainerWithPipeline>();
        StringBuilder strContainerIDs = new StringBuilder();
        for (Long l : containerIDs) {
            try {
                ContainerWithPipeline cp = this.getContainerWithPipelineCommon(l);
                cpList.add(cp);
                strContainerIDs.append(ContainerID.valueOf((long)l).toString());
                strContainerIDs.append(",");
            }
            catch (IOException ex) {
                AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.GET_CONTAINER_WITH_PIPELINE_BATCH, Collections.singletonMap("containerID", ContainerID.valueOf((long)l).toString()), ex));
                throw ex;
            }
        }
        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_CONTAINER_WITH_PIPELINE_BATCH, Collections.singletonMap("containerIDs", strContainerIDs.toString())));
        return cpList;
    }

    public List<ContainerWithPipeline> getExistContainerWithPipelinesInBatch(List<Long> containerIDs) {
        ArrayList<ContainerWithPipeline> cpList = new ArrayList<ContainerWithPipeline>();
        for (Long containerID : containerIDs) {
            try {
                ContainerWithPipeline cp = this.getContainerWithPipelineCommon(containerID);
                cpList.add(cp);
            }
            catch (IOException ex) {
                LOG.error("Container with common pipeline not found: {}", (Throwable)ex);
            }
        }
        return cpList;
    }

    private boolean hasRequiredReplicas(ContainerInfo contInfo) {
        try {
            return this.getScm().getContainerManager().getContainerReplicas(contInfo.containerID()).size() >= contInfo.getReplicationConfig().getRequiredNodes();
        }
        catch (ContainerNotFoundException ex) {
            return false;
        }
    }

    public List<ContainerInfo> listContainer(long startContainerID, int count) throws IOException {
        return this.listContainer(startContainerID, count, null, null, null);
    }

    public List<ContainerInfo> listContainer(long startContainerID, int count, HddsProtos.LifeCycleState state) throws IOException {
        return this.listContainer(startContainerID, count, state, null, null);
    }

    @Deprecated
    public List<ContainerInfo> listContainer(long startContainerID, int count, HddsProtos.LifeCycleState state, HddsProtos.ReplicationFactor factor) throws IOException {
        boolean auditSuccess = true;
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("startContainerID", String.valueOf(startContainerID));
        auditMap.put("count", String.valueOf(count));
        if (state != null) {
            auditMap.put("state", state.name());
        }
        if (factor != null) {
            auditMap.put("factor", factor.name());
        }
        try {
            ContainerID containerId = ContainerID.valueOf((long)startContainerID);
            if (state != null) {
                if (factor != null) {
                    List<ContainerInfo> list = this.scm.getContainerManager().getContainers(state).stream().filter(info -> info.containerID().getId() >= startContainerID).filter(info -> info.getReplicationType() != HddsProtos.ReplicationType.EC).filter(info -> info.getReplicationFactor() == factor).sorted().limit(count).collect(Collectors.toList());
                    return list;
                }
                List<ContainerInfo> list = this.scm.getContainerManager().getContainers(state).stream().filter(info -> info.containerID().getId() >= startContainerID).sorted().limit(count).collect(Collectors.toList());
                return list;
            }
            if (factor != null) {
                List<ContainerInfo> list = this.scm.getContainerManager().getContainers().stream().filter(info -> info.containerID().getId() >= startContainerID).filter(info -> info.getReplicationType() != HddsProtos.ReplicationType.EC).filter(info -> info.getReplicationFactor() == factor).sorted().limit(count).collect(Collectors.toList());
                return list;
            }
            List<ContainerInfo> list = this.scm.getContainerManager().getContainers(containerId, count);
            return list;
        }
        catch (Exception ex) {
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.LIST_CONTAINER, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.LIST_CONTAINER, auditMap));
            }
        }
    }

    public List<ContainerInfo> listContainer(long startContainerID, int count, HddsProtos.LifeCycleState state, HddsProtos.ReplicationType replicationType, ReplicationConfig repConfig) throws IOException {
        boolean auditSuccess = true;
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("startContainerID", String.valueOf(startContainerID));
        auditMap.put("count", String.valueOf(count));
        if (state != null) {
            auditMap.put("state", state.name());
        }
        if (replicationType != null) {
            auditMap.put("replicationType", replicationType.toString());
        }
        if (repConfig != null) {
            auditMap.put("replicationConfig", repConfig.toString());
        }
        try {
            ContainerID containerId = ContainerID.valueOf((long)startContainerID);
            if (state == null && replicationType == null && repConfig == null) {
                List<ContainerInfo> list = this.scm.getContainerManager().getContainers(containerId, count);
                return list;
            }
            List<ContainerInfo> containerList = state != null ? this.scm.getContainerManager().getContainers(state) : this.scm.getContainerManager().getContainers();
            Stream<ContainerInfo> containerStream = containerList.stream().filter(info -> info.containerID().getId() >= startContainerID);
            if (repConfig != null) {
                containerStream = containerStream.filter(info -> info.getReplicationConfig().equals(repConfig));
            } else if (replicationType != null) {
                containerStream = containerStream.filter(info -> info.getReplicationType() == replicationType);
            }
            List<ContainerInfo> list = containerStream.sorted().limit(count).collect(Collectors.toList());
            return list;
        }
        catch (Exception ex) {
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.LIST_CONTAINER, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.LIST_CONTAINER, auditMap));
            }
        }
    }

    public void deleteContainer(long containerID) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("containerID", String.valueOf(containerID));
        UserGroupInformation remoteUser = HddsServerUtil.getRemoteUser();
        auditMap.put("remoteUser", remoteUser.getUserName());
        try {
            this.getScm().checkAdminAccess(remoteUser, false);
            this.scm.getContainerManager().deleteContainer(ContainerID.valueOf((long)containerID));
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.DELETE_CONTAINER, auditMap));
        }
        catch (Exception ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.DELETE_CONTAINER, auditMap, ex));
            throw ex;
        }
    }

    public List<HddsProtos.Node> queryNode(HddsProtos.NodeOperationalState opState, HddsProtos.NodeState state, HddsProtos.QueryScope queryScope, String poolName, int clientVersion) throws IOException {
        if (queryScope == HddsProtos.QueryScope.POOL) {
            throw new IllegalArgumentException("Not Supported yet");
        }
        ArrayList<HddsProtos.Node> result = new ArrayList<HddsProtos.Node>();
        for (DatanodeDetails node : this.queryNode(opState, state)) {
            try {
                NodeStatus ns = this.scm.getScmNodeManager().getNodeStatus(node);
                result.add(HddsProtos.Node.newBuilder().setNodeID(node.toProto(clientVersion)).addNodeStates(ns.getHealth()).addNodeOperationalStates(ns.getOperationalState()).build());
            }
            catch (NodeNotFoundException e) {
                throw new IOException("An unexpected error occurred querying the NodeStatus", e);
            }
        }
        return result;
    }

    public List<DatanodeAdminError> decommissionNodes(List<String> nodes) throws IOException {
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
            return this.scm.getScmDecommissionManager().decommissionNodes(nodes);
        }
        catch (Exception ex) {
            LOG.error("Failed to decommission nodes", (Throwable)ex);
            throw ex;
        }
    }

    public List<DatanodeAdminError> recommissionNodes(List<String> nodes) throws IOException {
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
            return this.scm.getScmDecommissionManager().recommissionNodes(nodes);
        }
        catch (Exception ex) {
            LOG.error("Failed to recommission nodes", (Throwable)ex);
            throw ex;
        }
    }

    public List<DatanodeAdminError> startMaintenanceNodes(List<String> nodes, int endInHours) throws IOException {
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
            return this.scm.getScmDecommissionManager().startMaintenanceNodes(nodes, endInHours);
        }
        catch (Exception ex) {
            LOG.error("Failed to place nodes into maintenance mode", (Throwable)ex);
            throw ex;
        }
    }

    public void closeContainer(long containerID) throws IOException {
        this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
        UserGroupInformation remoteUser = HddsServerUtil.getRemoteUser();
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("containerID", String.valueOf(containerID));
        auditMap.put("remoteUser", remoteUser.getUserName());
        try {
            this.scm.checkAdminAccess(remoteUser, false);
            ContainerID cid = ContainerID.valueOf((long)containerID);
            HddsProtos.LifeCycleState state = this.scm.getContainerManager().getContainer(cid).getState();
            if (!state.equals((Object)HddsProtos.LifeCycleState.OPEN)) {
                SCMException.ResultCodes resultCode = SCMException.ResultCodes.UNEXPECTED_CONTAINER_STATE;
                if (state.equals((Object)HddsProtos.LifeCycleState.CLOSED)) {
                    resultCode = SCMException.ResultCodes.CONTAINER_ALREADY_CLOSED;
                }
                if (state.equals((Object)HddsProtos.LifeCycleState.CLOSING)) {
                    resultCode = SCMException.ResultCodes.CONTAINER_ALREADY_CLOSING;
                }
                throw new SCMException("Cannot close a " + state + " container.", resultCode);
            }
            this.scm.getEventQueue().fireEvent(SCMEvents.CLOSE_CONTAINER, (Object)ContainerID.valueOf((long)containerID));
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.CLOSE_CONTAINER, auditMap));
        }
        catch (Exception ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.CLOSE_CONTAINER, auditMap, ex));
            throw ex;
        }
    }

    public Pipeline createReplicationPipeline(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, HddsProtos.NodePool nodePool) throws IOException {
        this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
        HashMap auditMap = Maps.newHashMap();
        if (type != null) {
            auditMap.put("replicationType", type.toString());
        }
        if (factor != null) {
            auditMap.put("replicationFactor", factor.toString());
        }
        if (nodePool != null && !nodePool.getNodesList().isEmpty()) {
            ArrayList<String> nodeIpAddresses = new ArrayList<String>();
            for (HddsProtos.Node node : nodePool.getNodesList()) {
                nodeIpAddresses.add(node.getNodeID().getIpAddress());
            }
            auditMap.put("nodePool", String.join((CharSequence)", ", nodeIpAddresses));
        }
        try {
            Pipeline result = this.scm.getPipelineManager().createPipeline(ReplicationConfig.fromProtoTypeAndFactor((HddsProtos.ReplicationType)type, (HddsProtos.ReplicationFactor)factor));
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.CREATE_PIPELINE, auditMap));
            return result;
        }
        catch (SCMException e) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.CREATE_PIPELINE, auditMap, e));
            throw e;
        }
    }

    public List<Pipeline> listPipelines() {
        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.LIST_PIPELINE, null));
        return this.scm.getPipelineManager().getPipelines();
    }

    public Pipeline getPipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        return this.scm.getPipelineManager().getPipeline(PipelineID.getFromProtobuf((HddsProtos.PipelineID)pipelineID));
    }

    public void activatePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("pipelineID", pipelineID.getId());
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
            this.scm.getPipelineManager().activatePipeline(PipelineID.getFromProtobuf((HddsProtos.PipelineID)pipelineID));
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.ACTIVATE_PIPELINE, auditMap));
        }
        catch (Exception ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.ACTIVATE_PIPELINE, auditMap, ex));
            throw ex;
        }
    }

    public void deactivatePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("pipelineID", pipelineID.getId());
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
            this.scm.getPipelineManager().deactivatePipeline(PipelineID.getFromProtobuf((HddsProtos.PipelineID)pipelineID));
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.DEACTIVATE_PIPELINE, auditMap));
        }
        catch (Exception ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.DEACTIVATE_PIPELINE, auditMap, ex));
            throw ex;
        }
    }

    public void closePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
            auditMap.put("pipelineID", pipelineID.getId());
            PipelineManager pipelineManager = this.scm.getPipelineManager();
            Pipeline pipeline = pipelineManager.getPipeline(PipelineID.getFromProtobuf((HddsProtos.PipelineID)pipelineID));
            pipelineManager.closePipeline(pipeline, true);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.CLOSE_PIPELINE, auditMap));
        }
        catch (Exception ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.CLOSE_PIPELINE, auditMap, ex));
        }
    }

    public ScmInfo getScmInfo() {
        boolean auditSuccess = true;
        try {
            ScmInfo.Builder builder = new ScmInfo.Builder().setClusterId(this.scm.getScmStorageConfig().getClusterID()).setScmId(this.scm.getScmStorageConfig().getScmId());
            if (this.scm.getScmHAManager().getRatisServer() != null) {
                builder.setRatisPeerRoles(this.scm.getScmHAManager().getRatisServer().getRatisRoles());
            } else {
                String address = this.scm.getSCMHANodeDetails().getLocalNodeDetails().getRatisHostPortStr();
                builder.setRatisPeerRoles(Arrays.asList(address));
            }
            ScmInfo scmInfo = builder.build();
            return scmInfo;
        }
        catch (Exception ex) {
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.GET_SCM_INFO, null, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_SCM_INFO, null));
            }
        }
    }

    public void transferLeadership(String newLeaderId) throws IOException {
        this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
        if (!SCMHAUtils.isSCMHAEnabled((ConfigurationSource)this.getScm().getConfiguration())) {
            throw new SCMException("SCM HA not enabled.", SCMException.ResultCodes.INTERNAL_ERROR);
        }
        ScmUtils.checkIfCertSignRequestAllowed(this.scm.getRootCARotationManager(), false, this.config, "transferLeadership");
        boolean auditSuccess = true;
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("newLeaderId", newLeaderId);
        try {
            RaftPeerId targetPeerId;
            SCMRatisServer scmRatisServer = this.scm.getScmHAManager().getRatisServer();
            RaftGroup group = scmRatisServer.getDivision().getGroup();
            if (newLeaderId.isEmpty()) {
                RaftPeer curLeader = ((SCMRatisServerImpl)this.scm.getScmHAManager().getRatisServer()).getLeader();
                targetPeerId = group.getPeers().stream().filter(a -> !a.equals((Object)curLeader)).findFirst().map(RaftPeer::getId).orElseThrow(() -> new IOException("Cannot find a new leader to transfer leadership."));
            } else {
                targetPeerId = RaftPeerId.valueOf((String)newLeaderId);
            }
            GrpcTlsConfig tlsConfig = HASecurityUtils.createSCMRatisTLSConfig(new SecurityConfig((ConfigurationSource)this.scm.getConfiguration()), this.scm.getScmCertificateClient());
            RatisHelper.transferRatisLeadership((ConfigurationSource)this.scm.getConfiguration(), (RaftGroup)group, (RaftPeerId)targetPeerId, (GrpcTlsConfig)tlsConfig);
        }
        catch (Exception ex) {
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.TRANSFER_LEADERSHIP, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.TRANSFER_LEADERSHIP, auditMap));
            }
        }
    }

    public List<HddsProtos.DeletedBlocksTransactionInfo> getFailedDeletedBlockTxn(int count, long startTxId) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("count", String.valueOf(count));
        auditMap.put("startTxId", String.valueOf(startTxId));
        try {
            List<HddsProtos.DeletedBlocksTransactionInfo> result = this.scm.getScmBlockManager().getDeletedBlockLog().getFailedTransactions(count, startTxId).stream().map(DeletedBlocksTransactionInfoWrapper::fromTxn).collect(Collectors.toList());
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_FAILED_DELETED_BLOCKS_TRANSACTION, auditMap));
            return result;
        }
        catch (IOException ex) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.GET_FAILED_DELETED_BLOCKS_TRANSACTION, auditMap, ex));
            throw ex;
        }
    }

    public int resetDeletedBlockRetryCount(List<Long> txIDs) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
        try {
            int count = this.scm.getScmBlockManager().getDeletedBlockLog().resetCount(txIDs);
            auditMap.put("txIDs", txIDs.toString());
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.RESET_DELETED_BLOCK_RETRY_COUNT, auditMap));
            return count;
        }
        catch (Exception ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.RESET_DELETED_BLOCK_RETRY_COUNT, auditMap, ex));
            throw ex;
        }
    }

    public boolean inSafeMode() throws IOException {
        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.IN_SAFE_MODE, null));
        return this.scm.isInSafeMode();
    }

    public Map<String, Pair<Boolean, String>> getSafeModeRuleStatuses() throws IOException {
        return this.scm.getRuleStatus();
    }

    public boolean forceExitSafeMode() throws IOException {
        this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
        AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.FORCE_EXIT_SAFE_MODE, null));
        return this.scm.exitSafeMode();
    }

    public void startReplicationManager() throws IOException {
        this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
        AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.START_REPLICATION_MANAGER, null));
        this.scm.getReplicationManager().start();
    }

    public void stopReplicationManager() throws IOException {
        this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
        AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.STOP_REPLICATION_MANAGER, null));
        this.scm.getReplicationManager().stop();
    }

    public boolean getReplicationManagerStatus() {
        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_REPLICATION_MANAGER_STATUS, null));
        return this.scm.getReplicationManager().isRunning();
    }

    public ReplicationManagerReport getReplicationManagerReport() {
        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_REPLICATION_MANAGER_REPORT, null));
        return this.scm.getReplicationManager().getContainerReport();
    }

    public UpgradeFinalizer.StatusAndMessages finalizeScmUpgrade(String upgradeClientID) throws IOException {
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
        }
        catch (IOException e) {
            LOG.error("Authorization failed for finalize scm upgrade", (Throwable)e);
            throw e;
        }
        return this.scm.getFinalizationManager().finalizeUpgrade(upgradeClientID);
    }

    public UpgradeFinalizer.StatusAndMessages queryUpgradeFinalizationProgress(String upgradeClientID, boolean force, boolean readonly) throws IOException {
        if (!readonly) {
            try {
                this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), true);
            }
            catch (IOException e) {
                LOG.error("Authorization failed for query scm upgrade finalization progress", (Throwable)e);
                throw e;
            }
        }
        return this.scm.getFinalizationManager().queryUpgradeFinalizationProgress(upgradeClientID, force, readonly);
    }

    public StorageContainerLocationProtocolProtos.StartContainerBalancerResponseProto startContainerBalancer(Optional<Double> threshold, Optional<Integer> iterations, Optional<Integer> maxDatanodesPercentageToInvolvePerIteration, Optional<Long> maxSizeToMovePerIterationInGB, Optional<Long> maxSizeEnteringTarget, Optional<Long> maxSizeLeavingSource) throws IOException {
        this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
        ContainerBalancerConfiguration cbc = (ContainerBalancerConfiguration)this.scm.getConfiguration().getObject(ContainerBalancerConfiguration.class);
        HashMap auditMap = Maps.newHashMap();
        if (threshold.isPresent()) {
            double tsd = threshold.get();
            auditMap.put("threshold", String.valueOf(tsd));
            Preconditions.checkState((tsd >= 0.0 && tsd < 100.0 ? 1 : 0) != 0, (Object)"threshold should be specified in range [0.0, 100.0).");
            cbc.setThreshold(tsd);
        }
        if (maxSizeToMovePerIterationInGB.isPresent()) {
            long mstm = maxSizeToMovePerIterationInGB.get();
            auditMap.put("maxSizeToMovePerIterationInGB", String.valueOf(mstm));
            Preconditions.checkState((mstm > 0L ? 1 : 0) != 0, (Object)"maxSizeToMovePerIterationInGB must be positive.");
            cbc.setMaxSizeToMovePerIteration(mstm * 0x40000000L);
        }
        if (maxDatanodesPercentageToInvolvePerIteration.isPresent()) {
            int mdti = maxDatanodesPercentageToInvolvePerIteration.get();
            auditMap.put("maxDatanodesPercentageToInvolvePerIteration", String.valueOf(mdti));
            Preconditions.checkState((mdti >= 0 ? 1 : 0) != 0, (Object)"maxDatanodesPercentageToInvolvePerIteration must be greater than equal to zero.");
            Preconditions.checkState((mdti <= 100 ? 1 : 0) != 0, (Object)"maxDatanodesPercentageToInvolvePerIteration must be lesser than or equal to 100.");
            cbc.setMaxDatanodesPercentageToInvolvePerIteration(mdti);
        }
        if (iterations.isPresent()) {
            int i = iterations.get();
            auditMap.put("iterations", String.valueOf(i));
            Preconditions.checkState((i > 0 || i == -1 ? 1 : 0) != 0, (Object)"number of iterations must be positive or -1 (for running container balancer infinitely).");
            cbc.setIterations(i);
        }
        if (maxSizeEnteringTarget.isPresent()) {
            long mset = maxSizeEnteringTarget.get();
            auditMap.put("maxSizeEnteringTarget", String.valueOf(mset));
            Preconditions.checkState((mset > 0L ? 1 : 0) != 0, (Object)"maxSizeEnteringTarget must be greater than zero.");
            cbc.setMaxSizeEnteringTarget(mset * 0x40000000L);
        }
        if (maxSizeLeavingSource.isPresent()) {
            long msls = maxSizeLeavingSource.get();
            auditMap.put("maxSizeLeavingSource", String.valueOf(msls));
            Preconditions.checkState((msls > 0L ? 1 : 0) != 0, (Object)"maxSizeLeavingSource must be greater than zero.");
            cbc.setMaxSizeLeavingSource(msls * 0x40000000L);
        }
        ContainerBalancer containerBalancer = this.scm.getContainerBalancer();
        try {
            containerBalancer.startBalancer(cbc);
        }
        catch (IOException | IllegalContainerBalancerStateException | InvalidContainerBalancerConfigurationException e) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.START_CONTAINER_BALANCER, auditMap, e));
            return StorageContainerLocationProtocolProtos.StartContainerBalancerResponseProto.newBuilder().setStart(false).setMessage(e.getMessage()).build();
        }
        AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.START_CONTAINER_BALANCER, auditMap));
        return StorageContainerLocationProtocolProtos.StartContainerBalancerResponseProto.newBuilder().setStart(true).build();
    }

    public void stopContainerBalancer() throws IOException {
        this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
        try {
            this.scm.getContainerBalancer().stopBalancer();
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.STOP_CONTAINER_BALANCER, null));
        }
        catch (IllegalContainerBalancerStateException e) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.STOP_CONTAINER_BALANCER, null, e));
        }
    }

    public boolean getContainerBalancerStatus() {
        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_CONTAINER_BALANCER_STATUS, null));
        return this.scm.getContainerBalancer().isBalancerRunning();
    }

    public List<HddsProtos.DatanodeUsageInfoProto> getDatanodeUsageInfo(String address, String uuid, int clientVersion) throws IOException {
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), true);
        }
        catch (IOException e) {
            LOG.error("Authorization failed", (Throwable)e);
            throw e;
        }
        List<Object> nodes = new ArrayList<DatanodeDetails>();
        if (!Strings.isNullOrEmpty((String)uuid)) {
            nodes.add(this.scm.getScmNodeManager().getNodeByUuid(uuid));
        } else if (!Strings.isNullOrEmpty((String)address)) {
            nodes = this.scm.getScmNodeManager().getNodesByAddress(address);
        } else {
            throw new IOException("Could not get datanode with the specified parameters.");
        }
        ArrayList<HddsProtos.DatanodeUsageInfoProto> infoList = new ArrayList<HddsProtos.DatanodeUsageInfoProto>();
        for (DatanodeDetails datanodeDetails : nodes) {
            infoList.add(this.getUsageInfoFromDatanodeDetails(datanodeDetails, clientVersion));
        }
        return infoList;
    }

    private HddsProtos.DatanodeUsageInfoProto getUsageInfoFromDatanodeDetails(DatanodeDetails node, int clientVersion) {
        DatanodeUsageInfo usageInfo = this.scm.getScmNodeManager().getUsageInfo(node);
        return usageInfo.toProto(clientVersion);
    }

    public List<HddsProtos.DatanodeUsageInfoProto> getDatanodeUsageInfo(boolean mostUsed, int count, int clientVersion) throws IOException, IllegalArgumentException {
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), true);
        }
        catch (IOException e) {
            LOG.error("Authorization failed", (Throwable)e);
            throw e;
        }
        if (count < 1) {
            throw new IllegalArgumentException("The specified parameter count must be an integer greater than zero.");
        }
        List<DatanodeUsageInfo> datanodeUsageInfoList = this.scm.getScmNodeManager().getMostOrLeastUsedDatanodes(mostUsed);
        if (count > datanodeUsageInfoList.size()) {
            count = datanodeUsageInfoList.size();
        }
        return datanodeUsageInfoList.stream().map(each -> each.toProto(clientVersion)).limit(count).collect(Collectors.toList());
    }

    public Token<?> getContainerToken(ContainerID containerID) throws IOException {
        UserGroupInformation remoteUser = HddsServerUtil.getRemoteUser();
        this.getScm().checkAdminAccess(remoteUser, true);
        return this.scm.getContainerTokenGenerator().generateToken(remoteUser.getUserName(), containerID);
    }

    public long getContainerCount() throws IOException {
        return this.scm.getContainerManager().getContainers().size();
    }

    public long getContainerCount(HddsProtos.LifeCycleState state) throws IOException {
        return this.scm.getContainerManager().getContainers(state).size();
    }

    public List<ContainerInfo> getListOfContainers(long startContainerID, int count, HddsProtos.LifeCycleState state) throws IOException {
        return this.scm.getContainerManager().getContainers(ContainerID.valueOf((long)startContainerID), count, state);
    }

    public List<DatanodeDetails> queryNode(HddsProtos.NodeOperationalState opState, HddsProtos.NodeState state) {
        return new ArrayList<DatanodeDetails>(this.queryNodeState(opState, state));
    }

    @VisibleForTesting
    public StorageContainerManager getScm() {
        return this.scm;
    }

    public boolean getSafeModeStatus() {
        return this.scm.getScmContext().isInSafeMode();
    }

    private Set<DatanodeDetails> queryNodeState(HddsProtos.NodeOperationalState opState, HddsProtos.NodeState nodeState) {
        TreeSet<DatanodeDetails> returnSet = new TreeSet<DatanodeDetails>();
        List<DatanodeDetails> tmp = this.scm.getScmNodeManager().getNodes(opState, nodeState);
        if (tmp != null && tmp.size() > 0) {
            returnSet.addAll(tmp);
        }
        return returnSet;
    }

    public AuditMessage buildAuditMessageForSuccess(AuditAction op, Map<String, String> auditMap) {
        return new AuditMessage.Builder().setUser(ServerUtils.getRemoteUserName()).atIp(Server.getRemoteAddress()).forOperation(op).withParams(auditMap).withResult(AuditEventStatus.SUCCESS).build();
    }

    public AuditMessage buildAuditMessageForFailure(AuditAction op, Map<String, String> auditMap, Throwable throwable) {
        return new AuditMessage.Builder().setUser(ServerUtils.getRemoteUserName()).atIp(Server.getRemoteAddress()).forOperation(op).withParams(auditMap).withResult(AuditEventStatus.FAILURE).withException(throwable).build();
    }

    public void close() throws IOException {
        this.stop();
    }

    public StorageContainerLocationProtocolProtos.DecommissionScmResponseProto decommissionScm(String scmId) {
        StorageContainerLocationProtocolProtos.DecommissionScmResponseProto.Builder decommissionScmResponseBuilder = StorageContainerLocationProtocolProtos.DecommissionScmResponseProto.newBuilder();
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
            decommissionScmResponseBuilder.setSuccess(this.scm.removePeerFromHARing(scmId));
        }
        catch (IOException ex) {
            decommissionScmResponseBuilder.setSuccess(false).setErrorMsg(ex.getMessage());
        }
        return decommissionScmResponseBuilder.build();
    }
}

