/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.security;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.hadoop.hdds.protocol.proto.SCMRatisProtocol;
import org.apache.hadoop.hdds.scm.ha.SCMHAInvocationHandler;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServer;
import org.apache.hadoop.hdds.security.symmetric.SecretKeyState;
import org.apache.hadoop.hdds.security.symmetric.SecretKeyStateImpl;
import org.apache.hadoop.hdds.security.symmetric.SecretKeyStore;

public class ScmSecretKeyStateBuilder {
    private SecretKeyStore secretKeyStore;
    private SCMRatisServer scmRatisServer;

    public ScmSecretKeyStateBuilder setSecretKeyStore(SecretKeyStore secretKeyStore) {
        this.secretKeyStore = secretKeyStore;
        return this;
    }

    public ScmSecretKeyStateBuilder setRatisServer(SCMRatisServer ratisServer) {
        this.scmRatisServer = ratisServer;
        return this;
    }

    public SecretKeyState build() {
        SecretKeyStateImpl impl = new SecretKeyStateImpl(this.secretKeyStore);
        SCMHAInvocationHandler scmhaInvocationHandler = new SCMHAInvocationHandler(SCMRatisProtocol.RequestType.SECRET_KEY, impl, this.scmRatisServer);
        return (SecretKeyState)Proxy.newProxyInstance(SCMHAInvocationHandler.class.getClassLoader(), new Class[]{SecretKeyState.class}, (InvocationHandler)scmhaInvocationHandler);
    }
}

