/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.protocol.commands.ClosePipelineCommand;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineActionHandler
implements EventHandler<SCMDatanodeHeartbeatDispatcher.PipelineActionsFromDatanode> {
    public static final Logger LOG = LoggerFactory.getLogger(PipelineActionHandler.class);
    private final PipelineManager pipelineManager;
    private final SCMContext scmContext;
    private final ConfigurationSource ozoneConf;

    public PipelineActionHandler(PipelineManager pipelineManager, SCMContext scmContext, OzoneConfiguration conf) {
        this.pipelineManager = pipelineManager;
        this.scmContext = scmContext;
        this.ozoneConf = conf;
    }

    public void onMessage(SCMDatanodeHeartbeatDispatcher.PipelineActionsFromDatanode report, EventPublisher publisher) {
        ((StorageContainerDatanodeProtocolProtos.PipelineActionsProto)report.getReport()).getPipelineActionsList().forEach(action -> this.processPipelineAction(report.getDatanodeDetails(), (StorageContainerDatanodeProtocolProtos.PipelineAction)action, publisher));
    }

    private void processPipelineAction(DatanodeDetails datanode, StorageContainerDatanodeProtocolProtos.PipelineAction pipelineAction, EventPublisher publisher) {
        StorageContainerDatanodeProtocolProtos.ClosePipelineInfo info = pipelineAction.getClosePipeline();
        StorageContainerDatanodeProtocolProtos.PipelineAction.Action action = pipelineAction.getAction();
        PipelineID pid = PipelineID.getFromProtobuf((HddsProtos.PipelineID)info.getPipelineID());
        String logMsg = "Received pipeline action " + action + " for " + pid + " from datanode " + datanode.getUuidString() + ". Reason : " + info.getDetailedReason();
        if (!this.scmContext.isLeader()) {
            LOG.debug(logMsg);
            LOG.debug("Cannot process Pipeline Action for pipeline {} as current SCM is not leader.", (Object)pid);
            return;
        }
        LOG.info(logMsg);
        try {
            if (action == StorageContainerDatanodeProtocolProtos.PipelineAction.Action.CLOSE) {
                this.pipelineManager.closePipeline(pid);
            } else {
                LOG.error("Received unknown pipeline action {}, for pipeline {} ", (Object)action, (Object)pid);
            }
        }
        catch (PipelineNotFoundException e) {
            this.closeUnknownPipeline(publisher, datanode, pid);
        }
        catch (SCMException e) {
            if (e.getResult() == SCMException.ResultCodes.SCM_NOT_LEADER) {
                LOG.info("Cannot process Pipeline Action for pipeline {} as current SCM is not leader anymore.", (Object)pid);
            } else {
                LOG.error("Exception while processing Pipeline Action for Pipeline {}", (Object)pid, (Object)e);
            }
        }
        catch (IOException e) {
            LOG.error("Exception while processing Pipeline Action for Pipeline {}", (Object)pid, (Object)e);
        }
    }

    private void closeUnknownPipeline(EventPublisher publisher, DatanodeDetails datanode, PipelineID pid) {
        try {
            LOG.warn("Pipeline action received for unknown Pipeline {}, firing close pipeline event.", (Object)pid);
            ClosePipelineCommand command = new ClosePipelineCommand(pid);
            command.setTerm(this.scmContext.getTermOfLeader());
            publisher.fireEvent(SCMEvents.DATANODE_COMMAND, (Object)new CommandForDatanode(datanode.getUuid(), (SCMCommand)command));
        }
        catch (NotLeaderException nle) {
            LOG.info("Cannot process Pipeline Action for pipeline {} as current SCM is not leader anymore.", (Object)pid);
        }
    }
}

