/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node.states;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.node.states.Node2ObjectsMap;

public class Node2ContainerMap
extends Node2ObjectsMap<ContainerID> {
    public Set<ContainerID> getContainers(UUID datanode) {
        return this.getObjects(datanode);
    }

    @Override
    public void insertNewDatanode(UUID datanodeID, Set<ContainerID> containerIDs) throws SCMException {
        super.insertNewDatanode(datanodeID, containerIDs);
    }

    public void setContainersForDatanode(UUID datanodeID, Set<ContainerID> containers) throws SCMException {
        Preconditions.checkNotNull((Object)datanodeID);
        Preconditions.checkNotNull(containers);
        if (this.dn2ObjectMap.computeIfPresent(datanodeID, (k, v) -> new HashSet(containers)) == null) {
            throw new SCMException("No such datanode", SCMException.ResultCodes.NO_SUCH_DATANODE);
        }
    }

    @Override
    @VisibleForTesting
    public int size() {
        return this.dn2ObjectMap.size();
    }
}

