/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import java.net.InetSocketAddress;
import org.apache.hadoop.hdds.NodeDetails;
import org.apache.hadoop.net.NetUtils;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftPeerId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SCMNodeDetails
extends NodeDetails {
    private InetSocketAddress blockProtocolServerAddress;
    private String blockProtocolServerAddressKey;
    private InetSocketAddress clientProtocolServerAddress;
    private String clientProtocolServerAddressKey;
    private InetSocketAddress datanodeProtocolServerAddress;
    private String datanodeAddressKey;
    private int grpcPort;
    public static final Logger LOG = LoggerFactory.getLogger(SCMNodeDetails.class);

    private SCMNodeDetails(String serviceId, String nodeId, InetSocketAddress rpcAddr, int ratisPort, int grpcPort, String httpAddress, String httpsAddress, InetSocketAddress blockProtocolServerAddress, InetSocketAddress clientProtocolServerAddress, InetSocketAddress datanodeProtocolServerAddress, RaftGroup group, RaftPeerId selfPeerId, String datanodeAddressKey, String blockProtocolServerAddressKey, String clientProtocolServerAddressAddressKey) {
        super(serviceId, nodeId, rpcAddr, ratisPort, httpAddress, httpsAddress);
        this.grpcPort = grpcPort;
        this.blockProtocolServerAddress = blockProtocolServerAddress;
        this.clientProtocolServerAddress = clientProtocolServerAddress;
        this.datanodeProtocolServerAddress = datanodeProtocolServerAddress;
        this.datanodeAddressKey = datanodeAddressKey;
        this.blockProtocolServerAddressKey = blockProtocolServerAddressKey;
        this.clientProtocolServerAddressKey = clientProtocolServerAddressAddressKey;
    }

    public String toString() {
        return "SCMNodeDetails[scmServiceId=" + this.getServiceId() + ", scmNodeId=" + this.getNodeId() + ", rpcAddress=" + this.getRpcAddressString() + ", ratisPort=" + this.getRatisPort() + ", httpAddress=" + this.getHttpAddress() + ", httpsAddress=" + this.getHttpsAddress() + ", blockProtocolServerAddress=" + this.getBlockProtocolServerAddress() + ", clientProtocolServerAddress=" + this.getClientProtocolServerAddress() + ", datanodeProtocolServerAddress=" + this.getDatanodeProtocolServerAddress() + "]";
    }

    public String getRpcAddressString() {
        return NetUtils.getHostPortString((InetSocketAddress)this.getRpcAddress());
    }

    public InetSocketAddress getClientProtocolServerAddress() {
        return this.clientProtocolServerAddress;
    }

    public String getClientProtocolServerAddressKey() {
        return this.clientProtocolServerAddressKey;
    }

    public InetSocketAddress getBlockProtocolServerAddress() {
        return this.blockProtocolServerAddress;
    }

    public String getBlockProtocolServerAddressKey() {
        return this.blockProtocolServerAddressKey;
    }

    public InetSocketAddress getDatanodeProtocolServerAddress() {
        return this.datanodeProtocolServerAddress;
    }

    public String getDatanodeAddressKey() {
        return this.datanodeAddressKey;
    }

    public int getGrpcPort() {
        return this.grpcPort;
    }

    public static class Builder {
        private String scmServiceId;
        private String scmNodeId;
        private InetSocketAddress rpcAddress;
        private int ratisPort;
        private int grpcPort;
        private String httpAddr;
        private String httpsAddr;
        private InetSocketAddress blockProtocolServerAddress;
        private String blockProtocolServerAddressKey;
        private InetSocketAddress clientProtocolServerAddress;
        private String clientProtocolServerAddressKey;
        private InetSocketAddress datanodeProtocolServerAddress;
        private String datanodeAddressKey;
        private RaftGroup raftGroup;
        private RaftPeerId selfPeerId;

        public Builder setDatanodeAddressKey(String addressKey) {
            this.datanodeAddressKey = addressKey;
            return this;
        }

        public Builder setBlockProtocolServerAddressKey(String addressKey) {
            this.blockProtocolServerAddressKey = addressKey;
            return this;
        }

        public Builder setBlockProtocolServerAddress(InetSocketAddress address) {
            this.blockProtocolServerAddress = address;
            return this;
        }

        public Builder setClientProtocolServerAddress(InetSocketAddress address) {
            this.clientProtocolServerAddress = address;
            return this;
        }

        public Builder setClientProtocolServerAddressKey(String addressKey) {
            this.clientProtocolServerAddressKey = addressKey;
            return this;
        }

        public Builder setDatanodeProtocolServerAddress(InetSocketAddress address) {
            this.datanodeProtocolServerAddress = address;
            return this;
        }

        public Builder setRaftGroup(RaftGroup group) {
            this.raftGroup = group;
            return this;
        }

        public Builder setSelfPeerId(RaftPeerId peerId) {
            this.selfPeerId = peerId;
            return this;
        }

        public Builder setRpcAddress(InetSocketAddress rpcAddr) {
            this.rpcAddress = rpcAddr;
            return this;
        }

        public Builder setRatisPort(int port) {
            this.ratisPort = port;
            return this;
        }

        public Builder setGrpcPort(int port) {
            this.grpcPort = port;
            return this;
        }

        public Builder setSCMServiceId(String serviceId) {
            this.scmServiceId = serviceId;
            return this;
        }

        public Builder setSCMNodeId(String nodeId) {
            this.scmNodeId = nodeId;
            return this;
        }

        public Builder setHttpAddress(String httpAddress) {
            this.httpAddr = httpAddress;
            return this;
        }

        public Builder setHttpsAddress(String httpsAddress) {
            this.httpsAddr = httpsAddress;
            return this;
        }

        public SCMNodeDetails build() {
            return new SCMNodeDetails(this.scmServiceId, this.scmNodeId, this.rpcAddress, this.ratisPort, this.grpcPort, this.httpAddr, this.httpsAddr, this.blockProtocolServerAddress, this.clientProtocolServerAddress, this.datanodeProtocolServerAddress, this.raftGroup, this.selfPeerId, this.datanodeAddressKey, this.blockProtocolServerAddressKey, this.clientProtocolServerAddressKey);
        }
    }
}

