/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.protocol.proto.SCMRatisProtocol;
import org.apache.hadoop.hdds.scm.AddSCMRequest;
import org.apache.hadoop.hdds.scm.RemoveSCMRequest;
import org.apache.hadoop.hdds.scm.ha.SCMHADBTransactionBuffer;
import org.apache.hadoop.hdds.scm.ha.SCMHADBTransactionBufferStub;
import org.apache.hadoop.hdds.scm.ha.SCMHAManager;
import org.apache.hadoop.hdds.scm.ha.SCMRatisRequest;
import org.apache.hadoop.hdds.scm.ha.SCMRatisResponse;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServer;
import org.apache.hadoop.hdds.scm.ha.SCMSnapshotProvider;
import org.apache.hadoop.hdds.scm.ha.SCMStateMachine;
import org.apache.hadoop.hdds.scm.metadata.DBTransactionBuffer;
import org.apache.hadoop.hdds.security.symmetric.ManagedSecretKey;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.protocol.TermIndex;

public final class SCMHAManagerStub
implements SCMHAManager {
    private final SCMRatisServer ratisServer = new RatisServerStub();
    private boolean isLeader;
    private final DBTransactionBuffer transactionBuffer;

    public static SCMHAManager getInstance(boolean isLeader) {
        return new SCMHAManagerStub(isLeader);
    }

    public static SCMHAManager getInstance(boolean isLeader, DBTransactionBuffer buffer) {
        return new SCMHAManagerStub(isLeader, buffer);
    }

    public static SCMHAManager getInstance(boolean isLeader, DBStore dbStore) {
        return new SCMHAManagerStub(isLeader, new SCMHADBTransactionBufferStub(dbStore));
    }

    private SCMHAManagerStub(boolean isLeader) {
        this(isLeader, new SCMHADBTransactionBufferStub());
    }

    private SCMHAManagerStub(boolean isLeader, DBTransactionBuffer buffer) {
        this.isLeader = isLeader;
        this.transactionBuffer = buffer;
    }

    @Override
    public void start() throws IOException {
        this.ratisServer.start();
    }

    @Override
    public void stop() throws IOException {
        this.ratisServer.stop();
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.transactionBuffer});
    }

    boolean isLeader() {
        return this.isLeader;
    }

    public void setIsLeader(boolean isLeader) {
        this.isLeader = isLeader;
    }

    @Override
    public SCMRatisServer getRatisServer() {
        return this.ratisServer;
    }

    @Override
    public DBTransactionBuffer getDBTransactionBuffer() {
        return this.transactionBuffer;
    }

    @Override
    public SCMHADBTransactionBuffer asSCMHADBTransactionBuffer() {
        Preconditions.checkArgument((boolean)(this.transactionBuffer instanceof SCMHADBTransactionBuffer));
        return (SCMHADBTransactionBuffer)this.transactionBuffer;
    }

    @Override
    public SCMSnapshotProvider getSCMSnapshotProvider() {
        return null;
    }

    @Override
    public boolean addSCM(AddSCMRequest request) throws IOException {
        return false;
    }

    @Override
    public boolean removeSCM(RemoveSCMRequest request) throws IOException {
        return false;
    }

    @Override
    public DBCheckpoint downloadCheckpointFromLeader(String leaderId) {
        return null;
    }

    @Override
    public List<ManagedSecretKey> getSecretKeysFromLeader(String leaderID) {
        return null;
    }

    @Override
    public TermIndex verifyCheckpointFromLeader(String leaderId, DBCheckpoint checkpoint) {
        return null;
    }

    @Override
    public TermIndex installCheckpoint(DBCheckpoint dbCheckpoint) {
        return null;
    }

    private class RatisServerStub
    implements SCMRatisServer {
        private Map<SCMRatisProtocol.RequestType, Object> handlers = new EnumMap<SCMRatisProtocol.RequestType, Object>(SCMRatisProtocol.RequestType.class);

        private RatisServerStub() {
        }

        @Override
        public void start() {
        }

        @Override
        public void registerStateMachineHandler(SCMRatisProtocol.RequestType handlerType, Object handler) {
            this.handlers.put(handlerType, handler);
        }

        @Override
        public SCMRatisResponse submitRequest(SCMRatisRequest request) throws IOException {
            RaftClientReply reply;
            RaftGroupMemberId raftId = RaftGroupMemberId.valueOf((RaftPeerId)RaftPeerId.valueOf((String)"peer"), (RaftGroupId)RaftGroupId.randomId());
            if (SCMHAManagerStub.this.isLeader()) {
                try {
                    Message result = this.process(request);
                    reply = RaftClientReply.newBuilder().setClientId(ClientId.randomId()).setServerId(raftId).setGroupId(RaftGroupId.emptyGroupId()).setCallId(1L).setSuccess(true).setMessage(result).setException(null).setLogIndex(1L).build();
                }
                catch (Exception ex) {
                    reply = RaftClientReply.newBuilder().setClientId(ClientId.randomId()).setServerId(raftId).setGroupId(RaftGroupId.emptyGroupId()).setCallId(1L).setSuccess(false).setMessage(Message.EMPTY).setException((RaftException)new StateMachineException(raftId, (Throwable)ex)).setLogIndex(1L).build();
                }
            } else {
                reply = RaftClientReply.newBuilder().setClientId(ClientId.randomId()).setServerId(raftId).setGroupId(RaftGroupId.emptyGroupId()).setCallId(1L).setSuccess(false).setMessage(Message.EMPTY).setException((RaftException)this.triggerNotLeaderException()).setLogIndex(1L).build();
            }
            return SCMRatisResponse.decode(reply);
        }

        @Override
        public boolean triggerSnapshot() throws IOException {
            throw new IOException("submitSnapshotRequest is called.");
        }

        private Message process(SCMRatisRequest request) throws Exception {
            try {
                Object handler = this.handlers.get(request.getType());
                if (handler == null) {
                    throw new IOException("No handler found for request type " + request.getType());
                }
                Object result = handler.getClass().getMethod(request.getOperation(), request.getParameterTypes()).invoke(handler, request.getArguments());
                return SCMRatisResponse.encode(result);
            }
            catch (NoSuchMethodException | SecurityException ex) {
                throw new InvalidProtocolBufferException(ex.getMessage());
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                throw target instanceof Exception ? (Exception)target : e;
            }
        }

        @Override
        public void stop() {
        }

        @Override
        public boolean isStopped() {
            return false;
        }

        @Override
        public RaftServer.Division getDivision() {
            return null;
        }

        @Override
        public List<String> getRatisRoles() {
            return Arrays.asList("180.3.14.5:9894", "180.3.14.21:9894", "180.3.14.145:9894");
        }

        @Override
        public NotLeaderException triggerNotLeaderException() {
            return new NotLeaderException(RaftGroupMemberId.valueOf((RaftPeerId)RaftPeerId.valueOf((String)"peer"), (RaftGroupId)RaftGroupId.randomId()), null, new ArrayList());
        }

        @Override
        public SCMStateMachine getSCMStateMachine() {
            return null;
        }

        @Override
        public boolean addSCM(AddSCMRequest request) throws IOException {
            return false;
        }

        @Override
        public boolean removeSCM(RemoveSCMRequest request) throws IOException {
            return false;
        }

        @Override
        public GrpcTlsConfig getGrpcTlsConfig() {
            return null;
        }
    }
}

