/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication.health;

import java.util.Set;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ReplicationManagerReport;
import org.apache.hadoop.hdds.scm.container.replication.ContainerCheckRequest;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.container.replication.health.AbstractCheck;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmptyContainerHandler
extends AbstractCheck {
    public static final Logger LOG = LoggerFactory.getLogger(EmptyContainerHandler.class);
    private final ReplicationManager replicationManager;

    public EmptyContainerHandler(ReplicationManager replicationManager) {
        this.replicationManager = replicationManager;
    }

    @Override
    public boolean handle(ContainerCheckRequest request) {
        Set<ContainerReplica> replicas;
        ContainerInfo containerInfo = request.getContainerInfo();
        if (this.isContainerEmptyAndClosed(containerInfo, replicas = request.getContainerReplicas())) {
            request.getReport().incrementAndSample(ReplicationManagerReport.HealthState.EMPTY, containerInfo.containerID());
            if (!request.isReadOnly()) {
                LOG.debug("Container {} is empty and closed, marking as DELETING", (Object)containerInfo);
                this.deleteContainerReplicas(containerInfo, replicas);
                this.replicationManager.updateContainerState(containerInfo.containerID(), HddsProtos.LifeCycleEvent.DELETE);
            }
            return true;
        }
        if (containerInfo.getState() == HddsProtos.LifeCycleState.CLOSED && containerInfo.getNumberOfKeys() == 0L && replicas.isEmpty()) {
            request.getReport().incrementAndSample(ReplicationManagerReport.HealthState.EMPTY, containerInfo.containerID());
            LOG.debug("Container {} appears empty and is closed, but cannot be deleted because it has no replicas. Marking as EMPTY.", (Object)containerInfo);
            return true;
        }
        return false;
    }

    private boolean isContainerEmptyAndClosed(ContainerInfo container, Set<ContainerReplica> replicas) {
        return container.getState() == HddsProtos.LifeCycleState.CLOSED && !replicas.isEmpty() && replicas.stream().allMatch(r -> r.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED && r.isEmpty());
    }

    private void deleteContainerReplicas(ContainerInfo containerInfo, Set<ContainerReplica> replicas) {
        Preconditions.assertSame((Object)HddsProtos.LifeCycleState.CLOSED, (Object)containerInfo.getState(), (String)"container state");
        for (ContainerReplica rp : replicas) {
            Preconditions.assertSame((Object)StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED, (Object)rp.getState(), (String)"replica state");
            Preconditions.assertSame((Object)true, (Object)rp.isEmpty(), (String)"replica empty");
            try {
                this.replicationManager.sendDeleteCommand(containerInfo, rp.getReplicaIndex(), rp.getDatanodeDetails(), false);
            }
            catch (NotLeaderException e) {
                LOG.warn("Failed to delete empty replica with index {} for container {} on datanode {}", new Object[]{rp.getReplicaIndex(), containerInfo.containerID(), rp.getDatanodeDetails().getUuidString(), e});
            }
        }
    }
}

