/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.checksum;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.List;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.ozone.client.checksum.AbstractBlockChecksumComputer;
import org.apache.hadoop.ozone.client.checksum.CrcComposer;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.util.DataChecksum;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECBlockChecksumComputer
extends AbstractBlockChecksumComputer {
    private static final Logger LOG = LoggerFactory.getLogger(ECBlockChecksumComputer.class);
    private final List<ContainerProtos.ChunkInfo> chunkInfoList;
    private final OmKeyInfo keyInfo;
    private final long blockLength;

    public ECBlockChecksumComputer(List<ContainerProtos.ChunkInfo> chunkInfoList, OmKeyInfo keyInfo, long blockLength) {
        this.chunkInfoList = chunkInfoList;
        this.keyInfo = keyInfo;
        this.blockLength = blockLength;
    }

    @Override
    public void compute(OzoneClientConfig.ChecksumCombineMode combineMode) throws IOException {
        switch (combineMode) {
            case MD5MD5CRC: {
                this.computeMd5Crc();
                return;
            }
            case COMPOSITE_CRC: {
                this.computeCompositeCrc();
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported combine mode");
    }

    private void computeMd5Crc() {
        Preconditions.checkArgument((this.chunkInfoList.size() > 0 ? 1 : 0) != 0);
        MessageDigest digester = MD5Hash.getDigester();
        for (ContainerProtos.ChunkInfo chunkInfo : this.chunkInfoList) {
            long chunkSize = chunkInfo.getLen();
            long bytesPerCrc = chunkInfo.getChecksumData().getBytesPerChecksum();
            int parityBytes = this.getParityBytes(chunkSize, bytesPerCrc);
            ByteString stripeChecksum = chunkInfo.getStripeChecksum();
            Preconditions.checkNotNull((Object)stripeChecksum);
            int checksumSize = stripeChecksum.size();
            Preconditions.checkArgument((checksumSize % 4 == 0 ? 1 : 0) != 0, (Object)"Checksum Bytes size does not match");
            ByteBuffer byteWrap = stripeChecksum.asReadOnlyByteBuffer();
            byteWrap.limit(checksumSize - parityBytes);
            digester.update(byteWrap);
        }
        byte[] fileMD5 = digester.digest();
        this.setOutBytes(digester.digest());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Number of chunks={}, md5hash={}", (Object)this.chunkInfoList.size(), (Object)StringUtils.bytes2HexString((byte[])fileMD5));
        }
    }

    private void computeCompositeCrc() throws IOException {
        DataChecksum.Type dataChecksumType;
        Preconditions.checkArgument((this.chunkInfoList.size() > 0 ? 1 : 0) != 0);
        ContainerProtos.ChunkInfo firstChunkInfo = this.chunkInfoList.get(0);
        switch (firstChunkInfo.getChecksumData().getType()) {
            case CRC32C: {
                dataChecksumType = DataChecksum.Type.CRC32C;
                break;
            }
            case CRC32: {
                dataChecksumType = DataChecksum.Type.CRC32;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported checksum type: " + firstChunkInfo.getChecksumData().getType());
            }
        }
        long bytesPerCrc = firstChunkInfo.getChecksumData().getBytesPerChecksum();
        long blockSize = this.blockLength;
        CrcComposer blockCrcComposer = CrcComposer.newCrcComposer((DataChecksum.Type)dataChecksumType, (long)bytesPerCrc);
        for (ContainerProtos.ChunkInfo chunkInfo : this.chunkInfoList) {
            ByteString stripeChecksum = chunkInfo.getStripeChecksum();
            long chunkSize = chunkInfo.getLen();
            int parityBytes = this.getParityBytes(chunkSize, bytesPerCrc);
            Preconditions.checkNotNull((Object)stripeChecksum);
            int checksumSize = stripeChecksum.size();
            Preconditions.checkArgument((checksumSize % 4 == 0 ? 1 : 0) != 0, (Object)"Checksum Bytes size does not match");
            ByteBuffer byteWrap = stripeChecksum.asReadOnlyByteBuffer();
            byteWrap.limit(checksumSize - parityBytes);
            while (byteWrap.hasRemaining()) {
                for (long remainingChunkSize = Math.min(blockSize, chunkSize); byteWrap.hasRemaining() && remainingChunkSize > 0L; remainingChunkSize -= bytesPerCrc) {
                    int checksumData = byteWrap.getInt();
                    blockCrcComposer.update(checksumData, Math.min(bytesPerCrc, remainingChunkSize));
                }
                blockSize -= chunkSize;
            }
        }
        byte[] compositeCrcChunkChecksum = blockCrcComposer.digest();
        this.setOutBytes(compositeCrcChunkChecksum);
        LOG.debug("Number of chunks = {}, chunk checksum type is {}, composite checksum = {}", new Object[]{this.chunkInfoList.size(), dataChecksumType, compositeCrcChunkChecksum});
    }

    private int getParityBytes(long chunkSize, long bytesPerCrc) {
        ECReplicationConfig replicationConfig = (ECReplicationConfig)this.keyInfo.getReplicationConfig();
        int numParity = replicationConfig.getParity();
        int parityBytes = (int)(Math.ceil((double)chunkSize / (double)bytesPerCrc) * 4.0 * (double)numParity);
        return parityBytes;
    }
}

