/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.ozone.OzoneAcl;

public final class VolumeArgs {
    private final String admin;
    private final String owner;
    private final long quotaInBytes;
    private final long quotaInNamespace;
    private final List<OzoneAcl> acls;
    private Map<String, String> metadata;

    private VolumeArgs(String admin, String owner, long quotaInBytes, long quotaInNamespace, List<OzoneAcl> acls, Map<String, String> metadata) {
        this.admin = admin;
        this.owner = owner;
        this.quotaInBytes = quotaInBytes;
        this.quotaInNamespace = quotaInNamespace;
        this.acls = acls;
        this.metadata = metadata;
    }

    public String getAdmin() {
        return this.admin;
    }

    public String getOwner() {
        return this.owner;
    }

    public long getQuotaInBytes() {
        return this.quotaInBytes;
    }

    public long getQuotaInNamespace() {
        return this.quotaInNamespace;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public List<OzoneAcl> getAcls() {
        return this.acls;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String adminName;
        private String ownerName;
        private long quotaInBytes = -1L;
        private long quotaInNamespace = -1L;
        private List<OzoneAcl> listOfAcls;
        private Map<String, String> metadata = new HashMap<String, String>();

        public Builder setAdmin(String admin) {
            this.adminName = admin;
            return this;
        }

        public Builder setOwner(String owner) {
            this.ownerName = owner;
            return this;
        }

        public Builder setQuotaInBytes(long quota) {
            this.quotaInBytes = quota;
            return this;
        }

        public Builder setQuotaInNamespace(long quota) {
            this.quotaInNamespace = quota;
            return this;
        }

        public Builder addMetadata(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder setAcls(List<OzoneAcl> acls) throws IOException {
            this.listOfAcls = acls;
            return this;
        }

        public VolumeArgs build() {
            return new VolumeArgs(this.adminName, this.ownerName, this.quotaInBytes, this.quotaInNamespace, this.listOfAcls, this.metadata);
        }
    }
}

