/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.AccessController;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.Container;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.config.Description;
import org.jboss.weld.config.WeldConfiguration;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.probe.Components;
import org.jboss.weld.probe.HtmlTag;
import org.jboss.weld.probe.IOUtils;
import org.jboss.weld.probe.JsonObjects;
import org.jboss.weld.probe.Probe;
import org.jboss.weld.probe.ProbeLogger;
import org.jboss.weld.probe.Strings;
import org.jboss.weld.security.GetSystemPropertyAction;
import org.jboss.weld.util.reflection.Formats;

class Reports {
    private static final String VALIDATION_REPORT_FILE_NAME = "weld-validation-report.html";
    private static final String TITLE = "Weld - Validation Report";
    private static final String TITLE_EXCEPTION = "Validation Issue";
    private static final String TITLE_BDAS = "Deployment - Bean Archives";
    private static final String TITLE_DEPS = "Dependency Issues";
    private static final String TITLE_CONFIG = "Weld Configuration - Modified Values";
    private static final String TITLE_BEANS = "Enabled Beans";
    private static final String EXCEPTION = "exception";
    private static final String BDAS = "bdas";
    private static final String DEPS = "deps";
    private static final String CONFIG = "config";
    private static final String BEANS = "beans";

    private Reports() {
    }

    static void generateValidationReport(Probe probe, Exception exception, Environment environment, BeanManagerImpl manager) {
        HtmlTag html = HtmlTag.html();
        HtmlTag head = HtmlTag.head().appendTo(html);
        head.add(HtmlTag.title(TITLE));
        head.add(HtmlTag.style().add(HtmlTag.SafeString.of(IOUtils.getResourceAsString("/report.css"))));
        HtmlTag body = HtmlTag.body().appendTo(html);
        body.add(HtmlTag.h1(TITLE));
        HtmlTag meta = HtmlTag.stripedTable().appendTo(body);
        meta.add(HtmlTag.tr().add(HtmlTag.td().add(HtmlTag.strong("Generated at:")), HtmlTag.td(LocalDateTime.now().toString())));
        meta.add(HtmlTag.tr().add(HtmlTag.td().add(HtmlTag.strong("Weld Version:")), HtmlTag.td(Formats.getSimpleVersion())));
        meta.add(HtmlTag.tr().add(HtmlTag.td().add(HtmlTag.strong("Weld Environment:")), HtmlTag.td(environment.toString())));
        meta.add(HtmlTag.tr().add(HtmlTag.td().add(HtmlTag.strong("Java Version:")), HtmlTag.td(AccessController.doPrivileged(new GetSystemPropertyAction("java.version")))));
        meta.add(HtmlTag.tr().add(HtmlTag.td().add(HtmlTag.strong("Java Vendor:")), HtmlTag.td(AccessController.doPrivileged(new GetSystemPropertyAction("java.vendor")))));
        meta.add(HtmlTag.tr().add(HtmlTag.td().add(HtmlTag.strong("Operating System:")), HtmlTag.td(AccessController.doPrivileged(new GetSystemPropertyAction("os.name")))));
        HtmlTag contents = HtmlTag.ol().appendTo(body);
        contents.add(HtmlTag.li().add(HtmlTag.a("#exception").add(TITLE_EXCEPTION)));
        contents.add(HtmlTag.li().add(HtmlTag.a("#bdas").add(TITLE_BDAS)));
        contents.add(HtmlTag.li().add(HtmlTag.a("#deps").add(TITLE_DEPS)));
        contents.add(HtmlTag.li().add(HtmlTag.a("#beans").add(TITLE_BEANS)));
        contents.add(HtmlTag.li().add(HtmlTag.a("#config").add(TITLE_CONFIG)));
        body.add(HtmlTag.aname(EXCEPTION));
        body.add(HtmlTag.h2(TITLE_EXCEPTION));
        body.add(HtmlTag.p(exception.getMessage()).attr("style", "font-size: large;color: red;font-weight:bold;"));
        body.add(HtmlTag.h(3, "Exception Stack:"));
        StringWriter stackWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stackWriter));
        body.add(HtmlTag.div(EXCEPTION).add(HtmlTag.pre(stackWriter.toString())));
        Map<BeanDeploymentArchive, BeanManagerImpl> beanDeploymentArchivesMap = Container.instance(manager).beanDeploymentArchives();
        ArrayList<BeanDeploymentArchive> bdas = new ArrayList<BeanDeploymentArchive>(beanDeploymentArchivesMap.keySet());
        Collections.sort(bdas, probe.getBdaComparator());
        Reports.addBeanArchives(body, bdas);
        Reports.addInvalidDependencies(probe, body);
        Reports.addBeans(probe, body, bdas);
        Reports.addConfiguration(body, manager);
        String export = manager.getServices().get(WeldConfiguration.class).getStringProperty(ConfigurationKey.PROBE_EXPORT_DATA_AFTER_DEPLOYMENT);
        File exportPath = !export.isEmpty() ? new File(export) : new File(System.getProperty("user.dir"));
        if (!exportPath.canWrite()) {
            ProbeLogger.LOG.invalidExportPath(exportPath);
            return;
        }
        try {
            File exportFile = new File(exportPath, VALIDATION_REPORT_FILE_NAME);
            Files.write(exportFile.toPath(), html.toString().getBytes(Charset.forName("UTF-8")), new OpenOption[0]);
            ProbeLogger.LOG.validationReportExported("file://" + exportFile.getAbsolutePath());
        }
        catch (IOException e) {
            ProbeLogger.LOG.unableToExportData(exportPath, e.getCause() != null ? e.getCause() : e);
            ProbeLogger.LOG.catchingTrace(e);
        }
    }

    private static void addInvalidDependencies(Probe probe, HtmlTag body) {
        body.add(HtmlTag.aname(DEPS));
        body.add(HtmlTag.h2(TITLE_DEPS));
        HtmlTag table = HtmlTag.stripedTable().appendTo(HtmlTag.div(DEPS).appendTo(body));
        HtmlTag.tr().add(HtmlTag.th(""), HtmlTag.th("Declaring Bean"), HtmlTag.th("Problem")).appendTo(table);
        int idx = 0;
        for (Bean<?> bean : probe.getBeans()) {
            Set<InjectionPoint> injectionPoints;
            BeanManagerImpl beanManager = probe.getBeanManager(bean);
            if (beanManager == null || (injectionPoints = bean.getInjectionPoints()) == null || injectionPoints.isEmpty()) continue;
            for (InjectionPoint injectionPoint : injectionPoints) {
                Set beans;
                if (injectionPoint.isDelegate() || !(beans = beanManager.getBeans(injectionPoint.getType(), injectionPoint.getQualifiers().toArray(new Annotation[injectionPoint.getQualifiers().size()]))).isEmpty()) continue;
                HtmlTag.tr().add(HtmlTag.td(++idx + "."), HtmlTag.td(bean.toString()).add(HtmlTag.td("Unsatisfied dependency at " + injectionPoint))).appendTo(table);
                try {
                    beanManager.resolve(beans);
                }
                catch (AmbiguousResolutionException e) {
                    HtmlTag.tr().add(HtmlTag.td(++idx + "."), HtmlTag.td(bean.toString()).add(HtmlTag.td("Ambiguous dependency at " + injectionPoint))).appendTo(table);
                }
            }
        }
    }

    private static void addBeanArchives(HtmlTag body, List<BeanDeploymentArchive> bdas) {
        body.add(HtmlTag.aname(BDAS));
        body.add(HtmlTag.h2(TITLE_BDAS));
        HtmlTag table = HtmlTag.stripedTable().appendTo(HtmlTag.div(BDAS).appendTo(body));
        HtmlTag.tr().add(HtmlTag.th(""), HtmlTag.th("Identifier"), HtmlTag.th("Bean Discovery Mode"), HtmlTag.th("beans.xml")).appendTo(table);
        int idx = 0;
        for (BeanDeploymentArchive bda : bdas) {
            HtmlTag tr = HtmlTag.tr().add(HtmlTag.td(++idx + "."), HtmlTag.td(bda.getId())).appendTo(table);
            BeansXml beansXml = bda.getBeansXml();
            tr.add(HtmlTag.td(beansXml != null ? beansXml.getBeanDiscoveryMode().toString() : BeanDiscoveryMode.ANNOTATED.toString()));
            if (beansXml != null && !beansXml.equals(BeansXml.EMPTY_BEANS_XML)) {
                HtmlTag.div().attr("title", beansXml.getUrl() != null ? beansXml.getUrl().toString() : "URL not available").add(beansXml.getVersion() != null ? beansXml.getVersion() : "Version not defined").appendTo(HtmlTag.td().appendTo(tr));
                continue;
            }
            tr.add(HtmlTag.td("No beans.xml"));
        }
    }

    private static void addConfiguration(HtmlTag body, BeanManagerImpl manager) {
        body.add(HtmlTag.aname(CONFIG));
        body.add(HtmlTag.h2(TITLE_CONFIG));
        HtmlTag table = HtmlTag.stripedTable().appendTo(HtmlTag.div(CONFIG).appendTo(body));
        HtmlTag.tr().add(HtmlTag.th(""), HtmlTag.th("Key"), HtmlTag.th("Default Value"), HtmlTag.th("Value"), HtmlTag.th("Description")).appendTo(table);
        int idx = 0;
        WeldConfiguration configuration = manager.getServices().get(WeldConfiguration.class);
        for (ConfigurationKey key : Reports.getSortedConfigurationKeys()) {
            Object defaultValue = key.getDefaultValue();
            Object value = Reports.getValue(key, configuration);
            if (value == null || defaultValue.equals(value)) continue;
            String desc = Reports.getDesc(key);
            table.add(HtmlTag.tr().add(HtmlTag.td(++idx + "."), HtmlTag.td(key.get()), HtmlTag.td(defaultValue.toString()), HtmlTag.td(value.toString()), HtmlTag.td().add(desc != null ? HtmlTag.SafeString.of(desc) : "")));
        }
    }

    private static void addBeans(Probe probe, HtmlTag body, List<BeanDeploymentArchive> bdas) {
        body.add(HtmlTag.aname(BEANS));
        body.add(HtmlTag.h2(TITLE_BEANS));
        HtmlTag table = HtmlTag.stripedTable().appendTo(HtmlTag.div(BEANS).appendTo(body));
        HtmlTag.tr().add(HtmlTag.th(""), HtmlTag.th("Archive"), HtmlTag.th("Kind"), HtmlTag.th("Bean Class"), HtmlTag.th("Types"), HtmlTag.th("Qualifiers"), HtmlTag.th("Scope")).appendTo(table);
        int idx = 0;
        List<Bean<?>> beans = probe.getBeans();
        for (int i = 0; i < bdas.size(); ++i) {
            String bdaId = bdas.get(i).getId();
            for (Bean<?> bean : beans) {
                BeanManagerImpl beanManager = probe.getBeanManager(bean);
                if (beanManager == null || !bdaId.equals(beanManager.getId())) continue;
                HtmlTag types = HtmlTag.td();
                Iterator<Type> iterator = JsonObjects.sortTypes(bean.getTypes()).iterator();
                while (iterator.hasNext()) {
                    Type type = iterator.next();
                    String formatted = Strings.escape(Formats.formatType(type, false));
                    if (Object.class.equals((Object)type)) continue;
                    types.add(HtmlTag.div().attr("title", formatted).add(Reports.abbreviateType(formatted)));
                    if (!iterator.hasNext()) continue;
                    types.add(HtmlTag.BR);
                }
                HtmlTag qualifiers = HtmlTag.td();
                if (bean.getQualifiers() != null && !bean.getQualifiers().isEmpty()) {
                    Iterator<Annotation> iterator2 = bean.getQualifiers().iterator();
                    while (iterator2.hasNext()) {
                        Annotation qualifier = iterator2.next();
                        if (Any.class.equals(qualifier.annotationType())) continue;
                        if (Default.class.equals(qualifier.annotationType())) {
                            qualifiers.add(JsonObjects.simplifiedAnnotation(qualifier));
                        } else {
                            qualifiers.add(HtmlTag.div().attr("title", qualifier.toString()).add(Reports.abbreviateAnnotation(qualifier.toString())));
                        }
                        if (!iterator2.hasNext()) continue;
                        qualifiers.add(HtmlTag.BR);
                    }
                }
                String beanClass = Formats.formatType(bean.getBeanClass(), false);
                HtmlTag.tr().add(HtmlTag.td(++idx + "."), HtmlTag.td().add(HtmlTag.a("#bdas").add(" " + (i + 1))), HtmlTag.td(Components.BeanKind.from(bean).toString()), HtmlTag.td().add(HtmlTag.div().attr("title", beanClass).add(Reports.abbreviateType(beanClass))), types, qualifiers, HtmlTag.td(JsonObjects.simplifiedScope(bean.getScope()))).appendTo(table);
            }
        }
    }

    static List<ConfigurationKey> getSortedConfigurationKeys() {
        ArrayList<ConfigurationKey> configurationKeys = new ArrayList<ConfigurationKey>();
        Collections.addAll(configurationKeys, ConfigurationKey.values());
        Collections.sort(configurationKeys, new Comparator<ConfigurationKey>(){

            @Override
            public int compare(ConfigurationKey o1, ConfigurationKey o2) {
                return o1.get().compareTo(o2.get());
            }
        });
        return configurationKeys;
    }

    static Object getValue(ConfigurationKey key, WeldConfiguration configuration) {
        Object defaultValue = key.getDefaultValue();
        Object value = null;
        if (defaultValue instanceof Boolean) {
            value = configuration.getBooleanProperty(key);
        } else if (defaultValue instanceof Long) {
            value = configuration.getLongProperty(key);
        } else if (defaultValue instanceof Integer) {
            value = configuration.getIntegerProperty(key);
        } else if (defaultValue instanceof String) {
            value = configuration.getStringProperty(key);
        }
        return value;
    }

    static String getDesc(ConfigurationKey key) {
        try {
            Field field = ConfigurationKey.class.getDeclaredField(key.toString());
            if (field != null && field.isEnumConstant()) {
                Description description = field.getAnnotation(Description.class);
                if (description == null) {
                    return null;
                }
                return description.value();
            }
        }
        catch (NoSuchFieldException | NullPointerException | SecurityException exception) {
            // empty catch block
        }
        return null;
    }

    private static String abbreviateType(String type) {
        StringBuilder builder = new StringBuilder();
        String[] parts = type.split("\\.");
        for (int i = 0; i < parts.length; ++i) {
            if (i == parts.length - 1) {
                builder.append(parts[i]);
                continue;
            }
            builder.append(parts[i].charAt(0));
            builder.append(".");
        }
        return builder.toString();
    }

    private static String abbreviateAnnotation(String annotation) {
        annotation = annotation.indexOf(40) != -1 ? annotation.substring(1, annotation.indexOf(40)) : annotation.substring(1);
        return "@" + Reports.abbreviateType(annotation);
    }
}

