/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.StorageSize;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.fs.CachingSpaceUsageSource;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckParams;
import org.apache.hadoop.hdds.fs.SpaceUsageSource;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolumeUsage {
    private final CachingSpaceUsageSource source;
    private boolean shutdownComplete;
    private final long reservedInBytes;
    private static final Logger LOG = LoggerFactory.getLogger(VolumeUsage.class);

    VolumeUsage(SpaceUsageCheckParams checkParams, ConfigurationSource conf) {
        this.source = new CachingSpaceUsageSource(checkParams);
        this.reservedInBytes = VolumeUsage.getReserved(conf, checkParams.getPath(), this.source.getCapacity());
        Preconditions.assertTrue((this.reservedInBytes >= 0L ? 1 : 0) != 0, (Object)(this.reservedInBytes + " < 0"));
        this.start();
    }

    @VisibleForTesting
    SpaceUsageSource realUsage() {
        return this.source.snapshot();
    }

    public long getCapacity() {
        return this.getCurrentUsage().getCapacity();
    }

    public long getAvailable() {
        return this.getCurrentUsage().getAvailable();
    }

    public long getUsedSpace() {
        return this.getCurrentUsage().getUsedSpace();
    }

    public SpaceUsageSource getCurrentUsage() {
        SpaceUsageSource real = this.realUsage();
        return this.reservedInBytes == 0L ? real : new SpaceUsageSource.Fixed(Math.max(real.getCapacity() - this.reservedInBytes, 0L), Math.max(real.getAvailable() - this.getRemainingReserved(real), 0L), real.getUsedSpace());
    }

    public void incrementUsedSpace(long usedSpace) {
        this.source.incrementUsedSpace(usedSpace);
    }

    public void decrementUsedSpace(long reclaimedSpace) {
        this.source.decrementUsedSpace(reclaimedSpace);
    }

    private static long getOtherUsed(SpaceUsageSource precomputedVolumeSpace) {
        long totalUsed = precomputedVolumeSpace.getCapacity() - precomputedVolumeSpace.getAvailable();
        return Math.max(totalUsed - precomputedVolumeSpace.getUsedSpace(), 0L);
    }

    private long getRemainingReserved(SpaceUsageSource precomputedVolumeSpace) {
        return Math.max(this.reservedInBytes - VolumeUsage.getOtherUsed(precomputedVolumeSpace), 0L);
    }

    public synchronized void start() {
        this.source.start();
    }

    public synchronized void shutdown() {
        if (!this.shutdownComplete) {
            this.source.shutdown();
            this.shutdownComplete = true;
        }
    }

    public void refreshNow() {
        this.source.refreshNow();
    }

    public long getReservedBytes() {
        return this.reservedInBytes;
    }

    public static long getMinVolumeFreeSpace(ConfigurationSource conf, long capacity) {
        if (conf.isConfigured("hdds.datanode.volume.min.free.space") && conf.isConfigured("hdds.datanode.volume.min.free.space.percent")) {
            LOG.error("Both {} and {} are set. Set either one, not both. If both are set,it will use default value which is {} as min free space", new Object[]{"hdds.datanode.volume.min.free.space", "hdds.datanode.volume.min.free.space.percent", "5GB"});
        }
        if (conf.isConfigured("hdds.datanode.volume.min.free.space")) {
            return (long)conf.getStorageSize("hdds.datanode.volume.min.free.space", "5GB", StorageUnit.BYTES);
        }
        if (conf.isConfigured("hdds.datanode.volume.min.free.space.percent")) {
            float volumeMinFreeSpacePercent = Float.parseFloat(conf.get("hdds.datanode.volume.min.free.space.percent"));
            return (long)((float)capacity * volumeMinFreeSpacePercent);
        }
        return (long)conf.getStorageSize("hdds.datanode.volume.min.free.space", "5GB", StorageUnit.BYTES);
    }

    public static boolean hasVolumeEnoughSpace(long volumeAvailableSpace, long volumeCommittedBytesCount, long requiredSpace, long volumeFreeSpaceToSpare) {
        return volumeAvailableSpace - volumeCommittedBytesCount > Math.max(requiredSpace, volumeFreeSpaceToSpare);
    }

    private static long getReserved(ConfigurationSource conf, String rootDir, long capacity) {
        if (conf.isConfigured("hdds.datanode.dir.du.reserved.percent") && conf.isConfigured("hdds.datanode.dir.du.reserved")) {
            LOG.error("Both {} and {} are set. Set either one, not both. If the volume matches with volume parameter in former config, it is set as reserved space. If not it fall backs to the latter config.", (Object)"hdds.datanode.dir.du.reserved", (Object)"hdds.datanode.dir.du.reserved.percent");
        }
        Collection reserveList = conf.getTrimmedStringCollection("hdds.datanode.dir.du.reserved");
        for (String reserve : reserveList) {
            String[] words = reserve.split(":");
            if (words.length < 2) {
                LOG.error("Reserved space should be configured in a pair, but current value is {}", (Object)reserve);
                continue;
            }
            try {
                String path = new File(words[0]).getCanonicalPath();
                if (!path.equals(rootDir)) continue;
                StorageSize size = StorageSize.parse((String)words[1].trim());
                return (long)size.getUnit().toBytes(size.getValue());
            }
            catch (IllegalArgumentException e) {
                LOG.error("Failed to parse StorageSize {} from config {}", new Object[]{words[1].trim(), "hdds.datanode.dir.du.reserved", e});
            }
            catch (IOException e) {
                LOG.error("Failed to read storage path {} from config {}", new Object[]{words[1].trim(), "hdds.datanode.dir.du.reserved", e});
            }
        }
        float percentage = conf.getFloat("hdds.datanode.dir.du.reserved.percent", 1.0E-4f);
        if (percentage < 0.0f || percentage > 1.0f) {
            LOG.error("The value of {} should be between 0 to 1. Falling back to default value {}", (Object)"hdds.datanode.dir.du.reserved.percent", (Object)Float.valueOf(1.0E-4f));
            percentage = 1.0E-4f;
        }
        return (long)Math.ceil((float)capacity * percentage);
    }
}

