/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.transport.server.ratis;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.ratis.protocol.RaftGroupId;

@InterfaceAudience.Private
@Metrics(about="Container State Machine Metrics", context="dfs")
public class CSMMetrics {
    public static final String SOURCE_NAME = CSMMetrics.class.getSimpleName();
    @Metric
    private MutableCounterLong numWriteStateMachineOps;
    @Metric
    private MutableCounterLong numQueryStateMachineOps;
    @Metric
    private MutableCounterLong numApplyTransactionOps;
    @Metric
    private MutableCounterLong numReadStateMachineOps;
    @Metric
    private MutableCounterLong numBytesWrittenCount;
    @Metric
    private MutableCounterLong numBytesCommittedCount;
    @Metric
    private MutableRate transactionLatencyMs;
    private MutableRate[] opsLatencyMs;
    private MetricsRegistry registry = null;
    @Metric
    private MutableCounterLong numWriteStateMachineFails;
    @Metric
    private MutableCounterLong numWriteDataFails;
    @Metric
    private MutableCounterLong numQueryStateMachineFails;
    @Metric
    private MutableCounterLong numApplyTransactionFails;
    @Metric
    private MutableCounterLong numReadStateMachineFails;
    @Metric
    private MutableCounterLong numReadStateMachineMissCount;
    @Metric
    private MutableCounterLong numStartTransactionVerifyFailures;
    @Metric
    private MutableCounterLong numContainerNotOpenVerifyFailures;
    @Metric
    private MutableCounterLong numDataCacheMiss;
    @Metric
    private MutableCounterLong numDataCacheHit;
    @Metric
    private MutableCounterLong numEvictedCacheCount;
    @Metric
    private MutableRate applyTransactionNs;
    @Metric
    private MutableRate writeStateMachineDataNs;

    public CSMMetrics() {
        int numCmdTypes = ContainerProtos.Type.values().length;
        this.opsLatencyMs = new MutableRate[numCmdTypes];
        this.registry = new MetricsRegistry(CSMMetrics.class.getSimpleName());
        for (int i = 0; i < numCmdTypes; ++i) {
            this.opsLatencyMs[i] = this.registry.newRate(ContainerProtos.Type.forNumber((int)(i + 1)).toString() + "Ms", ContainerProtos.Type.forNumber((int)(i + 1)) + " op");
        }
    }

    public static CSMMetrics create(RaftGroupId gid) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (CSMMetrics)ms.register(SOURCE_NAME + gid.toString(), "Container State Machine", (Object)new CSMMetrics());
    }

    public void incNumWriteStateMachineOps() {
        this.numWriteStateMachineOps.incr();
    }

    public void incNumQueryStateMachineOps() {
        this.numQueryStateMachineOps.incr();
    }

    public void incNumReadStateMachineOps() {
        this.numReadStateMachineOps.incr();
    }

    public void incNumApplyTransactionsOps() {
        this.numApplyTransactionOps.incr();
    }

    public void incNumWriteStateMachineFails() {
        this.numWriteStateMachineFails.incr();
    }

    public void incNumWriteDataFails() {
        this.numWriteDataFails.incr();
    }

    public void incNumQueryStateMachineFails() {
        this.numQueryStateMachineFails.incr();
    }

    public void incNumBytesWrittenCount(long value) {
        this.numBytesWrittenCount.incr(value);
    }

    public void incNumBytesCommittedCount(long value) {
        this.numBytesCommittedCount.incr(value);
    }

    public void incNumReadStateMachineFails() {
        this.numReadStateMachineFails.incr();
    }

    public void incNumReadStateMachineMissCount() {
        this.numReadStateMachineMissCount.incr();
    }

    public void incNumApplyTransactionsFails() {
        this.numApplyTransactionFails.incr();
    }

    @VisibleForTesting
    public long getNumWriteStateMachineOps() {
        return this.numWriteStateMachineOps.value();
    }

    @VisibleForTesting
    public long getNumQueryStateMachineOps() {
        return this.numQueryStateMachineOps.value();
    }

    @VisibleForTesting
    public long getNumApplyTransactionsOps() {
        return this.numApplyTransactionOps.value();
    }

    @VisibleForTesting
    public long getNumWriteStateMachineFails() {
        return this.numWriteStateMachineFails.value();
    }

    @VisibleForTesting
    public long getNumWriteDataFails() {
        return this.numWriteDataFails.value();
    }

    @VisibleForTesting
    public long getNumQueryStateMachineFails() {
        return this.numQueryStateMachineFails.value();
    }

    @VisibleForTesting
    public long getNumApplyTransactionsFails() {
        return this.numApplyTransactionFails.value();
    }

    @VisibleForTesting
    public long getNumReadStateMachineFails() {
        return this.numReadStateMachineFails.value();
    }

    @VisibleForTesting
    public long getNumReadStateMachineMissCount() {
        return this.numReadStateMachineMissCount.value();
    }

    @VisibleForTesting
    public long getNumReadStateMachineOps() {
        return this.numReadStateMachineOps.value();
    }

    @VisibleForTesting
    public long getNumBytesWrittenCount() {
        return this.numBytesWrittenCount.value();
    }

    @VisibleForTesting
    public long getNumBytesCommittedCount() {
        return this.numBytesCommittedCount.value();
    }

    public MutableRate getApplyTransactionLatencyNs() {
        return this.applyTransactionNs;
    }

    public void incPipelineLatencyMs(ContainerProtos.Type type, long latencyMillis) {
        this.opsLatencyMs[type.ordinal()].add(latencyMillis);
        this.transactionLatencyMs.add(latencyMillis);
    }

    public void incNumStartTransactionVerifyFailures() {
        this.numStartTransactionVerifyFailures.incr();
    }

    public void incNumContainerNotOpenVerifyFailures() {
        this.numContainerNotOpenVerifyFailures.incr();
    }

    public void recordApplyTransactionCompletionNs(long latencyNanos) {
        this.applyTransactionNs.add(latencyNanos);
    }

    public void recordWriteStateMachineCompletionNs(long latencyNanos) {
        this.writeStateMachineDataNs.add(latencyNanos);
    }

    public void incNumDataCacheMiss() {
        this.numDataCacheMiss.incr();
    }

    public void incNumDataCacheHit() {
        this.numDataCacheHit.incr();
    }

    public void incNumEvictedCacheCount() {
        this.numEvictedCacheCount.incr();
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }
}

