/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.states.endpoint;

import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutVersionManager;
import org.apache.hadoop.ozone.container.common.helpers.DeletedContainerBlocksSummary;
import org.apache.hadoop.ozone.container.common.statemachine.EndpointStateMachine;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.upgrade.UpgradeUtils;
import org.apache.hadoop.ozone.protocol.commands.CloseContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.ClosePipelineCommand;
import org.apache.hadoop.ozone.protocol.commands.CreatePipelineCommand;
import org.apache.hadoop.ozone.protocol.commands.DeleteBlocksCommand;
import org.apache.hadoop.ozone.protocol.commands.DeleteContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.FinalizeNewLayoutVersionCommand;
import org.apache.hadoop.ozone.protocol.commands.ReconstructECContainersCommand;
import org.apache.hadoop.ozone.protocol.commands.RefreshVolumeUsageCommand;
import org.apache.hadoop.ozone.protocol.commands.ReplicateContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.ozone.protocol.commands.SetNodeOperationalStateCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatEndpointTask
implements Callable<EndpointStateMachine.EndPointStates> {
    public static final Logger LOG = LoggerFactory.getLogger(HeartbeatEndpointTask.class);
    private final EndpointStateMachine rpcEndpoint;
    private final ConfigurationSource conf;
    private HddsProtos.DatanodeDetailsProto datanodeDetailsProto;
    private StateContext context;
    private int maxContainerActionsPerHB;
    private int maxPipelineActionsPerHB;
    private HDDSLayoutVersionManager layoutVersionManager;

    public HeartbeatEndpointTask(EndpointStateMachine rpcEndpoint, ConfigurationSource conf, StateContext context) {
        this(rpcEndpoint, conf, context, context.getParent().getLayoutVersionManager());
    }

    public HeartbeatEndpointTask(EndpointStateMachine rpcEndpoint, ConfigurationSource conf, StateContext context, HDDSLayoutVersionManager versionManager) {
        this.rpcEndpoint = rpcEndpoint;
        this.conf = conf;
        this.context = context;
        this.maxContainerActionsPerHB = conf.getInt("hdds.container.action.max.limit", 20);
        this.maxPipelineActionsPerHB = conf.getInt("hdds.pipeline.action.max.limit", 20);
        this.layoutVersionManager = versionManager != null ? versionManager : context.getParent().getLayoutVersionManager();
    }

    public HddsProtos.DatanodeDetailsProto getDatanodeDetailsProto() {
        return this.datanodeDetailsProto;
    }

    public void setDatanodeDetailsProto(HddsProtos.DatanodeDetailsProto datanodeDetailsProto) {
        this.datanodeDetailsProto = datanodeDetailsProto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EndpointStateMachine.EndPointStates call() throws Exception {
        this.rpcEndpoint.lock();
        StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.Builder requestBuilder = null;
        try {
            Preconditions.checkState((this.datanodeDetailsProto != null ? 1 : 0) != 0);
            StorageContainerDatanodeProtocolProtos.LayoutVersionProto layoutinfo = UpgradeUtils.toLayoutVersionProto(this.layoutVersionManager.getMetadataLayoutVersion(), this.layoutVersionManager.getSoftwareLayoutVersion());
            requestBuilder = StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.newBuilder().setDatanodeDetails(this.datanodeDetailsProto).setDataNodeLayoutVersion(layoutinfo);
            this.addReports(requestBuilder);
            this.addContainerActions(requestBuilder);
            this.addPipelineActions(requestBuilder);
            this.addQueuedCommandCounts(requestBuilder);
            StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto request = requestBuilder.build();
            LOG.debug("Sending heartbeat message : {}", (Object)request);
            StorageContainerDatanodeProtocolProtos.SCMHeartbeatResponseProto response = this.rpcEndpoint.getEndPoint().sendHeartbeat(request);
            this.processResponse(response, this.datanodeDetailsProto);
            this.rpcEndpoint.setLastSuccessfulHeartbeat(ZonedDateTime.now());
            this.rpcEndpoint.zeroMissedCount();
        }
        catch (IOException ex) {
            Preconditions.checkState((requestBuilder != null ? 1 : 0) != 0);
            this.putBackIncrementalReports(requestBuilder);
            this.rpcEndpoint.logIfNeeded(ex);
        }
        finally {
            this.rpcEndpoint.unlock();
        }
        return this.rpcEndpoint.getState();
    }

    private void putBackIncrementalReports(StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.Builder requestBuilder) {
        LinkedList<Message> reports = new LinkedList<Message>();
        if (requestBuilder.getCommandStatusReportsCount() != 0) {
            reports.addAll(requestBuilder.getCommandStatusReportsList());
        }
        if (requestBuilder.getIncrementalContainerReportCount() != 0) {
            reports.addAll(requestBuilder.getIncrementalContainerReportList());
        }
        this.context.putBackReports(reports, this.rpcEndpoint.getAddress());
    }

    private void addReports(StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.Builder requestBuilder) {
        block0: for (Message report : this.context.getAllAvailableReports(this.rpcEndpoint.getAddress())) {
            String reportName = report.getDescriptorForType().getFullName();
            for (Descriptors.FieldDescriptor descriptor : StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.getDescriptor().getFields()) {
                String heartbeatFieldName = descriptor.getMessageType().getFullName();
                if (!heartbeatFieldName.equals(reportName)) continue;
                if (descriptor.isRepeated()) {
                    requestBuilder.addRepeatedField(descriptor, (Object)report);
                    continue block0;
                }
                requestBuilder.setField(descriptor, (Object)report);
                continue block0;
            }
        }
    }

    private void addContainerActions(StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.Builder requestBuilder) {
        List<StorageContainerDatanodeProtocolProtos.ContainerAction> actions = this.context.getPendingContainerAction(this.rpcEndpoint.getAddress(), this.maxContainerActionsPerHB);
        if (!actions.isEmpty()) {
            StorageContainerDatanodeProtocolProtos.ContainerActionsProto cap = StorageContainerDatanodeProtocolProtos.ContainerActionsProto.newBuilder().addAllContainerActions(actions).build();
            requestBuilder.setContainerActions(cap);
        }
    }

    private void addPipelineActions(StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.Builder requestBuilder) {
        List<StorageContainerDatanodeProtocolProtos.PipelineAction> actions = this.context.getPendingPipelineAction(this.rpcEndpoint.getAddress(), this.maxPipelineActionsPerHB);
        if (!actions.isEmpty()) {
            StorageContainerDatanodeProtocolProtos.PipelineActionsProto pap = StorageContainerDatanodeProtocolProtos.PipelineActionsProto.newBuilder().addAllPipelineActions(actions).build();
            requestBuilder.setPipelineActions(pap);
        }
    }

    private void addQueuedCommandCounts(StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.Builder requestBuilder) {
        Map<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, Integer> commandCount = this.context.getParent().getQueuedCommandCount();
        StorageContainerDatanodeProtocolProtos.CommandQueueReportProto.Builder reportProto = StorageContainerDatanodeProtocolProtos.CommandQueueReportProto.newBuilder();
        for (Map.Entry<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, Integer> entry : commandCount.entrySet()) {
            reportProto.addCommand(entry.getKey()).addCount(entry.getValue().intValue());
        }
        requestBuilder.setCommandQueueReport(reportProto.build());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private void processResponse(StorageContainerDatanodeProtocolProtos.SCMHeartbeatResponseProto response, HddsProtos.DatanodeDetailsProto datanodeDetails) {
        Preconditions.checkState((boolean)response.getDatanodeUUID().equalsIgnoreCase(datanodeDetails.getUuid()), (Object)"Unexpected datanode ID in the response.");
        if (response.hasTerm()) {
            this.context.updateTermOfLeaderSCM(response.getTerm());
        }
        block13: for (StorageContainerDatanodeProtocolProtos.SCMCommandProto commandResponseProto : response.getCommandsList()) {
            switch (commandResponseProto.getCommandType()) {
                case reregisterCommand: {
                    this.processReregisterCommand();
                    continue block13;
                }
                case deleteBlocksCommand: {
                    DeleteBlocksCommand deleteBlocksCommand = DeleteBlocksCommand.getFromProtobuf(commandResponseProto.getDeleteBlocksCommandProto());
                    if (deleteBlocksCommand.blocksTobeDeleted().isEmpty()) continue block13;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(DeletedContainerBlocksSummary.getFrom(deleteBlocksCommand.blocksTobeDeleted()).toString());
                    }
                    this.processCommonCommand(commandResponseProto, deleteBlocksCommand);
                    continue block13;
                }
                case closeContainerCommand: {
                    CloseContainerCommand closeContainer = CloseContainerCommand.getFromProtobuf(commandResponseProto.getCloseContainerCommandProto());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received SCM container close request for container {}", (Object)closeContainer.getContainerID());
                    }
                    this.processCommonCommand(commandResponseProto, closeContainer);
                    continue block13;
                }
                case replicateContainerCommand: {
                    ReplicateContainerCommand replicateContainerCommand = ReplicateContainerCommand.getFromProtobuf(commandResponseProto.getReplicateContainerCommandProto());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received SCM container replicate request for container {}", (Object)replicateContainerCommand.getContainerID());
                    }
                    this.processCommonCommand(commandResponseProto, replicateContainerCommand);
                    continue block13;
                }
                case reconstructECContainersCommand: {
                    ReconstructECContainersCommand reccc = ReconstructECContainersCommand.getFromProtobuf(commandResponseProto.getReconstructECContainersCommandProto());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received SCM reconstruct request for container {}", (Object)reccc.getContainerID());
                    }
                    this.processCommonCommand(commandResponseProto, reccc);
                    continue block13;
                }
                case deleteContainerCommand: {
                    DeleteContainerCommand deleteContainerCommand = DeleteContainerCommand.getFromProtobuf(commandResponseProto.getDeleteContainerCommandProto());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received SCM delete container request for container {}", (Object)deleteContainerCommand.getContainerID());
                    }
                    this.processCommonCommand(commandResponseProto, deleteContainerCommand);
                    continue block13;
                }
                case createPipelineCommand: {
                    CreatePipelineCommand createPipelineCommand = CreatePipelineCommand.getFromProtobuf(commandResponseProto.getCreatePipelineCommandProto());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received SCM create pipeline request {}", (Object)createPipelineCommand.getPipelineID());
                    }
                    this.processCommonCommand(commandResponseProto, createPipelineCommand);
                    continue block13;
                }
                case closePipelineCommand: {
                    ClosePipelineCommand closePipelineCommand = ClosePipelineCommand.getFromProtobuf(commandResponseProto.getClosePipelineCommandProto());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received SCM close pipeline request {}", (Object)closePipelineCommand.getPipelineID());
                    }
                    this.processCommonCommand(commandResponseProto, closePipelineCommand);
                    continue block13;
                }
                case setNodeOperationalStateCommand: {
                    SetNodeOperationalStateCommand setNodeOperationalStateCommand = SetNodeOperationalStateCommand.getFromProtobuf(commandResponseProto.getSetNodeOperationalStateCommandProto());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received SCM set operational state command. State: {} Expiry: {}", (Object)setNodeOperationalStateCommand.getOpState(), (Object)setNodeOperationalStateCommand.getStateExpiryEpochSeconds());
                    }
                    this.processCommonCommand(commandResponseProto, setNodeOperationalStateCommand);
                    continue block13;
                }
                case finalizeNewLayoutVersionCommand: {
                    FinalizeNewLayoutVersionCommand finalizeNewLayoutVersionCommand = FinalizeNewLayoutVersionCommand.getFromProtobuf(commandResponseProto.getFinalizeNewLayoutVersionCommandProto());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received SCM finalize command {}", (Object)finalizeNewLayoutVersionCommand.getId());
                    }
                    this.processCommonCommand(commandResponseProto, finalizeNewLayoutVersionCommand);
                    continue block13;
                }
                case refreshVolumeUsageInfo: {
                    RefreshVolumeUsageCommand refreshVolumeUsageCommand = RefreshVolumeUsageCommand.getFromProtobuf(commandResponseProto.getRefreshVolumeUsageCommandProto());
                    this.processCommonCommand(commandResponseProto, refreshVolumeUsageCommand);
                    continue block13;
                }
            }
            throw new IllegalArgumentException("Unknown response : " + commandResponseProto.getCommandType().name());
        }
    }

    private void processCommonCommand(StorageContainerDatanodeProtocolProtos.SCMCommandProto response, SCMCommand<?> cmd) {
        if (response.hasTerm()) {
            cmd.setTerm(response.getTerm());
        }
        if (response.hasEncodedToken()) {
            cmd.setEncodedToken(response.getEncodedToken());
        }
        if (response.hasDeadlineMsSinceEpoch()) {
            cmd.setDeadline(response.getDeadlineMsSinceEpoch());
        }
        this.context.addCommand(cmd);
    }

    private void processReregisterCommand() {
        if (this.rpcEndpoint.getState() == EndpointStateMachine.EndPointStates.HEARTBEAT) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received SCM notification to register. Interrupt HEARTBEAT and transit to GETVERSION state.");
            }
            this.rpcEndpoint.setState(EndpointStateMachine.EndPointStates.GETVERSION);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Illegal state {} found, expecting {}.", (Object)this.rpcEndpoint.getState().name(), (Object)EndpointStateMachine.EndPointStates.HEARTBEAT);
        }
    }

    public static class Builder {
        private EndpointStateMachine endPointStateMachine;
        private ConfigurationSource conf;
        private DatanodeDetails datanodeDetails;
        private StateContext context;
        private HDDSLayoutVersionManager versionManager;

        public Builder setEndpointStateMachine(EndpointStateMachine rpcEndPoint) {
            this.endPointStateMachine = rpcEndPoint;
            return this;
        }

        public Builder setLayoutVersionManager(HDDSLayoutVersionManager lvm) {
            this.versionManager = lvm;
            return this;
        }

        public Builder setConfig(ConfigurationSource config) {
            this.conf = config;
            return this;
        }

        public Builder setDatanodeDetails(DatanodeDetails dnDetails) {
            this.datanodeDetails = dnDetails;
            return this;
        }

        public Builder setContext(StateContext stateContext) {
            this.context = stateContext;
            return this;
        }

        public HeartbeatEndpointTask build() {
            if (this.endPointStateMachine == null) {
                LOG.error("No endpoint specified.");
                throw new IllegalArgumentException("A valid endpoint state machine is needed to construct HeartbeatEndpointTask task");
            }
            if (this.conf == null) {
                LOG.error("No config specified.");
                throw new IllegalArgumentException("A valid configration is needed to construct HeartbeatEndpointTask task");
            }
            if (this.datanodeDetails == null) {
                LOG.error("No datanode specified.");
                throw new IllegalArgumentException("A valid Node ID is needed to construct HeartbeatEndpointTask task");
            }
            HeartbeatEndpointTask task = new HeartbeatEndpointTask(this.endPointStateMachine, this.conf, this.context, this.versionManager);
            task.setDatanodeDetailsProto(this.datanodeDetails.getProtoBufMessage());
            return task;
        }
    }
}

