/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.report;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.datanode.metadata.DatanodeCRLStore;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.security.x509.crl.CRLInfo;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.ozone.container.common.report.ReportPublisher;

public class CRLStatusReportPublisher
extends ReportPublisher<StorageContainerDatanodeProtocolProtos.CRLStatusReport> {
    private Long crlStatusReportInterval = null;

    @Override
    protected long getReportFrequency() {
        if (this.crlStatusReportInterval == null) {
            this.crlStatusReportInterval = this.getConf().getTimeDuration("hdds.crl.status.report.interval", "60s", TimeUnit.MILLISECONDS);
            long heartbeatFrequency = HddsServerUtil.getScmHeartbeatInterval((ConfigurationSource)this.getConf());
            Preconditions.checkState((heartbeatFrequency <= this.crlStatusReportInterval ? 1 : 0) != 0, (Object)"hdds.crl.status.report.interval cannot be configured lower than heartbeat frequency.");
        }
        return this.crlStatusReportInterval;
    }

    @Override
    protected StorageContainerDatanodeProtocolProtos.CRLStatusReport getReport() throws IOException {
        StorageContainerDatanodeProtocolProtos.CRLStatusReport.Builder builder = StorageContainerDatanodeProtocolProtos.CRLStatusReport.newBuilder();
        DatanodeCRLStore dnCRLStore = this.getContext().getParent().getDnCRLStore();
        builder.setReceivedCrlId(dnCRLStore.getLatestCRLSequenceID().longValue());
        if (dnCRLStore.getPendingCRLs().size() > 0) {
            List pendingCRLIds = dnCRLStore.getPendingCRLs().stream().map(CRLInfo::getCrlSequenceID).collect(Collectors.toList());
            builder.addAllPendingCrlIds(pendingCRLIds);
        }
        return builder.build();
    }
}

