/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import org.apache.hadoop.util.Time;

public final class MonotonicClock
extends Clock {
    private final ZoneId zoneId;

    public MonotonicClock(ZoneId zone) {
        this.zoneId = zone;
    }

    @Override
    public ZoneId getZone() {
        return this.zoneId;
    }

    @Override
    public Clock withZone(ZoneId zone) {
        if (zone.equals(this.zoneId)) {
            return this;
        }
        return new MonotonicClock(zone);
    }

    @Override
    public long millis() {
        return Time.monotonicNow();
    }

    @Override
    public Instant instant() {
        return Instant.ofEpochMilli(this.millis());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MonotonicClock) {
            return this.zoneId.equals(((MonotonicClock)obj).zoneId);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.zoneId.hashCode() + 1;
    }

    public String toString() {
        return "MonotonicClock[" + this.zoneId + "]";
    }
}

