/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;

public final class IOUtils {
    private IOUtils() {
    }

    public static void cleanupWithLogger(Logger logger, Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Throwable e) {
                if (logger == null) continue;
                logger.debug("Exception in closing {}", (Object)c, (Object)e);
            }
        }
    }

    public static void close(Logger logger, AutoCloseable ... closeables) {
        IOUtils.close(logger, Arrays.asList(closeables));
    }

    public static void close(Logger logger, Collection<? extends AutoCloseable> closeables) {
        if (closeables == null) {
            return;
        }
        for (AutoCloseable autoCloseable : closeables) {
            if (autoCloseable == null) continue;
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                if (logger == null) continue;
                logger.error("Exception in closing {}", (Object)autoCloseable, (Object)e);
            }
        }
    }

    public static void closeQuietly(AutoCloseable ... closeables) {
        IOUtils.close(null, closeables);
    }

    public static void closeQuietly(Collection<? extends AutoCloseable> closeables) {
        IOUtils.close(null, closeables);
    }
}

