/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.tracing;

import io.jaegertracing.Configuration;
import io.jaegertracing.internal.JaegerTracer;
import io.jaegertracing.spi.Extractor;
import io.jaegertracing.spi.Injector;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.util.GlobalTracer;
import java.lang.reflect.Proxy;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.tracing.StringCodec;
import org.apache.hadoop.hdds.tracing.TraceAllMethod;
import org.apache.ratis.util.function.CheckedRunnable;
import org.apache.ratis.util.function.CheckedSupplier;

public final class TracingUtil {
    private static final String NULL_SPAN_AS_STRING = "";
    private static volatile boolean isInit = false;

    private TracingUtil() {
    }

    public static void initTracing(String serviceName, ConfigurationSource conf) {
        if (!GlobalTracer.isRegistered() && TracingUtil.isTracingEnabled(conf)) {
            Configuration config = Configuration.fromEnv((String)serviceName);
            JaegerTracer tracer = config.getTracerBuilder().registerExtractor((Format)StringCodec.FORMAT, (Extractor)new StringCodec()).registerInjector((Format)StringCodec.FORMAT, (Injector)new StringCodec()).build();
            GlobalTracer.registerIfAbsent((Tracer)tracer);
            isInit = true;
        }
    }

    public static String exportCurrentSpan() {
        return TracingUtil.exportSpan(GlobalTracer.get().activeSpan());
    }

    public static String exportSpan(Span span) {
        if (span != null && isInit) {
            StringBuilder builder = new StringBuilder();
            GlobalTracer.get().inject(span.context(), (Format)StringCodec.FORMAT, (Object)builder);
            return builder.toString();
        }
        return NULL_SPAN_AS_STRING;
    }

    public static Span importAndCreateSpan(String name, String encodedParent) {
        Tracer tracer = GlobalTracer.get();
        return tracer.buildSpan(name).asChildOf(TracingUtil.extractParent(encodedParent, tracer)).start();
    }

    private static SpanContext extractParent(String parent, Tracer tracer) {
        if (!GlobalTracer.isRegistered()) {
            return null;
        }
        if (parent == null || parent.isEmpty()) {
            return null;
        }
        return tracer.extract((Format)StringCodec.FORMAT, (Object)new StringBuilder(parent));
    }

    public static <T> T createProxy(T delegate, Class<T> itf, ConfigurationSource conf) {
        if (!TracingUtil.isTracingEnabled(conf)) {
            return delegate;
        }
        Class<?> aClass = delegate.getClass();
        return itf.cast(Proxy.newProxyInstance(aClass.getClassLoader(), new Class[]{itf}, new TraceAllMethod<T>(delegate, itf.getSimpleName())));
    }

    public static boolean isTracingEnabled(ConfigurationSource conf) {
        return conf.getBoolean("hdds.tracing.enabled", false);
    }

    public static <R, E extends Exception> R executeInNewSpan(String spanName, CheckedSupplier<R, E> supplier) throws E {
        Span span = GlobalTracer.get().buildSpan(spanName).start();
        return TracingUtil.executeInSpan(span, supplier);
    }

    public static <E extends Exception> void executeInNewSpan(String spanName, CheckedRunnable<E> runnable) throws E {
        Span span = GlobalTracer.get().buildSpan(spanName).start();
        TracingUtil.executeInSpan(span, runnable);
    }

    /*
     * Exception decompiling
     */
    private static <R, E extends Exception> R executeInSpan(Span span, CheckedSupplier<R, E> supplier) throws E {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static <E extends Exception> void executeInSpan(Span span, CheckedRunnable<E> runnable) throws E {
        try (Scope ignored = GlobalTracer.get().activateSpan(span);){
            runnable.run();
        }
        catch (Exception ex) {
            span.setTag("failed", true);
            throw ex;
        }
        finally {
            span.finish();
        }
    }

    public static <R, E extends Exception> R executeAsChildSpan(String spanName, String parentName, CheckedSupplier<R, E> supplier) throws E {
        Span span = TracingUtil.importAndCreateSpan(spanName, parentName);
        return TracingUtil.executeInSpan(span, supplier);
    }

    public static <E extends Exception> void executeAsChildSpan(String spanName, String parentName, CheckedRunnable<E> runnable) throws E {
        Span span = TracingUtil.importAndCreateSpan(spanName, parentName);
        TracingUtil.executeInSpan(span, runnable);
    }

    public static AutoCloseable createActivatedSpan(String spanName) {
        Span span = GlobalTracer.get().buildSpan(spanName).start();
        Scope scope = GlobalTracer.get().activateSpan(span);
        return () -> {
            scope.close();
            span.finish();
        };
    }
}

