/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.ratis;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.NotLeaderException;

public class ServerNotLeaderException
extends IOException {
    private final String currentPeerId;
    private final String leader;
    private static final Pattern CURRENT_PEER_ID_PATTERN = Pattern.compile("Server:(.*) is not the leader[.]+.*", 32);
    private static final Pattern SUGGESTED_LEADER_PATTERN = Pattern.compile(".*Suggested leader is Server:([^:]*)(:[0-9]+).*", 32);

    public ServerNotLeaderException(RaftPeerId currentPeerId) {
        super("Server:" + currentPeerId + " is not the leader. Could not determine the leader node.");
        this.currentPeerId = currentPeerId.toString();
        this.leader = null;
    }

    public ServerNotLeaderException(RaftPeerId currentPeerId, String suggestedLeader) {
        super("Server:" + currentPeerId + " is not the leader. Suggested leader is Server:" + suggestedLeader + ".");
        this.currentPeerId = currentPeerId.toString();
        this.leader = suggestedLeader;
    }

    public ServerNotLeaderException(String message) {
        super(message);
        Matcher currentLeaderMatcher = CURRENT_PEER_ID_PATTERN.matcher(message);
        if (currentLeaderMatcher.matches()) {
            this.currentPeerId = currentLeaderMatcher.group(1);
            Matcher suggestedLeaderMatcher = SUGGESTED_LEADER_PATTERN.matcher(message);
            this.leader = suggestedLeaderMatcher.matches() ? (suggestedLeaderMatcher.groupCount() == 2 ? (suggestedLeaderMatcher.group(1).isEmpty() || suggestedLeaderMatcher.group(2).isEmpty() ? null : suggestedLeaderMatcher.group(1) + suggestedLeaderMatcher.group(2)) : null) : null;
        } else {
            this.currentPeerId = null;
            this.leader = null;
        }
    }

    public String getSuggestedLeader() {
        return this.leader;
    }

    public static ServerNotLeaderException convertToNotLeaderException(NotLeaderException notLeaderException, RaftPeerId currentPeer, String port) {
        ServerNotLeaderException serverNotLeaderException;
        String suggestedLeader;
        String string = suggestedLeader = notLeaderException.getSuggestedLeader() != null ? HddsUtils.getHostName(notLeaderException.getSuggestedLeader().getAddress()).get() : null;
        if (suggestedLeader != null) {
            String suggestedLeaderHostPort = suggestedLeader + ":" + port;
            serverNotLeaderException = new ServerNotLeaderException(currentPeer, suggestedLeaderHostPort);
        } else {
            serverNotLeaderException = new ServerNotLeaderException(currentPeer);
        }
        return serverNotLeaderException;
    }
}

