/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.datanode;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import picocli.CommandLine;

@CommandLine.Command(name="decommission", description={"Show status of datanodes in DECOMMISSIONING"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class DecommissionStatusSubCommand
extends ScmSubcommand {
    @CommandLine.Option(names={"--id"}, description={"Show info by datanode UUID"}, defaultValue="")
    private String uuid;
    @CommandLine.Option(names={"--ip"}, description={"Show info by datanode ipAddress"}, defaultValue="")
    private String ipAddress;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        List decommissioningNodes;
        Stream allNodes = scmClient.queryNode(HddsProtos.NodeOperationalState.DECOMMISSIONING, null, HddsProtos.QueryScope.CLUSTER, "").stream();
        if (!Strings.isNullOrEmpty((String)this.uuid)) {
            decommissioningNodes = allNodes.filter(p -> p.getNodeID().getUuid().equals(this.uuid)).collect(Collectors.toList());
            if (decommissioningNodes.isEmpty()) {
                System.err.println("Datanode: " + this.uuid + " is not in DECOMMISSIONING");
                return;
            }
        } else if (!Strings.isNullOrEmpty((String)this.ipAddress)) {
            decommissioningNodes = allNodes.filter(p -> p.getNodeID().getIpAddress().compareToIgnoreCase(this.ipAddress) == 0).collect(Collectors.toList());
            if (decommissioningNodes.isEmpty()) {
                System.err.println("Datanode: " + this.ipAddress + " is not in DECOMMISSIONING");
                return;
            }
        } else {
            decommissioningNodes = allNodes.collect(Collectors.toList());
            System.out.println("\nDecommission Status: DECOMMISSIONING - " + decommissioningNodes.size() + " node(s)");
        }
        for (HddsProtos.Node node : decommissioningNodes) {
            DatanodeDetails datanode = DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)node.getNodeID());
            this.printDetails(datanode);
        }
    }

    private void printDetails(DatanodeDetails datanode) {
        System.out.println("\nDatanode: " + datanode.getUuid().toString() + " (" + datanode.getNetworkLocation() + "/" + datanode.getIpAddress() + "/" + datanode.getHostName() + ")");
    }
}

