/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import picocli.CommandLine;

@CommandLine.Command(name="start", description={"Start ContainerBalancer"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class ContainerBalancerStartSubcommand
extends ScmSubcommand {
    @CommandLine.Option(names={"-t", "--threshold"}, description={"Percentage deviation from average utilization of the cluster after which a datanode will be rebalanced (for example, '10' for 10%%)."})
    private Optional<Double> threshold;
    @CommandLine.Option(names={"-i", "--iterations"}, description={"Maximum consecutive iterations that balancer will run for."})
    private Optional<Integer> iterations;
    @CommandLine.Option(names={"-d", "--max-datanodes-percentage-to-involve-per-iteration", "--maxDatanodesPercentageToInvolvePerIteration"}, description={"Max percentage of healthy, in service datanodes that can be involved in balancing in one iteration (for example, '20' for 20%%)."})
    private Optional<Integer> maxDatanodesPercentageToInvolvePerIteration;
    @CommandLine.Option(names={"-s", "--max-size-to-move-per-iteration-in-gb", "--maxSizeToMovePerIterationInGB"}, description={"Maximum size that can be moved per iteration of balancing (for example, '500' for 500GB)."})
    private Optional<Long> maxSizeToMovePerIterationInGB;
    @CommandLine.Option(names={"-e", "--max-size-entering-target-in-gb", "--maxSizeEnteringTargetInGB"}, description={"Maximum size that can enter a target datanode while balancing. This is the sum of data from multiple sources (for example, '26' for 26GB)."})
    private Optional<Long> maxSizeEnteringTargetInGB;
    @CommandLine.Option(names={"-l", "--max-size-leaving-source-in-gb", "--maxSizeLeavingSourceInGB"}, description={"Maximum size that can leave a source datanode while balancing. This is the sum of data moving to multiple targets (for example, '26' for 26GB)."})
    private Optional<Long> maxSizeLeavingSourceInGB;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        StorageContainerLocationProtocolProtos.StartContainerBalancerResponseProto response = scmClient.startContainerBalancer(this.threshold, this.iterations, this.maxDatanodesPercentageToInvolvePerIteration, this.maxSizeToMovePerIterationInGB, this.maxSizeEnteringTargetInGB, this.maxSizeLeavingSourceInGB);
        if (response.getStart()) {
            System.out.println("Container Balancer started successfully.");
        } else {
            System.out.println("Failed to start Container Balancer.");
            if (response.hasMessage()) {
                System.out.printf("Failure reason: %s", response.getMessage());
            }
        }
    }
}

