/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.cli;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.security.UserGroupInformation;
import picocli.CommandLine;

@CommandLine.Command(name="ozone admin", hidden=true, description={"Developer tools for Ozone Admin operations"}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true)
public class OzoneAdmin
extends GenericCli {
    private OzoneConfiguration ozoneConf;
    private UserGroupInformation user;

    public OzoneAdmin() {
        super(OzoneAdmin.class);
    }

    @VisibleForTesting
    public OzoneAdmin(OzoneConfiguration conf) {
        super(OzoneAdmin.class);
        this.ozoneConf = conf;
    }

    public OzoneConfiguration getOzoneConf() {
        if (this.ozoneConf == null) {
            this.ozoneConf = this.createOzoneConfiguration();
        }
        return this.ozoneConf;
    }

    public UserGroupInformation getUser() throws IOException {
        if (this.user == null) {
            this.user = UserGroupInformation.getCurrentUser();
        }
        return this.user;
    }

    public static void main(String[] argv) {
        new OzoneAdmin().run(argv);
    }

    public int execute(String[] argv) {
        TracingUtil.initTracing((String)"shell", (ConfigurationSource)this.createOzoneConfiguration());
        String spanName = "ozone admin " + String.join((CharSequence)" ", argv);
        return (Integer)TracingUtil.executeInNewSpan((String)spanName, () -> super.execute(argv));
    }
}

