/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.fs.http.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrCodec;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.StringUtils;

final class JsonUtil {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private JsonUtil() {
    }

    public static String toJsonString(Token<? extends TokenIdentifier> token) throws IOException {
        return JsonUtil.toJsonString(Token.class, JsonUtil.toJsonMap(token));
    }

    private static Map<String, Object> toJsonMap(Token<? extends TokenIdentifier> token) throws IOException {
        if (token == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("urlString", token.encodeToUrlString());
        return m;
    }

    public static String toJsonString(Exception e) {
        TreeMap<String, String> m = new TreeMap<String, String>();
        m.put("exception", e.getClass().getSimpleName());
        m.put("message", e.getMessage());
        m.put("javaClassName", e.getClass().getName());
        return JsonUtil.toJsonString(RemoteException.class, m);
    }

    private static String toJsonString(Class<?> clazz, Object value) {
        return JsonUtil.toJsonString(clazz.getSimpleName(), value);
    }

    public static String toJsonString(String key, Object value) {
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put(key, value);
        try {
            return MAPPER.writeValueAsString(m);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String toString(FsPermission permission) {
        return String.format("%o", permission.toShort());
    }

    private static Map<String, Object> toJsonMap(ExtendedBlock extendedblock) {
        if (extendedblock == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("blockPoolId", extendedblock.getBlockPoolId());
        m.put("blockId", extendedblock.getBlockId());
        m.put("numBytes", extendedblock.getNumBytes());
        m.put("generationStamp", extendedblock.getGenerationStamp());
        return m;
    }

    static Map<String, Object> toJsonMap(DatanodeInfo datanodeinfo) {
        if (datanodeinfo == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("ipAddr", datanodeinfo.getIpAddr());
        m.put("name", datanodeinfo.getXferAddr());
        m.put("hostName", datanodeinfo.getHostName());
        m.put("storageID", datanodeinfo.getDatanodeUuid());
        m.put("xferPort", datanodeinfo.getXferPort());
        m.put("infoPort", datanodeinfo.getInfoPort());
        m.put("infoSecurePort", datanodeinfo.getInfoSecurePort());
        m.put("ipcPort", datanodeinfo.getIpcPort());
        m.put("capacity", datanodeinfo.getCapacity());
        m.put("dfsUsed", datanodeinfo.getDfsUsed());
        m.put("remaining", datanodeinfo.getRemaining());
        m.put("blockPoolUsed", datanodeinfo.getBlockPoolUsed());
        m.put("cacheCapacity", datanodeinfo.getCacheCapacity());
        m.put("cacheUsed", datanodeinfo.getCacheUsed());
        m.put("lastUpdate", datanodeinfo.getLastUpdate());
        m.put("lastUpdateMonotonic", datanodeinfo.getLastUpdateMonotonic());
        m.put("xceiverCount", datanodeinfo.getXceiverCount());
        m.put("networkLocation", datanodeinfo.getNetworkLocation());
        m.put("adminState", datanodeinfo.getAdminState().name());
        if (datanodeinfo.getUpgradeDomain() != null) {
            m.put("upgradeDomain", datanodeinfo.getUpgradeDomain());
        }
        m.put("lastBlockReportTime", datanodeinfo.getLastBlockReportTime());
        m.put("lastBlockReportMonotonic", datanodeinfo.getLastBlockReportMonotonic());
        return m;
    }

    private static Object[] toJsonArray(DatanodeInfo[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] a = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = JsonUtil.toJsonMap(array[i]);
        }
        return a;
    }

    private static Object[] toJsonArray(StorageType[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] a = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = array[i];
        }
        return a;
    }

    private static Map<String, Object> toJsonMap(LocatedBlock locatedblock) throws IOException {
        if (locatedblock == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("blockToken", JsonUtil.toJsonMap((Token<? extends TokenIdentifier>)locatedblock.getBlockToken()));
        m.put("isCorrupt", locatedblock.isCorrupt());
        m.put("startOffset", locatedblock.getStartOffset());
        m.put("block", JsonUtil.toJsonMap(locatedblock.getBlock()));
        m.put("storageTypes", JsonUtil.toJsonArray(locatedblock.getStorageTypes()));
        m.put("locations", JsonUtil.toJsonArray((DatanodeInfo[])locatedblock.getLocations()));
        m.put("cachedLocations", JsonUtil.toJsonArray(locatedblock.getCachedLocations()));
        return m;
    }

    private static Object[] toJsonArray(List<LocatedBlock> array) throws IOException {
        if (array == null) {
            return null;
        }
        if (array.size() == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] a = new Object[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            a[i] = JsonUtil.toJsonMap(array.get(i));
        }
        return a;
    }

    public static String toJsonString(LocatedBlocks locatedblocks) throws IOException {
        if (locatedblocks == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("fileLength", locatedblocks.getFileLength());
        m.put("isUnderConstruction", locatedblocks.isUnderConstruction());
        m.put("locatedBlocks", JsonUtil.toJsonArray(locatedblocks.getLocatedBlocks()));
        m.put("lastLocatedBlock", JsonUtil.toJsonMap(locatedblocks.getLastLocatedBlock()));
        m.put("isLastBlockComplete", locatedblocks.isLastBlockComplete());
        return JsonUtil.toJsonString(LocatedBlocks.class, m);
    }

    public static String toJsonString(ContentSummary contentsummary) {
        if (contentsummary == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("length", contentsummary.getLength());
        m.put("fileCount", contentsummary.getFileCount());
        m.put("directoryCount", contentsummary.getDirectoryCount());
        m.put("ecPolicy", contentsummary.getErasureCodingPolicy());
        m.putAll(JsonUtil.toJsonMap((QuotaUsage)contentsummary, false));
        m.put("snapshotLength", contentsummary.getSnapshotLength());
        m.put("snapshotFileCount", contentsummary.getSnapshotFileCount());
        m.put("snapshotDirectoryCount", contentsummary.getSnapshotDirectoryCount());
        m.put("snapshotSpaceConsumed", contentsummary.getSnapshotSpaceConsumed());
        return JsonUtil.toJsonString(ContentSummary.class, m);
    }

    public static String toJsonString(QuotaUsage quotaUsage) {
        if (quotaUsage == null) {
            return null;
        }
        return JsonUtil.toJsonString(QuotaUsage.class, JsonUtil.toJsonMap(quotaUsage, true));
    }

    private static Map<String, Object> toJsonMap(QuotaUsage quotaUsage, boolean includeFileAndDirectoryCount) {
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        if (includeFileAndDirectoryCount) {
            m.put("fileAndDirectoryCount", quotaUsage.getFileAndDirectoryCount());
        }
        m.put("quota", quotaUsage.getQuota());
        m.put("spaceConsumed", quotaUsage.getSpaceConsumed());
        m.put("spaceQuota", quotaUsage.getSpaceQuota());
        TreeMap<String, TreeMap<String, Long>> typeQuota = new TreeMap<String, TreeMap<String, Long>>();
        for (StorageType t : StorageType.getTypesSupportingQuota()) {
            long tQuota = quotaUsage.getTypeQuota(t);
            if (tQuota == -1L) continue;
            TreeMap<String, Long> type = (TreeMap<String, Long>)typeQuota.get(t.toString());
            if (type == null) {
                type = new TreeMap<String, Long>();
                typeQuota.put(t.toString(), type);
            }
            type.put("quota", quotaUsage.getTypeQuota(t));
            type.put("consumed", quotaUsage.getTypeConsumed(t));
        }
        m.put("typeQuota", typeQuota);
        return m;
    }

    public static String toJsonString(MD5MD5CRC32FileChecksum checksum) {
        if (checksum == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("algorithm", checksum.getAlgorithmName());
        m.put("length", checksum.getLength());
        m.put("bytes", StringUtils.byteToHexString((byte[])checksum.getBytes()));
        return JsonUtil.toJsonString(FileChecksum.class, m);
    }

    public static String toJsonString(AclStatus status) {
        if (status == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("owner", status.getOwner());
        m.put("group", status.getGroup());
        m.put("stickyBit", status.isStickyBit());
        ArrayList<String> stringEntries = new ArrayList<String>();
        for (AclEntry entry : status.getEntries()) {
            stringEntries.add(entry.toStringStable());
        }
        m.put("entries", stringEntries);
        FsPermission perm = status.getPermission();
        if (perm != null) {
            m.put("permission", JsonUtil.toString(perm));
        }
        TreeMap<String, TreeMap<String, Object>> finalMap = new TreeMap<String, TreeMap<String, Object>>();
        finalMap.put(AclStatus.class.getSimpleName(), m);
        try {
            return MAPPER.writeValueAsString(finalMap);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static Map<String, Object> toJsonMap(XAttr xAttr, XAttrCodec encoding) throws IOException {
        if (xAttr == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("name", XAttrHelper.getPrefixedName((XAttr)xAttr));
        m.put("value", xAttr.getValue() != null ? XAttrCodec.encodeValue((byte[])xAttr.getValue(), (XAttrCodec)encoding) : null);
        return m;
    }

    private static Object[] toJsonArray(List<XAttr> array, XAttrCodec encoding) throws IOException {
        if (array == null) {
            return null;
        }
        if (array.size() == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] a = new Object[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            a[i] = JsonUtil.toJsonMap(array.get(i), encoding);
        }
        return a;
    }

    public static String toJsonString(List<XAttr> xAttrs, XAttrCodec encoding) throws IOException {
        TreeMap<String, Object[]> finalMap = new TreeMap<String, Object[]>();
        finalMap.put("XAttrs", JsonUtil.toJsonArray(xAttrs, encoding));
        return MAPPER.writeValueAsString(finalMap);
    }

    public static String toJsonString(List<XAttr> xAttrs) throws IOException {
        ArrayList<String> names = new ArrayList<String>(xAttrs.size());
        for (XAttr xAttr : xAttrs) {
            names.add(XAttrHelper.getPrefixedName((XAttr)xAttr));
        }
        String ret = MAPPER.writeValueAsString(names);
        TreeMap<String, String> finalMap = new TreeMap<String, String>();
        finalMap.put("XAttrNames", ret);
        return MAPPER.writeValueAsString(finalMap);
    }

    public static String toJsonString(Object obj) throws IOException {
        return MAPPER.writeValueAsString(obj);
    }

    public static String toJsonString(BlockStoragePolicy[] storagePolicies) {
        TreeMap<String, Object[]> blockStoragePolicies = new TreeMap<String, Object[]>();
        Object[] a = null;
        if (storagePolicies != null && storagePolicies.length > 0) {
            a = new Object[storagePolicies.length];
            for (int i = 0; i < storagePolicies.length; ++i) {
                a[i] = JsonUtil.toJsonMap(storagePolicies[i]);
            }
        }
        blockStoragePolicies.put("BlockStoragePolicy", a);
        return JsonUtil.toJsonString("BlockStoragePolicies", blockStoragePolicies);
    }

    private static Object toJsonMap(BlockStoragePolicy blockStoragePolicy) {
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("id", blockStoragePolicy.getId());
        m.put("name", blockStoragePolicy.getName());
        m.put("storageTypes", blockStoragePolicy.getStorageTypes());
        m.put("creationFallbacks", blockStoragePolicy.getCreationFallbacks());
        m.put("replicationFallbacks", blockStoragePolicy.getReplicationFallbacks());
        m.put("copyOnCreateFile", blockStoragePolicy.isCopyOnCreateFile());
        return m;
    }

    public static String toJsonString(BlockStoragePolicy storagePolicy) {
        return JsonUtil.toJsonString(BlockStoragePolicy.class, JsonUtil.toJsonMap(storagePolicy));
    }

    public static String toJsonString(FsServerDefaults serverDefaults) {
        return JsonUtil.toJsonString(FsServerDefaults.class, JsonUtil.toJsonMap(serverDefaults));
    }

    private static Object toJsonMap(FsServerDefaults serverDefaults) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("blockSize", serverDefaults.getBlockSize());
        m.put("bytesPerChecksum", serverDefaults.getBytesPerChecksum());
        m.put("writePacketSize", serverDefaults.getWritePacketSize());
        m.put("replication", serverDefaults.getReplication());
        m.put("fileBufferSize", serverDefaults.getFileBufferSize());
        m.put("encryptDataTransfer", serverDefaults.getEncryptDataTransfer());
        m.put("trashInterval", serverDefaults.getTrashInterval());
        m.put("checksumType", serverDefaults.getChecksumType().id);
        m.put("keyProviderUri", serverDefaults.getKeyProviderUri());
        m.put("defaultStoragePolicyId", serverDefaults.getDefaultStoragePolicyId());
        return m;
    }

    public static String toJsonString(SnapshotDiffReport diffReport) {
        return JsonUtil.toJsonString(SnapshotDiffReport.class.getSimpleName(), JsonUtil.toJsonMap(diffReport));
    }

    private static Object toJsonMap(SnapshotDiffReport diffReport) {
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("snapshotRoot", diffReport.getSnapshotRoot());
        m.put("fromSnapshot", diffReport.getFromSnapshot());
        m.put("toSnapshot", diffReport.getLaterSnapshotName());
        Object[] diffList = new Object[diffReport.getDiffList().size()];
        for (int i = 0; i < diffReport.getDiffList().size(); ++i) {
            diffList[i] = JsonUtil.toJsonMap((SnapshotDiffReport.DiffReportEntry)diffReport.getDiffList().get(i));
        }
        m.put("diffList", diffList);
        return m;
    }

    private static Object toJsonMap(SnapshotDiffReport.DiffReportEntry diffReportEntry) {
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("type", diffReportEntry.getType());
        if (diffReportEntry.getSourcePath() != null) {
            m.put("sourcePath", DFSUtilClient.bytes2String((byte[])diffReportEntry.getSourcePath()));
        }
        if (diffReportEntry.getTargetPath() != null) {
            m.put("targetPath", DFSUtilClient.bytes2String((byte[])diffReportEntry.getTargetPath()));
        }
        return m;
    }

    private static Map<String, Object> toJsonMap(BlockLocation blockLocation) throws IOException {
        if (blockLocation == null) {
            return null;
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("length", blockLocation.getLength());
        m.put("offset", blockLocation.getOffset());
        m.put("corrupt", blockLocation.isCorrupt());
        m.put("storageTypes", JsonUtil.toJsonArray(blockLocation.getStorageTypes()));
        m.put("cachedHosts", blockLocation.getCachedHosts());
        m.put("hosts", blockLocation.getHosts());
        m.put("names", blockLocation.getNames());
        m.put("topologyPaths", blockLocation.getTopologyPaths());
        return m;
    }

    public static String toJsonString(BlockLocation[] locations) throws IOException {
        if (locations == null) {
            return null;
        }
        HashMap<String, Object[]> m = new HashMap<String, Object[]>();
        Object[] blockLocations = new Object[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            blockLocations[i] = JsonUtil.toJsonMap(locations[i]);
        }
        m.put(BlockLocation.class.getSimpleName(), blockLocations);
        return JsonUtil.toJsonString("BlockLocations", m);
    }
}

