/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.filter;

import com.sun.star.lang.XComponent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.office.OfficeContext;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.local.filter.Filter;
import org.jodconverter.local.filter.FilterChain;

public abstract class AbstractFilterChain
implements FilterChain {
    private final boolean readOnly;
    protected List<Filter> filters;
    protected int pos;

    public AbstractFilterChain() {
        this(false, new Filter[0]);
    }

    public AbstractFilterChain(Filter ... filters) {
        this(false, filters);
    }

    public AbstractFilterChain(boolean readOnly, Filter ... filters) {
        this.readOnly = readOnly;
        this.pos = 0;
        this.filters = Arrays.stream((Object[])Optional.of(filters).orElse(new Filter[0])).collect(Collectors.toList());
        if (readOnly) {
            this.filters = Collections.unmodifiableList(this.filters);
        }
    }

    @Override
    public void addFilter(@NonNull Filter filter) {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        this.filters.add(filter);
    }

    @Override
    public void doFilter(@NonNull OfficeContext context, @NonNull XComponent document) throws OfficeException {
        if (this.pos < this.filters.size()) {
            Filter filter = this.filters.get(this.pos++);
            this.doFilter(filter, context, document);
        }
    }

    protected void doFilter(@NonNull Filter filter, @NonNull OfficeContext context, @NonNull XComponent document) throws OfficeException {
        try {
            filter.doFilter(context, document, this);
        }
        catch (Exception ex) {
            throw new OfficeException("Could not apply filter " + filter.getClass().getName() + ".", (Throwable)ex);
        }
    }

    public void reset() {
        this.pos = 0;
    }
}

