/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.config.ConfigValidator;
import com.hazelcast.internal.locksupport.LockStoreInfo;
import com.hazelcast.internal.locksupport.LockSupportService;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.impl.ProviderHelper;
import com.hazelcast.internal.monitor.impl.LocalMultiMapStatsImpl;
import com.hazelcast.internal.partition.ChunkedMigrationAwareService;
import com.hazelcast.internal.partition.IPartition;
import com.hazelcast.internal.partition.MigrationEndpoint;
import com.hazelcast.internal.partition.PartitionMigrationEvent;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.services.LockInterceptorService;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.services.RemoteService;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.services.SplitBrainHandlerService;
import com.hazelcast.internal.services.SplitBrainProtectionAwareService;
import com.hazelcast.internal.services.StatisticsAwareService;
import com.hazelcast.internal.services.TransactionalService;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.ContextMutexFactory;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.map.impl.event.EventData;
import com.hazelcast.multimap.LocalMultiMapStats;
import com.hazelcast.multimap.impl.MultiMapContainer;
import com.hazelcast.multimap.impl.MultiMapContainerCollector;
import com.hazelcast.multimap.impl.MultiMapEventFilter;
import com.hazelcast.multimap.impl.MultiMapEventsDispatcher;
import com.hazelcast.multimap.impl.MultiMapEventsPublisher;
import com.hazelcast.multimap.impl.MultiMapMergeContainer;
import com.hazelcast.multimap.impl.MultiMapPartitionContainer;
import com.hazelcast.multimap.impl.MultiMapProxyImpl;
import com.hazelcast.multimap.impl.MultiMapRecord;
import com.hazelcast.multimap.impl.MultiMapValue;
import com.hazelcast.multimap.impl.operations.MergeOperation;
import com.hazelcast.multimap.impl.operations.MultiMapReplicationOperation;
import com.hazelcast.multimap.impl.txn.TransactionalMultiMapProxy;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.eventservice.EventPublishingService;
import com.hazelcast.spi.impl.eventservice.EventRegistration;
import com.hazelcast.spi.impl.eventservice.EventService;
import com.hazelcast.spi.impl.merge.AbstractContainerMerger;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionOn;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionService;
import com.hazelcast.transaction.TransactionalObject;
import com.hazelcast.transaction.impl.Transaction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;

public class MultiMapService
implements ManagedService,
RemoteService,
ChunkedMigrationAwareService,
EventPublishingService<EventData, EntryListener>,
TransactionalService,
StatisticsAwareService<LocalMultiMapStats>,
SplitBrainProtectionAwareService,
SplitBrainHandlerService,
LockInterceptorService<Data>,
DynamicMetricsProvider {
    public static final String SERVICE_NAME = "hz:impl:multiMapService";
    private static final Object NULL_OBJECT = new Object();
    private static final int STATS_MAP_INITIAL_CAPACITY = 1000;
    private static final int REPLICA_ADDRESS_TRY_COUNT = 3;
    private static final int REPLICA_ADDRESS_SLEEP_WAIT_MILLIS = 1000;
    private final NodeEngine nodeEngine;
    private final MultiMapPartitionContainer[] partitionContainers;
    private final ConcurrentMap<String, LocalMultiMapStatsImpl> statsMap = MapUtil.createConcurrentHashMap(1000);
    private final ConstructorFunction<String, LocalMultiMapStatsImpl> localMultiMapStatsConstructorFunction = key -> new LocalMultiMapStatsImpl();
    private final MultiMapEventsDispatcher dispatcher;
    private final MultiMapEventsPublisher publisher;
    private final SplitBrainProtectionService splitBrainProtectionService;
    private final ConcurrentMap<String, Object> splitBrainProtectionConfigCache = new ConcurrentHashMap<String, Object>();
    private final ContextMutexFactory splitBrainProtectionConfigCacheMutexFactory = new ContextMutexFactory();
    private final ConstructorFunction<String, Object> splitBrainProtectionConfigConstructor = new ConstructorFunction<String, Object>(){

        @Override
        public Object createNew(String name) {
            MultiMapConfig multiMapConfig = MultiMapService.this.nodeEngine.getConfig().findMultiMapConfig(name);
            String splitBrainProtectionName = multiMapConfig.getSplitBrainProtectionName();
            return splitBrainProtectionName == null ? NULL_OBJECT : splitBrainProtectionName;
        }
    };

    public MultiMapService(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.partitionContainers = this.createContainers(nodeEngine);
        this.dispatcher = new MultiMapEventsDispatcher(this, nodeEngine.getClusterService());
        this.publisher = new MultiMapEventsPublisher(nodeEngine);
        this.splitBrainProtectionService = nodeEngine.getSplitBrainProtectionService();
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        boolean dsMetricsEnabled;
        LockSupportService lockService = (LockSupportService)nodeEngine.getServiceOrNull("hz:impl:lockService");
        if (lockService != null) {
            lockService.registerLockStoreConstructor(SERVICE_NAME, key -> {
                String name = key.getObjectName();
                final MultiMapConfig multiMapConfig = nodeEngine.getConfig().findMultiMapConfig(name);
                return new LockStoreInfo(){

                    @Override
                    public int getBackupCount() {
                        return multiMapConfig.getBackupCount();
                    }

                    @Override
                    public int getAsyncBackupCount() {
                        return multiMapConfig.getAsyncBackupCount();
                    }
                };
            });
        }
        if (dsMetricsEnabled = nodeEngine.getProperties().getBoolean(ClusterProperty.METRICS_DATASTRUCTURES)) {
            nodeEngine.getMetricsRegistry().registerDynamicMetricsProvider(this);
        }
    }

    private MultiMapPartitionContainer[] createContainers(NodeEngine nodeEngine) {
        int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        MultiMapPartitionContainer[] partitionContainers = new MultiMapPartitionContainer[partitionCount];
        for (int partition = 0; partition < partitionCount; ++partition) {
            partitionContainers[partition] = new MultiMapPartitionContainer(this, partition);
        }
        return partitionContainers;
    }

    @Override
    public void reset() {
        for (MultiMapPartitionContainer container : this.partitionContainers) {
            if (container == null) continue;
            container.destroy();
        }
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    public MultiMapContainer getOrCreateCollectionContainer(int partitionId, String name) {
        return this.partitionContainers[partitionId].getOrCreateMultiMapContainer(name);
    }

    public MultiMapContainer getOrCreateCollectionContainerWithoutAccess(int partitionId, String name) {
        return this.partitionContainers[partitionId].getOrCreateMultiMapContainer(name, false);
    }

    public MultiMapPartitionContainer getPartitionContainer(int partitionId) {
        return this.partitionContainers[partitionId];
    }

    @Override
    public DistributedObject createDistributedObject(String name, UUID source, boolean local) {
        MultiMapConfig multiMapConfig = this.nodeEngine.getConfig().findMultiMapConfig(name);
        ConfigValidator.checkMultiMapConfig(multiMapConfig, this.nodeEngine.getSplitBrainMergePolicyProvider());
        return new MultiMapProxyImpl(multiMapConfig, this, this.nodeEngine, name);
    }

    @Override
    public void destroyDistributedObject(String name, boolean local) {
        for (MultiMapPartitionContainer container : this.partitionContainers) {
            if (container == null) continue;
            container.destroyMultiMap(name);
        }
        this.nodeEngine.getEventService().deregisterAllLocalListeners(SERVICE_NAME, name);
        this.splitBrainProtectionConfigCache.remove(name);
    }

    public Set<Data> localKeySet(String name) {
        HashSet<Data> keySet = new HashSet<Data>();
        for (int i = 0; i < this.nodeEngine.getPartitionService().getPartitionCount(); ++i) {
            IPartition partition = this.nodeEngine.getPartitionService().getPartition(i);
            boolean isLocalPartition = partition.isLocal();
            MultiMapPartitionContainer partitionContainer = this.getPartitionContainer(i);
            MultiMapContainer multiMapContainer = partitionContainer.getMultiMapContainer(name, isLocalPartition);
            if (multiMapContainer == null || !isLocalPartition) continue;
            keySet.addAll(multiMapContainer.keySet());
        }
        return keySet;
    }

    public SerializationService getSerializationService() {
        return this.nodeEngine.getSerializationService();
    }

    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    public void publishMultiMapEvent(String mapName, EntryEventType eventType, int numberOfEntriesAffected) {
        this.publisher.publishMultiMapEvent(mapName, eventType, numberOfEntriesAffected);
    }

    public final void publishEntryEvent(String multiMapName, EntryEventType eventType, Data key, Object newValue, Object oldValue) {
        this.publisher.publishEntryEvent(multiMapName, eventType, key, newValue, oldValue);
    }

    public UUID addListener(String name, @Nonnull EventListener listener, Data key, boolean includeValue) {
        EventService eventService = this.nodeEngine.getEventService();
        MultiMapEventFilter filter = new MultiMapEventFilter(includeValue, key);
        if (listener instanceof HazelcastInstanceAware) {
            HazelcastInstanceAware aware = (HazelcastInstanceAware)((Object)listener);
            aware.setHazelcastInstance(this.nodeEngine.getHazelcastInstance());
        }
        return eventService.registerListener(SERVICE_NAME, name, filter, listener).getId();
    }

    public CompletableFuture<UUID> addListenerAsync(String name, @Nonnull EventListener listener, Data key, boolean includeValue) {
        EventService eventService = this.nodeEngine.getEventService();
        MultiMapEventFilter filter = new MultiMapEventFilter(includeValue, key);
        if (listener instanceof HazelcastInstanceAware) {
            HazelcastInstanceAware aware = (HazelcastInstanceAware)((Object)listener);
            aware.setHazelcastInstance(this.nodeEngine.getHazelcastInstance());
        }
        return eventService.registerListenerAsync(SERVICE_NAME, name, filter, listener).thenApplyAsync(EventRegistration::getId, ConcurrencyUtil.CALLER_RUNS);
    }

    public UUID addLocalListener(String name, @Nonnull EventListener listener, Data key, boolean includeValue) {
        EventService eventService = this.nodeEngine.getEventService();
        MultiMapEventFilter filter = new MultiMapEventFilter(includeValue, key);
        if (listener instanceof HazelcastInstanceAware) {
            HazelcastInstanceAware aware = (HazelcastInstanceAware)((Object)listener);
            aware.setHazelcastInstance(this.nodeEngine.getHazelcastInstance());
        }
        return eventService.registerLocalListener(SERVICE_NAME, name, filter, listener).getId();
    }

    public boolean removeListener(String name, UUID registrationId) {
        EventService eventService = this.nodeEngine.getEventService();
        return eventService.deregisterListener(SERVICE_NAME, name, registrationId);
    }

    public Future<Boolean> removeListenerAsync(String name, UUID registrationId) {
        EventService eventService = this.nodeEngine.getEventService();
        return eventService.deregisterListenerAsync(SERVICE_NAME, name, registrationId);
    }

    @Override
    public Collection<ServiceNamespace> getAllServiceNamespaces(PartitionReplicationEvent event) {
        MultiMapPartitionContainer partitionContainer = this.partitionContainers[event.getPartitionId()];
        return partitionContainer.getAllNamespaces(event.getReplicaIndex());
    }

    @Override
    public boolean isKnownServiceNamespace(ServiceNamespace namespace) {
        return namespace instanceof ObjectNamespace && SERVICE_NAME.equals(namespace.getServiceName());
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent partitionMigrationEvent) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        MultiMapPartitionContainer partitionContainer = this.partitionContainers[event.getPartitionId()];
        return this.prepareReplicationOperation(event, partitionContainer.getAllNamespaces(event.getReplicaIndex()));
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        if (namespaces.isEmpty()) {
            return null;
        }
        MultiMapPartitionContainer partitionContainer = this.partitionContainers[event.getPartitionId()];
        int replicaIndex = event.getReplicaIndex();
        Map<String, Map<Data, MultiMapValue>> map = MapUtil.createHashMap(namespaces.size());
        for (ServiceNamespace namespace : namespaces) {
            assert (this.isKnownServiceNamespace(namespace)) : namespace + " is not a MultiMapService namespace!";
            ObjectNamespace ns = (ObjectNamespace)namespace;
            MultiMapContainer container = (MultiMapContainer)partitionContainer.containerMap.get(ns.getObjectName());
            if (container == null || container.getConfig().getTotalBackupCount() < replicaIndex) continue;
            map.put(ns.getObjectName(), container.getMultiMapValues());
        }
        return map.isEmpty() ? null : new MultiMapReplicationOperation(map).setServiceName(SERVICE_NAME).setNodeEngine(this.nodeEngine);
    }

    public void insertMigratedData(int partitionId, Map<String, Map<Data, MultiMapValue>> map) {
        for (Map.Entry<String, Map<Data, MultiMapValue>> entry : map.entrySet()) {
            String name = entry.getKey();
            MultiMapContainer container = this.getOrCreateCollectionContainerWithoutAccess(partitionId, name);
            Map<Data, MultiMapValue> collections = entry.getValue();
            long maxRecordId = -1L;
            for (Map.Entry<Data, MultiMapValue> multiMapValueEntry : collections.entrySet()) {
                MultiMapValue multiMapValue = multiMapValueEntry.getValue();
                container.getMultiMapValues().put(multiMapValueEntry.getKey(), multiMapValue);
                long recordId = this.getMaxRecordId(multiMapValue);
                maxRecordId = Math.max(maxRecordId, recordId);
            }
            container.setId(maxRecordId);
        }
    }

    private long getMaxRecordId(MultiMapValue multiMapValue) {
        long maxRecordId = -1L;
        for (MultiMapRecord record : multiMapValue.getCollection(false)) {
            maxRecordId = Math.max(maxRecordId, record.getRecordId());
        }
        return maxRecordId;
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearMapsHavingLesserBackupCountThan(event.getPartitionId(), event.getNewReplicaIndex());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearMapsHavingLesserBackupCountThan(event.getPartitionId(), event.getCurrentReplicaIndex());
        }
    }

    private void clearMapsHavingLesserBackupCountThan(int partitionId, int thresholdReplicaIndex) {
        MultiMapPartitionContainer partitionContainer = this.partitionContainers[partitionId];
        if (partitionContainer == null) {
            return;
        }
        ConcurrentMap<String, MultiMapContainer> containerMap = partitionContainer.containerMap;
        if (thresholdReplicaIndex < 0) {
            for (MultiMapContainer container : containerMap.values()) {
                container.destroy();
            }
            containerMap.clear();
            return;
        }
        Iterator iterator = containerMap.values().iterator();
        while (iterator.hasNext()) {
            MultiMapContainer container = (MultiMapContainer)iterator.next();
            if (thresholdReplicaIndex <= container.getConfig().getTotalBackupCount()) continue;
            container.destroy();
            iterator.remove();
        }
    }

    LocalMultiMapStats createStats(String name) {
        LocalMultiMapStatsImpl stats = this.getLocalMultiMapStatsImpl(name);
        long ownedEntryCount = 0L;
        long backupEntryCount = 0L;
        long hits = 0L;
        long lockedEntryCount = 0L;
        long lastAccessTime = 0L;
        long lastUpdateTime = 0L;
        ClusterService clusterService = this.nodeEngine.getClusterService();
        MultiMapConfig config = this.nodeEngine.getConfig().findMultiMapConfig(name);
        int backupCount = config.getTotalBackupCount();
        Address thisAddress = clusterService.getThisAddress();
        for (int partitionId = 0; partitionId < this.nodeEngine.getPartitionService().getPartitionCount(); ++partitionId) {
            Address owner;
            IPartition partition = this.nodeEngine.getPartitionService().getPartition(partitionId, false);
            MultiMapPartitionContainer partitionContainer = this.getPartitionContainer(partitionId);
            MultiMapContainer multiMapContainer = partitionContainer.getMultiMapContainer(name, false);
            if (multiMapContainer == null || (owner = partition.getOwnerOrNull()) == null) continue;
            if (owner.equals(thisAddress)) {
                lockedEntryCount += multiMapContainer.getLockedCount();
                lastAccessTime = Math.max(lastAccessTime, multiMapContainer.getLastAccessTime());
                lastUpdateTime = Math.max(lastUpdateTime, multiMapContainer.getLastUpdateTime());
                for (MultiMapValue multiMapValue : multiMapContainer.getMultiMapValues().values()) {
                    hits += multiMapValue.getHits();
                    ownedEntryCount += (long)multiMapValue.getCollection(false).size();
                }
                continue;
            }
            for (int j = 1; j <= backupCount; ++j) {
                Address replicaAddress = this.getReplicaAddress(partition, backupCount, j);
                if (replicaAddress == null || !replicaAddress.equals(thisAddress)) continue;
                for (MultiMapValue multiMapValue : multiMapContainer.getMultiMapValues().values()) {
                    backupEntryCount += (long)multiMapValue.getCollection(false).size();
                }
            }
        }
        stats.setOwnedEntryCount(ownedEntryCount);
        stats.setBackupEntryCount(backupEntryCount);
        stats.setHits(hits);
        stats.setLockedEntryCount(lockedEntryCount);
        stats.setBackupCount(backupCount);
        stats.setLastAccessTime(lastAccessTime);
        stats.setLastUpdateTime(lastUpdateTime);
        return stats;
    }

    public LocalMultiMapStatsImpl getLocalMultiMapStatsImpl(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.statsMap, name, this.localMultiMapStatsConstructorFunction);
    }

    @Override
    public <T extends TransactionalObject> T createTransactionalObject(String name, Transaction transaction) {
        return (T)new TransactionalMultiMapProxy(this.nodeEngine, this, name, transaction);
    }

    @Override
    public void rollbackTransaction(UUID transactionId) {
    }

    @Override
    public void dispatchEvent(EventData event, EntryListener listener) {
        this.dispatcher.dispatchEvent(event, listener);
    }

    @Override
    public Map<String, LocalMultiMapStats> getStats() {
        HashMap<String, LocalMultiMapStats> multiMapStats = Collections.EMPTY_MAP;
        for (int i = 0; i < this.partitionContainers.length; ++i) {
            MultiMapPartitionContainer container = this.partitionContainers[i];
            if (container == null || container.containerMap.isEmpty()) continue;
            for (String name : container.containerMap.keySet()) {
                if (multiMapStats.containsKey(name) || !container.getMultiMapContainer((String)name, (boolean)false).config.isStatisticsEnabled()) continue;
                if (multiMapStats == Collections.EMPTY_MAP) {
                    multiMapStats = new HashMap<String, LocalMultiMapStats>();
                }
                multiMapStats.put(name, this.createStats(name));
            }
        }
        return multiMapStats;
    }

    private Address getReplicaAddress(IPartition partition, int backupCount, int replicaIndex) {
        Address replicaAddress = partition.getReplicaAddress(replicaIndex);
        int tryCount = 3;
        int maxAllowedBackupCount = Math.min(backupCount, this.nodeEngine.getPartitionService().getMaxAllowedBackupCount());
        while (maxAllowedBackupCount > replicaIndex && replicaAddress == null && tryCount-- > 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw ExceptionUtil.rethrow(e);
            }
            replicaAddress = partition.getReplicaAddress(replicaIndex);
        }
        return replicaAddress;
    }

    @Override
    public String getSplitBrainProtectionName(String name) {
        Object splitBrainProtectionName = ConcurrencyUtil.getOrPutSynchronized(this.splitBrainProtectionConfigCache, name, this.splitBrainProtectionConfigCacheMutexFactory, this.splitBrainProtectionConfigConstructor);
        return splitBrainProtectionName == NULL_OBJECT ? null : (String)splitBrainProtectionName;
    }

    public void ensureNoSplitBrain(String distributedObjectName, SplitBrainProtectionOn requiredSplitBrainProtectionPermissionType) {
        this.splitBrainProtectionService.ensureNoSplitBrain(this.getSplitBrainProtectionName(distributedObjectName), requiredSplitBrainProtectionPermissionType);
    }

    @Override
    public Runnable prepareMergeRunnable() {
        MultiMapContainerCollector collector = new MultiMapContainerCollector(this.nodeEngine, this.partitionContainers);
        collector.run();
        return new Merger(collector);
    }

    @Override
    public void onBeforeLock(String distributedObjectName, Data key) {
        int partitionId = this.nodeEngine.getPartitionService().getPartitionId(key);
        MultiMapPartitionContainer partitionContainer = this.getPartitionContainer(partitionId);
        partitionContainer.getOrCreateMultiMapContainer(distributedObjectName);
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        ProviderHelper.provide(descriptor, context, "multiMap", this.getStats());
    }

    public static String lookupNamespace(NodeEngine engine, String mapName) {
        MultiMapConfig config;
        if (engine.getNamespaceService().isEnabled() && (config = engine.getConfig().getMultiMapConfig(mapName)) != null) {
            return config.getUserCodeNamespace();
        }
        return null;
    }

    private class Merger
    extends AbstractContainerMerger<MultiMapContainer, Collection<Object>, SplitBrainMergeTypes.MultiMapMergeTypes<Object, Object>> {
        Merger(MultiMapContainerCollector collector) {
            super(collector, MultiMapService.this.nodeEngine);
        }

        @Override
        protected String getLabel() {
            return "MultiMap";
        }

        @Override
        public void runInternal() {
            for (Map.Entry entry : this.collector.getCollectedContainers().entrySet()) {
                int partitionId = (Integer)entry.getKey();
                Collection containers = (Collection)entry.getValue();
                for (MultiMapContainer container : containers) {
                    String name = container.getObjectNamespace().getObjectName();
                    SplitBrainMergePolicy<Collection<Object>, SplitBrainMergeTypes.MultiMapMergeTypes<Object, Object>, Collection<Object>> mergePolicy = this.getMergePolicy(container.getConfig().getMergePolicyConfig());
                    int batchSize = container.getConfig().getMergePolicyConfig().getBatchSize();
                    ArrayList<MultiMapMergeContainer> mergeContainers = new ArrayList<MultiMapMergeContainer>(batchSize);
                    for (Map.Entry multiMapValueEntry : container.getMultiMapValues().entrySet()) {
                        Data key = (Data)multiMapValueEntry.getKey();
                        MultiMapValue multiMapValue = (MultiMapValue)multiMapValueEntry.getValue();
                        Collection<MultiMapRecord> records = multiMapValue.getCollection(false);
                        MultiMapMergeContainer mergeContainer = new MultiMapMergeContainer(key, records, container.getCreationTime(), container.getLastAccessTime(), container.getLastUpdateTime(), multiMapValue.getHits());
                        mergeContainers.add(mergeContainer);
                        if (mergeContainers.size() != batchSize) continue;
                        this.sendBatch(partitionId, name, mergePolicy, mergeContainers);
                        mergeContainers = new ArrayList(batchSize);
                    }
                    if (mergeContainers.isEmpty()) continue;
                    this.sendBatch(partitionId, name, mergePolicy, mergeContainers);
                }
            }
        }

        private void sendBatch(int partitionId, String name, SplitBrainMergePolicy<Collection<Object>, SplitBrainMergeTypes.MultiMapMergeTypes<Object, Object>, Collection<Object>> mergePolicy, List<MultiMapMergeContainer> mergeContainers) {
            MergeOperation operation = new MergeOperation(name, mergeContainers, mergePolicy);
            this.invoke(MultiMapService.SERVICE_NAME, operation, partitionId);
        }
    }
}

