/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import java.io.IOException;
import org.asteriskjava.AsteriskVersion;
import org.asteriskjava.lock.Lockable;
import org.asteriskjava.lock.Locker;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.internal.ActionBuilder;
import org.asteriskjava.manager.internal.ActionBuilderImpl;
import org.asteriskjava.manager.internal.ManagerWriter;
import org.asteriskjava.util.SocketConnectionFacade;

public class ManagerWriterImpl
extends Lockable
implements ManagerWriter {
    private final ActionBuilder actionBuilder = new ActionBuilderImpl();
    private SocketConnectionFacade socket;

    @Override
    public void setTargetVersion(AsteriskVersion version) {
        this.actionBuilder.setTargetVersion(version);
    }

    @Override
    public void setSocket(SocketConnectionFacade socket) {
        try (Locker.LockCloser closer = this.withLock();){
            this.socket = socket;
        }
    }

    @Override
    public void sendAction(ManagerAction action, String internalActionId) throws IOException {
        try (Locker.LockCloser closer = this.withLock();){
            if (this.socket == null) {
                throw new IllegalStateException("Unable to send action: socket is null");
            }
            String actionString = this.actionBuilder.buildAction(action, internalActionId);
            this.socket.write(actionString);
            this.socket.flush();
        }
    }
}

