/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.mediaserver;

import org.kurento.client.CertificateKeyType;
import org.kurento.client.MediaPipeline;
import org.kurento.client.MediaProfileSpecType;
import org.kurento.client.PlayerEndpoint;
import org.kurento.client.RecorderEndpoint;
import org.kurento.client.RtpEndpoint;
import org.kurento.client.WebRtcEndpoint;

public abstract class AbstractStream {
    protected final String sid;
    protected final String uid;

    protected AbstractStream(String sid, String uid) {
        this.sid = sid;
        this.uid = uid;
    }

    public String getSid() {
        return this.sid;
    }

    public String getUid() {
        return this.uid;
    }

    public void release() {
        this.release(true);
    }

    public abstract void release(boolean var1);

    public static WebRtcEndpoint createWebRtcEndpoint(MediaPipeline pipeline, Boolean recv, CertificateKeyType certificateType) {
        WebRtcEndpoint.Builder builder = new WebRtcEndpoint.Builder(pipeline);
        if (CertificateKeyType.RSA == certificateType) {
            builder.withCertificateKeyType(CertificateKeyType.RSA);
        } else if (CertificateKeyType.ECDSA == certificateType) {
            builder.withCertificateKeyType(CertificateKeyType.ECDSA);
        }
        if (recv != null) {
            if (recv.booleanValue()) {
                builder.recvonly();
            } else {
                builder.sendonly();
            }
        }
        return (WebRtcEndpoint)builder.build();
    }

    public static RecorderEndpoint createRecorderEndpoint(MediaPipeline pipeline, String path, MediaProfileSpecType profile) {
        return (RecorderEndpoint)new RecorderEndpoint.Builder(pipeline, path).stopOnEndOfStream().withMediaProfile(profile).build();
    }

    public static PlayerEndpoint createPlayerEndpoint(MediaPipeline pipeline, String path) {
        return (PlayerEndpoint)new PlayerEndpoint.Builder(pipeline, path).build();
    }

    public static RtpEndpoint createRtpEndpoint(MediaPipeline pipeline) {
        return (RtpEndpoint)new RtpEndpoint.Builder(pipeline).build();
    }
}

