/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.server;

import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.internal.nio.ConnectionListenable;
import com.hazelcast.internal.server.NetworkStats;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.server.ServerConnectionManager;
import com.hazelcast.internal.server.ServerContext;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Server
extends ConnectionListenable<ServerConnection> {
    public ServerContext getContext();

    public ServerConnectionManager getConnectionManager(EndpointQualifier var1);

    @Nonnull
    public Collection<ServerConnection> getConnections();

    default public int connectionCount(@Nullable Predicate<ServerConnection> predicate) {
        if (predicate == null) {
            return this.getConnections().size();
        }
        return (int)this.getConnections().stream().filter(predicate).count();
    }

    default public int connectionCount() {
        return this.connectionCount(null);
    }

    public Map<EndpointQualifier, NetworkStats> getNetworkStats();

    public boolean isLive();

    public void start();

    public void stop();

    public void shutdown();
}

