/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.namespace.impl;

import com.hazelcast.jet.impl.deployment.MapResourceClassLoader;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public final class NamespaceThreadLocalContext {
    private static final ThreadLocal<NamespaceThreadLocalContext> NS_THREAD_LOCAL = new ThreadLocal();
    private final ClassLoader classLoader;
    private int counter = 1;
    private NamespaceThreadLocalContext previous;

    private NamespaceThreadLocalContext(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private NamespaceThreadLocalContext(ClassLoader classLoader, NamespaceThreadLocalContext previous) {
        this.classLoader = classLoader;
        this.previous = previous;
    }

    private void incCounter() {
        ++this.counter;
    }

    private int decCounter() {
        return --this.counter;
    }

    public String toString() {
        return "NamespaceThreadLocalContext{classLoader=" + this.classLoader + ", counter=" + this.counter + "}";
    }

    public static void onStartNsAware(ClassLoader classLoader) {
        assert (classLoader != null);
        NamespaceThreadLocalContext tlContext = NS_THREAD_LOCAL.get();
        if (tlContext == null) {
            tlContext = new NamespaceThreadLocalContext(classLoader);
            NS_THREAD_LOCAL.set(tlContext);
        } else {
            if (!tlContext.classLoader.equals(classLoader)) {
                tlContext = new NamespaceThreadLocalContext(classLoader, tlContext);
                NS_THREAD_LOCAL.set(tlContext);
                return;
            }
            tlContext.incCounter();
        }
    }

    public static void onCompleteNsAware(ClassLoader classLoader) {
        NamespaceThreadLocalContext.onCompleteNsAware(tlContext -> Objects.equals(tlContext.classLoader, classLoader), tlContext -> "Attempted to complete NSTLContext for classLoader " + classLoader + " but there is an existing context: " + tlContext);
    }

    public static void onCompleteNsAware(String namespace) {
        NamespaceThreadLocalContext.onCompleteNsAware(tlContext -> {
            MapResourceClassLoader loader;
            ClassLoader patt4315$temp = tlContext.classLoader;
            return patt4315$temp instanceof MapResourceClassLoader && Objects.equals((loader = (MapResourceClassLoader)patt4315$temp).getUserCodeNamespace(), namespace);
        }, tlContext -> "Attempted to complete NSTLContext for namespace " + namespace + " but there is an existing context: " + tlContext);
    }

    private static void onCompleteNsAware(Predicate<NamespaceThreadLocalContext> equalityFunc, Function<NamespaceThreadLocalContext, String> errorMessageFunc) {
        NamespaceThreadLocalContext tlContext = NS_THREAD_LOCAL.get();
        if (tlContext != null) {
            if (!equalityFunc.test(tlContext)) {
                throw new IllegalStateException(errorMessageFunc.apply(tlContext));
            }
            int count = tlContext.decCounter();
            if (count == 0) {
                if (tlContext.previous != null) {
                    NS_THREAD_LOCAL.set(tlContext.previous);
                    tlContext.previous = null;
                } else {
                    NS_THREAD_LOCAL.remove();
                }
            }
        }
    }

    public static ClassLoader getClassLoader() {
        NamespaceThreadLocalContext tlContext = NS_THREAD_LOCAL.get();
        if (tlContext == null) {
            return null;
        }
        return tlContext.classLoader;
    }
}

