/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config.override;

import com.hazelcast.internal.util.StringUtil;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

class SystemPropertiesConfigParser {
    private final String prefix;
    private final String rootNode;

    SystemPropertiesConfigParser(String prefix, String rootNode) {
        this.prefix = prefix;
        this.rootNode = rootNode;
    }

    static SystemPropertiesConfigParser client() {
        return new SystemPropertiesConfigParser("hz-client.", "hazelcast-client");
    }

    static SystemPropertiesConfigParser member() {
        return new SystemPropertiesConfigParser("hz.", "hazelcast");
    }

    Map<String, String> parse(Properties properties) {
        return properties.entrySet().stream().mapMulti((e, consumer) -> {
            Object patt1739$temp = e.getKey();
            if (patt1739$temp instanceof String) {
                String keyString = (String)patt1739$temp;
                Object patt1783$temp = e.getValue();
                if (patt1783$temp instanceof String) {
                    String valueString = (String)patt1783$temp;
                    if (keyString.startsWith(this.prefix)) {
                        consumer.accept(Map.entry(keyString, valueString));
                    }
                }
            }
        }).collect(Collectors.toMap(this::processKey, Map.Entry::getValue));
    }

    private String processKey(Map.Entry<String, ?> e) {
        return StringUtil.lowerCaseInternal(e.getKey().replace(" ", "").replaceFirst(this.prefix, this.rootNode + "."));
    }
}

