/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapAddInterceptorCodec;
import com.hazelcast.client.impl.protocol.task.AbstractMultiTargetMessageTask;
import com.hazelcast.cluster.Member;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.AddInterceptorOperationSupplier;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.security.permission.UserCodeNamespacePermission;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.security.Permission;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;

public class MapAddInterceptorMessageTask
extends AbstractMultiTargetMessageTask<MapAddInterceptorCodec.RequestParameters> {
    private transient String id;

    public MapAddInterceptorMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Supplier<Operation> createOperationSupplier() {
        MapService mapService = (MapService)this.getService("hz:impl:mapService");
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        MapInterceptor mapInterceptor = NamespaceUtil.callWithNamespace(this.nodeEngine, MapService.lookupNamespace(this.nodeEngine, ((MapAddInterceptorCodec.RequestParameters)this.parameters).name), () -> (MapInterceptor)this.serializationService.toObject(((MapAddInterceptorCodec.RequestParameters)this.parameters).interceptor));
        this.id = mapServiceContext.generateInterceptorId(((MapAddInterceptorCodec.RequestParameters)this.parameters).name, mapInterceptor);
        return new AddInterceptorOperationSupplier(((MapAddInterceptorCodec.RequestParameters)this.parameters).name, this.id, mapInterceptor);
    }

    @Override
    protected Object reduce(Map<Member, Object> map) throws Throwable {
        for (Object result : map.values()) {
            if (!(result instanceof Throwable)) continue;
            Throwable throwable = (Throwable)result;
            throw throwable;
        }
        return this.id;
    }

    @Override
    public Collection<Member> getTargets() {
        return this.nodeEngine.getClusterService().getMembers();
    }

    @Override
    protected MapAddInterceptorCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapAddInterceptorCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapAddInterceptorCodec.encodeResponse((String)response);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.getDistributedObjectName(), "intercept");
    }

    @Override
    public Permission getUserCodeNamespacePermission() {
        String namespace = MapService.lookupNamespace(this.nodeEngine, this.getDistributedObjectName());
        return namespace != null ? new UserCodeNamespacePermission(namespace, "use") : null;
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapAddInterceptorCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "addInterceptor";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((MapAddInterceptorCodec.RequestParameters)this.parameters).interceptor};
    }
}

