/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.code;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.detect.AutoDetectReader;
import org.apache.tika.detect.EncodingDetector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractEncodingDetectorParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.codelibs.jhighlight.renderer.Renderer;
import org.codelibs.jhighlight.renderer.XhtmlRendererFactory;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.NodeFilter;
import org.jsoup.select.NodeTraversor;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SourceCodeParser
extends AbstractEncodingDetectorParser {
    private static final long serialVersionUID = -4543476498190054160L;
    private static final Pattern AUTHORPATTERN = Pattern.compile("(?im)@author (.*) *$");
    private static final Map<MediaType, String> TYPES_TO_RENDERER = new HashMap<MediaType, String>(){
        private static final long serialVersionUID = -741976157563751152L;
        {
            this.put(MediaType.text((String)"x-c++src"), "cpp");
            this.put(MediaType.text((String)"x-java-source"), "java");
            this.put(MediaType.text((String)"x-groovy"), "groovy");
        }
    };

    public SourceCodeParser() {
    }

    public SourceCodeParser(EncodingDetector encodingDetector) {
        super(encodingDetector);
    }

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return TYPES_TO_RENDERER.keySet();
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        try (AutoDetectReader reader = new AutoDetectReader((InputStream)CloseShieldInputStream.wrap((InputStream)stream), metadata, this.getEncodingDetector(context));){
            String line;
            Charset charset = reader.getCharset();
            String mediaType = metadata.get("Content-Type");
            String name = metadata.get("resourceName");
            MediaType type = null;
            if (mediaType == null) {
                throw new TikaException("media type must be set in metadata before parse");
            }
            type = MediaType.parse((String)mediaType);
            metadata.set("Content-Type", type.toString());
            metadata.set("Content-Encoding", charset.name());
            StringBuilder out = new StringBuilder();
            int nbLines = 0;
            while ((line = reader.readLine()) != null) {
                out.append(line).append(System.getProperty("line.separator"));
                String author = this.parserAuthor(line);
                if (author != null) {
                    metadata.add(TikaCoreProperties.CREATOR, author);
                }
                ++nbLines;
            }
            metadata.set("LoC", String.valueOf(nbLines));
            Renderer renderer = this.getRenderer(type.toString());
            String codeAsHtml = renderer.highlight(name, out.toString(), charset.name(), false);
            Document document = Jsoup.parse((String)codeAsHtml);
            document.quirksMode(Document.QuirksMode.quirks);
            XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
            xhtml.startDocument();
            try {
                NodeTraversor.filter((NodeFilter)new TikaNodeFilter((ContentHandler)xhtml), (Node)document);
            }
            catch (RuntimeSAXException e) {
                throw e.getWrapped();
            }
            finally {
                xhtml.endDocument();
            }
        }
    }

    private Renderer getRenderer(String mimeType) throws TikaException {
        MediaType mt = MediaType.parse((String)mimeType);
        String type = TYPES_TO_RENDERER.get(mt);
        if (type == null) {
            throw new TikaException("unparseable content type " + mimeType);
        }
        return XhtmlRendererFactory.getRenderer((String)type);
    }

    private String parserAuthor(String line) {
        Matcher m = AUTHORPATTERN.matcher(line);
        if (m.find()) {
            return m.group(1).trim();
        }
        return null;
    }

    private static class RuntimeSAXException
    extends RuntimeException {
        private SAXException wrapped;

        private RuntimeSAXException(SAXException e) {
            this.wrapped = e;
        }

        SAXException getWrapped() {
            return this.wrapped;
        }
    }

    private static class TikaNodeFilter
    implements NodeFilter {
        boolean ignore = true;
        ContentHandler handler;

        private TikaNodeFilter(ContentHandler handler) {
            this.handler = handler;
        }

        public NodeFilter.FilterResult head(Node node, int i) {
            if ("html".equals(node.nodeName())) {
                this.ignore = false;
            }
            if (this.ignore) {
                return NodeFilter.FilterResult.CONTINUE;
            }
            if (node instanceof TextNode) {
                String txt = ((TextNode)node).getWholeText();
                if (txt != null) {
                    char[] chars = txt.toCharArray();
                    try {
                        if (chars.length > 0) {
                            this.handler.characters(chars, 0, chars.length);
                        }
                    }
                    catch (SAXException e) {
                        throw new RuntimeSAXException(e);
                    }
                }
                return NodeFilter.FilterResult.CONTINUE;
            }
            if (node instanceof DataNode) {
                String txt = ((DataNode)node).getWholeData();
                if (txt != null) {
                    char[] chars = txt.toCharArray();
                    try {
                        if (chars.length > 0) {
                            this.handler.characters(chars, 0, chars.length);
                        }
                    }
                    catch (SAXException e) {
                        throw new RuntimeSAXException(e);
                    }
                }
                return NodeFilter.FilterResult.CONTINUE;
            }
            AttributesImpl attributes = new AttributesImpl();
            for (Attribute jsoupAttr : node.attributes()) {
                attributes.addAttribute("", jsoupAttr.getKey(), jsoupAttr.getKey(), "", jsoupAttr.getValue());
            }
            try {
                this.handler.startElement("", node.nodeName(), node.nodeName(), attributes);
            }
            catch (SAXException e) {
                throw new RuntimeSAXException(e);
            }
            return NodeFilter.FilterResult.CONTINUE;
        }

        public NodeFilter.FilterResult tail(Node node, int i) {
            if ("html".equals(node.nodeName())) {
                this.ignore = true;
            }
            if (this.ignore) {
                return NodeFilter.FilterResult.CONTINUE;
            }
            if (node instanceof TextNode || node instanceof DataNode) {
                return NodeFilter.FilterResult.CONTINUE;
            }
            try {
                this.handler.endElement("", node.nodeName(), node.nodeName());
            }
            catch (SAXException e) {
                throw new RuntimeSAXException(e);
            }
            return NodeFilter.FilterResult.CONTINUE;
        }
    }
}

