/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.core.ldap;

import java.util.Properties;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.openmeetings.core.ldap.LdapLoginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapOptions {
    private static final Logger log = LoggerFactory.getLogger(LdapOptions.class);
    private static final String EMPTY_FORMAT = "%s";
    public static final String CONFIGKEY_LDAP_HOST = "ldap_conn_host";
    public static final String CONFIGKEY_LDAP_PORT = "ldap_conn_port";
    private static final String CONFIGKEY_LDAP_SECURE = "ldap_conn_secure";
    public static final String CONFIGKEY_LDAP_ADMIN_DN = "ldap_admin_dn";
    public static final String CONFIGKEY_LDAP_ADMIN_PASSWD = "ldap_passwd";
    public static final String CONFIGKEY_LDAP_AUTH_TYPE = "ldap_auth_type";
    private static final String CONFIGKEY_LDAP_PROV_TYPE = "ldap_provisionning";
    private static final String CONFIGKEY_LDAP_USE_LOWER_CASE = "ldap_use_lower_case";
    private static final String CONFIGKEY_LDAP_USE_ADMIN_4ATTRS = "ldap_use_admin_to_get_attrs";
    private static final String CONFIGKEY_LDAP_DEREF_MODE = "ldap_deref_mode";
    private static final String CONFIGKEY_LDAP_GROUP_MODE = "ldap_group_mode";
    public static final String CONFIGKEY_LDAP_SEARCH_BASE = "ldap_search_base";
    private static final String CONFIGKEY_LDAP_SEARCH_QUERY = "ldap_search_query";
    public static final String CONFIGKEY_LDAP_SEARCH_SCOPE = "ldap_search_scope";
    private static final String CONFIGKEY_LDAP_SYNC_PASSWD_OM = "ldap_sync_password_to_om";
    static final String CONFIGKEY_LDAP_TIMEZONE_NAME = "ldap_user_timezone";
    private static final String CONFIGKEY_LDAP_USERDN_FORMAT = "ldap_userdn_format";
    private static final String CONFIGKEY_LDAP_GROUP_QUERY = "ldap_group_query";
    private static final String CONFIGKEY_LDAP_IMPORT_QUERY = "ldap_import_query";
    public static final String CONFIGKEY_LDAP_PICTURE_URI = "ldap_user_picture_uri";
    LdapLoginManager.AuthType type = LdapLoginManager.AuthType.SIMPLEBIND;
    LdapLoginManager.Provisionning prov = LdapLoginManager.Provisionning.AUTOCREATE;
    AliasDerefMode derefMode = AliasDerefMode.DEREF_ALWAYS;
    LdapLoginManager.GroupMode groupMode = LdapLoginManager.GroupMode.NONE;
    boolean useLowerCase = false;
    boolean useAdminForAttrs = true;
    String host = null;
    int port = 389;
    boolean secure = false;
    String adminDn = null;
    String adminPasswd = null;
    String searchBase = "";
    String searchQuery = "%s";
    SearchScope scope = SearchScope.ONELEVEL;
    boolean syncPasswd = false;
    String tz = null;
    String groupQuery = "%s";
    String userDn = "%s";
    String pictureUri = null;
    String importQuery = null;

    public LdapOptions(Properties config) {
        String useLowerCaseProp = config.getProperty(CONFIGKEY_LDAP_USE_LOWER_CASE, "false");
        this.useLowerCase = "true".equals(useLowerCaseProp);
        String authType = config.getProperty(CONFIGKEY_LDAP_AUTH_TYPE, "");
        try {
            this.type = LdapLoginManager.AuthType.valueOf(authType);
        }
        catch (Exception e) {
            log.error("ConfigKey in Ldap Config contains invalid auth type : '{}' -> Defaulting to {}", (Object)authType, (Object)this.type);
        }
        String provType = config.getProperty(CONFIGKEY_LDAP_PROV_TYPE, "");
        try {
            this.prov = LdapLoginManager.Provisionning.valueOf(provType);
        }
        catch (Exception e) {
            log.error("ConfigKey in Ldap Config contains invalid provisionning type : '{}' -> Defaulting to {}", (Object)provType, (Object)this.prov);
        }
        String derefModeProp = config.getProperty(CONFIGKEY_LDAP_DEREF_MODE, "");
        try {
            this.derefMode = AliasDerefMode.getDerefMode((String)derefModeProp);
        }
        catch (Exception e) {
            log.error("ConfigKey in Ldap Config contains invalid deref mode : '{}' -> Defaulting to {}", (Object)derefModeProp, (Object)this.derefMode);
        }
        if (LdapLoginManager.AuthType.NONE == this.type && LdapLoginManager.Provisionning.NONE == this.prov) {
            throw new RuntimeException("Both AuthType and Provisionning are NONE!");
        }
        try {
            this.useAdminForAttrs = "true".equals(config.getProperty(CONFIGKEY_LDAP_USE_ADMIN_4ATTRS, ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.groupMode = LdapLoginManager.GroupMode.valueOf(config.getProperty(CONFIGKEY_LDAP_GROUP_MODE, "NONE"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (LdapLoginManager.AuthType.NONE == this.type && !this.useAdminForAttrs) {
            throw new RuntimeException("Unable to get Attributes, please change Auth type and/or Use Admin to get attributes");
        }
        this.host = config.getProperty(CONFIGKEY_LDAP_HOST);
        this.port = NumberUtils.toInt((String)config.getProperty(CONFIGKEY_LDAP_PORT), (int)389);
        this.secure = "true".equals(config.getProperty(CONFIGKEY_LDAP_SECURE, "false"));
        this.adminDn = config.getProperty(CONFIGKEY_LDAP_ADMIN_DN);
        this.adminPasswd = config.getProperty(CONFIGKEY_LDAP_ADMIN_PASSWD);
        this.searchBase = config.getProperty(CONFIGKEY_LDAP_SEARCH_BASE, "");
        this.searchQuery = config.getProperty(CONFIGKEY_LDAP_SEARCH_QUERY, EMPTY_FORMAT);
        this.scope = SearchScope.valueOf((String)config.getProperty(CONFIGKEY_LDAP_SEARCH_SCOPE, SearchScope.ONELEVEL.name()));
        this.syncPasswd = "true".equals(config.getProperty(CONFIGKEY_LDAP_SYNC_PASSWD_OM, ""));
        this.tz = config.getProperty(CONFIGKEY_LDAP_TIMEZONE_NAME, null);
        this.groupQuery = config.getProperty(CONFIGKEY_LDAP_GROUP_QUERY, EMPTY_FORMAT);
        this.userDn = config.getProperty(CONFIGKEY_LDAP_USERDN_FORMAT, EMPTY_FORMAT);
        this.pictureUri = config.getProperty(CONFIGKEY_LDAP_PICTURE_URI, null);
        this.importQuery = config.getProperty(CONFIGKEY_LDAP_IMPORT_QUERY, "(objectClass=*)");
    }
}

